/*
            scratch.c                                       { Version 2.01 }

       This program prints the ROM data of all Buttons found on the parallel
    port, and reads the scratchpad of any DS1425 buttons found.

    Copyright (C) 1996 Dallas Semiconductor Corporation. 
    All rights Reserved. Printed in U.S.A.
    This software is protected by copyright laws of
    the United States and of foreign countries.
    This material may also be protected by patent laws of the United States 
    and of foreign countries.
    This software is furnished under a license agreement and/or a
    nondisclosure agreement and may only be used or copied in accordance
    with the terms of those agreements.
    The mere transfer of this software does not imply any licenses
    of trade secrets, proprietary technology, copyrights, patents,
    trademarks, maskwork rights, or any other form of intellectual
    property whatsoever. Dallas Semiconductor retains all ownership rights.
*/

#define READSCRATCH 0x69  /* Read scratchpad command byte */ 
#define SP_SA       0xC0  /* Field specifier / starting address */ 

typedef unsigned char uchar;

/*
   Access system functions     
*/
uchar dowcheck();             
uchar keyopen();
uchar keyclose();
uchar setup();
uchar next();
uchar first();
uchar access();
uchar gndtest();
uchar databyte();
uchar *romdata();

main(argc, argv)
     int  argc;
     char *argv[];
{
   uchar pn = 1;       /* Parallel port number */
   uchar *addr;        /* Holds ROM data pointer */
   int   i;
   int   loop_num = 0; 
   int   read_num;

   if (argc > 1)       /* Grab read_num parameter off command line */
      read_num = atoi(argv[1]);
   else
      read_num = 1;

   /* See if device driver is installed */
   if (dowcheck())                     
   {
      /* Gain control of driver */
      keyopen();   
   
      /* Search all ports */
      while (setup(pn) && (pn < 4))                     
      {
         /* Make sure we can talk to DS1410D */
         if (gndtest())                 
         {
            keyclose();
            
            while (loop_num++ < read_num)
            {
               keyopen();
               
               /* Look for first part on bus */
               if (first())                   
               {
                  do 
                  {
                     /* Release control of port between passes */
                     keyclose();  
                     keyopen();
      
                     printf("\nRom Data: ");         
                     /* Get pointer to ROM data */
                     addr = romdata();           
                     for (i = 0; i < 8; i++)    
                        printf("%2.2X ", *(addr + i));
      
                     /* Is button a DS1425 */
                     if ((*addr == 0x82) && access()) 
                     {
                        /* Send read scratch command */
                        databyte(READSCRATCH); 
                        /* Send field / starting address */
                        databyte(SP_SA);   
                        /* Send confirmation byte */
                        databyte(~SP_SA);         
      
                        printf("\nScratchpad data:\n");
      
                        /* Read scratchpad data */
                        for (i = 0; i < 64; i++) 
                           printf("%c", databyte(0xFF));
                     }
      
                     printf("\n");
                  }
                  while (next());  /* Look at all parts on port */
               }
               else 
               {
                  printf("No buttons found\n");
               }
               keyclose();
            }
         } 
         else 
         {
            printf("Printer not on line\n");
         }
       
         /* try next port */
         ++pn;                                             
      }

   }
   else
      printf("DOW device driver not installed.\n");
}


