/*
        scratch.c               

      This program prints the ROM data of all Buttons found on the parallel
   port, and reads the scratchpad of any DS1425 buttons found.
*/

#include <stdio.h>
#include <stdlib.h>

#define TRUE  1
#define FALSE 0

#define READSCRATCH 0x69     /* Read scratchpad command byte */ 
#define SP_SA       0xC0     /* Field specifier / starting address */ 

typedef unsigned char uchar;

/*
   Access system functions
*/
uchar dowcheck();                 
uchar keyopen();
uchar keyclose();
uchar setup();
uchar next();
uchar first();
uchar access();
uchar gndtest();
uchar databyte();
uchar *romdata();

void main(int argc, char *argv[])
{
   uchar pn = 0;  
   uchar *addr;  
   uchar NoButtons;
   int   i;
   int   loop_num; 
   int   read_num;

   /* Grab read_num parameter off command line */
   if (argc > 1)      
      read_num = atoi(argv[1]);
   else
      read_num = 1;

   /* See if device driver is installed */
   if (dowcheck())                     
   {
      /* Search all ports */
      while ((++pn < 4) && setup(pn))                   
      {
         keyopen();   

         /* Make sure we can talk to DS1410D */
         if (gndtest())                 
         {
            loop_num = 0; NoButtons = FALSE;     
            while ((loop_num++ < read_num) && !NoButtons)
            {
               /* Look for first part on bus */
               if (first())                   
               {
                  do 
                  {
                     /* Release control of port between passes */
                     keyclose();  
                     keyopen();
      
                     printf("\nRom Data: ");         
                     /* Get pointer to ROM data */
                     addr = romdata();           
                     for (i = 0; i < 8; i++)    
                        printf("%2.2X ", *(addr + i));
      
                     /* Is button a DS1425 */
                     if ((*addr == 0x82) && access()) 
                     {
                        /* Send read scratch command */
                        databyte(READSCRATCH); 
                        /* Send field / starting address */
                        databyte(SP_SA);   
                        /* Send confirmation byte */
                        databyte(~SP_SA);         
      
                        printf("\nScratchpad data:\n");
      
                        /* Read scratchpad data */
                        for (i = 0; i < 64; i++) 
                           printf("%c", databyte(0xFF));
                     }
      
                     printf("\n");
                  }
                  while (next());  /* Look at all parts on port */
               }
               else 
               {
                  NoButtons = TRUE;
                  printf("No buttons found on port #%d\n", pn);
               }
            }
         } 
         else 
         {
            printf("Printer not on line\n");
         }

         /* Release control of port */
         keyclose();                                
      }
   }
   else
      printf("DOW device driver not installed.\n");
}


