/* DS1413C Win32 Version                    
*
* Copyright (C) 1992,1993,1994,1995,1996 Dallas Semiconductor Corporation. 
* All rights Reserved. Printed in U.S.A.
* This software is protected by copyright laws of
* the United States and of foreign countries.
* This material may also be protected by patent laws of the United States 
* and of foreign countries.
* This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or copied in accordance
* with the terms of those agreements.
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form  of intellectual
* property whatsoever. Dallas Semiconductor retains all ownership rights.
*--------------------------------------------------------------------------
*
* File:      DS1413C.C
* Author:    DS
* Created:   3/3/98
* Compiler:  Microsoft Visual C++ 5.0
* Externals: 
* 0.0.0 -   Internal Release
* 
*/

#include <windows.h>

typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned long u_long;

typedef u_char uchar;
typedef u_short ushort;
typedef u_long ulong;

// external function prototypes
extern short SetupCOM(HANDLE, ulong);   
extern void  FlushCOM(HANDLE);   
extern short CloseCOM(HANDLE);  
extern short WriteCOM(HANDLE, short, short, uchar  *);
extern short ReadCOM(HANDLE, short, short, uchar  *, ulong  *);
extern short BreakCOM(HANDLE, short);
extern short PowerCOM(HANDLE, short);

extern u_char AuthFlag;
extern HANDLE FileDesc;

int DS1413Reset(int);
int DS1413Bit(int,u_char);
int DS1413Byte(int,u_char);

int DS1413Reset(int handle)
{
   ulong more,ts;
   uchar rdbuf[3];
   short cnt;

   // check for no handle to the com port
   if (!AuthFlag)
      return -1;

   // clear the buffers
   FlushCOM(FileDesc);

   // send a break to simulate a reset
   BreakCOM(FileDesc,1);

   // get a time stamp
   ts = GetTickCount() + 7;

   // get the first byte, always get 1 unless shorted
   cnt = ReadCOM(FileDesc,-1,1,rdbuf,&more);

   // read break character and others, timeout is 7 ms
   do
   {
      // check for more characters
      ReadCOM(FileDesc,1,0,rdbuf,&more);
      if (more > 0)
         cnt += ReadCOM(FileDesc,1,1,rdbuf,&more);
   }
   while (ts > GetTickCount());

   if (cnt > 1)
      return 1;
   else
      return 0;
}

int DS1413Bit(int handle, u_char onebit)
{
   ulong more;
   uchar rdbuf[3];
   int inbit;

   // check for no handle to the com port
   if (!AuthFlag)
      return -1;

   // empty the buffers
   FlushCOM(FileDesc);

   // create the string to send out
   rdbuf[0] = (onebit & 0x01) ? 0xFF : 0x00;

   // write the string to the COM port
   if (WriteCOM(FileDesc,-1,1,&rdbuf[0]))
   {
      // read back the echo
      if (ReadCOM(FileDesc,-1,1,&rdbuf[0],&more) == 1)
         // parse the string
         inbit = (rdbuf[0] & 0x02) >> 1;
      else
         inbit = -1;
   }
   else
      inbit = -1;

   return inbit;   
}

int DS1413Byte(int handle, u_char outch)
{
   ulong more;
   uchar rdbuf[9];
   int inch=0,i;

   // check for no handle to the com port
   if (!AuthFlag)
      return -1;

   // empty the buffers
   FlushCOM(FileDesc);

   // create the string to send out
   for (i = 0; i < 8; i++)
      rdbuf[i] = ((outch >> i) & 0x01) ? 0xFF : 0x00;

   // write the string to the COM port
   if (WriteCOM(FileDesc,-1,8,&rdbuf[0]))
   {
      // read back the echo
      if (ReadCOM(FileDesc,-1,8,&rdbuf[0],&more) == 8)
      {
         // parse the string
         for (i = 0; i < 8; i++)
         {
            inch >>= 1;
            inch |= (rdbuf[i] & 0x02) ? 0x80 : 0x00;
         }
      }
      else
         inch = -1;
   }
   else
      inch = -1;

   return inch;   // return the input char 
}