// WinDiagDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WinDiag.h"
#include "WinDiagDlg.h"
#include "Dow95.h"
#include "ds1996demo.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinDiagDlg dialog

CWinDiagDlg::CWinDiagDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWinDiagDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWinDiagDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWinDiagDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWinDiagDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWinDiagDlg, CDialog)
	//{{AFX_MSG_MAP(CWinDiagDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDSEARCH, OnSearch)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWinDiagDlg message handlers

BOOL CWinDiagDlg::OnInitDialog()
{
    unsigned long version;
    char temp[255];

	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
    com1Radio = (CButton *)GetDlgItem(IDC_COM1);
    com2Radio = (CButton *)GetDlgItem(IDC_COM2);
    com3Radio = (CButton *)GetDlgItem(IDC_COM3);
    com4Radio = (CButton *)GetDlgItem(IDC_COM4);
    lptRadio = (CButton *)GetDlgItem(IDC_LPT);
    com1Radio->SetCheck(1);
    listBox = (CListBox *)GetDlgItem(IDC_LIST1);
    versionText = (CEdit *)GetDlgItem(IDC_EDIT1);
	version = GetAccessAPIVersion();
    sprintf((char *)temp, "Access Layer API Version: %2.2X.%2.2X", (version & 0xFF), ((version >> 16) & 0xFF));
    CString tempStr(temp);
    versionText->SetWindowText(tempStr);
	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CWinDiagDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWinDiagDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWinDiagDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CWinDiagDlg::OnSearch() 
{
   byte portName[5];
   int portType = 0;
   if (com1Radio->GetCheck() == 1)
   {   
      portType = SERIAL_DS2480;
      strcpy((char *)portName, "COM1");
   }
   else if (com2Radio->GetCheck() == 1)
   {
      portType = SERIAL_DS2480;
      strcpy((char *)portName, "COM2");
   }
   else if (com3Radio->GetCheck() == 1)
   {
      portType = SERIAL_DS2480;
      strcpy((char *)portName, "COM3");
   }
   else if (com4Radio->GetCheck() == 1)
   {
      portType = SERIAL_DS2480;
      strcpy((char *)portName, "COM4");
   }
   else
   {
      portType = PARALLEL_DS1481;
      strcpy((char *)portName, "");
   }
   
   SetAdapterType(portType, (char *)portName);
   if (iBDOWCheck() == FALSE)
   {
       ::MessageBox(NULL, "Parallel Drivers Not Installed", "Error", NULL);
       return;
   }

   listBox->ResetContent();
   if (portType == PARALLEL_DS1481)
   {
       for (int i = 0; i < 3; i++)
           search(i+1);
   }
   else
   {
       char temp[5];
       CString tempStr("Searching ");
       sprintf((char *)temp, "%s", portName);
       tempStr = tempStr + temp;
       listBox->AddString(tempStr);
       search();
   }

}

void CWinDiagDlg::search() 
{
    int retVal, numButtons = 0;
    // Do setup with a valid parameter
    CString tempStr;
    byte temp[255];
    
    iBSetup(1);
    if (iBKeyOpen() == TRUE)
    {
        retVal =iBFirst();
        sprintf((char *)temp, "<First Returned %s>", ((retVal == 0) ? "false" : "true"));
        listBox->AddString(" ");
        listBox->AddString((const char *)temp);
        
        if (retVal == TRUE)
        {
            do
            {
                numButtons++;  // increment the number of iButtons found
                byte *romId;
                // read the ROM ID of the iButton found
                romId = (unsigned char *)iBROMData();
                tempStr = "RomData: ";
                for (int i = 0; i < 8; i++)
                {
                   byte tempRom[2];
                   sprintf((char *)tempRom, "%2.2X ", romId[i]);
                   tempStr = tempStr + tempRom;
                }
                listBox->AddString(tempStr);
                listBox->AddString(" ");
                readiButton(romId[0], (unsigned char)'X');
                // see if another part is on the bus
                retVal = iBNext();
                sprintf((char *)temp, "<Next Returned %s>",  ((retVal == 0) ? "false" : "true"));
                listBox->AddString((const char *) temp);
            }while (retVal == TRUE);
        }
        iBKeyClose();
    }
    sprintf((char *)temp, "Found %d iButton%s on port.", numButtons, ((numButtons != 1) ? "s" : ""));
    listBox->AddString((const char *)temp);
    listBox->AddString("----------------------------------------------");
    listBox->AddString(" ");
}

void CWinDiagDlg::search(int portNum)
{
    int retVal, numButtons = 0;
    // Do setup with a valid parameter
    CString tempStr("Searching LPT Port ");
    byte temp[255];
    sprintf((char *)temp, "%d", portNum);
    tempStr = tempStr + temp;
    listBox->AddString(tempStr);
    iBSetup(portNum);
    if (iBKeyOpen() == TRUE)
    {
        retVal =iBFirst();
        listBox->AddString(" ");
        sprintf((char *)temp, "<First Returned %s>", ((retVal == 0) ? "false" : "true"));
        listBox->AddString((const char *)temp);
        if (retVal == TRUE)
        {
            do
            {
                numButtons++;
                byte *romId;
                romId = (unsigned char *)iBROMData();
                tempStr = "RomData: ";
                for (int i = 0; i < 8; i++)
                {
                   byte tempRom[2];
                   sprintf((char *)tempRom, "%2.2X ", romId[i]);
                   tempStr = tempStr + tempRom;
                }
                listBox->AddString(tempStr);
                listBox->AddString(" ");
                readiButton(romId[0], (unsigned char)'U');
                retVal = iBNext();
                sprintf((char *)temp, "<Next Returned %s>",  ((retVal == 0) ? "false" : "true"));
                listBox->AddString((const char *) temp);
            }while (retVal == TRUE);
        }
       iBKeyClose();
    }
    sprintf((char *)temp, "Found %d iButton%s on port", numButtons, ((numButtons != 1) ? "s" : ""));
    listBox->AddString((const char *)temp);
    listBox->AddString("----------------------------------------------");
    listBox->AddString("  ");
}

void CWinDiagDlg::readiButton(int familyCode, unsigned char OutByte)
{
    char temp[255];
    int PageNum = 0;
    SMEMDATA iBMemRead;
    SPDATA   iBScratchWr;
    SPCOPY   iBScratchCopy;
    int i, j;
    unsigned char ch;

    switch ((familyCode & 0x7F))
    {
       case DS1992_FC:
          sprintf(temp,"Reading the memory of a DS1992");
          listBox->AddString((const char *) temp);
          PageNum = DS1992_PAGE_NUM;
       break;

       case DS1993_FC:
          sprintf(temp, "Reading the memory of a DS1993");
          listBox->AddString((const char *) temp);
          PageNum = DS1993_PAGE_NUM;
       break;

       case DS1994_FC:
          sprintf(temp, "Reading the memory of a DS1994");
          listBox->AddString((const char *) temp);
          PageNum = DS1994_PAGE_NUM;
       break;
 
       case DS1996_FC:
          sprintf(temp, "Reading the memory of a DS1996");
          listBox->AddString((const char *) temp);
          PageNum = DS1996_PAGE_NUM;

          /*
           * Since the DS1996s support overdrive put the
           * 1-wire bus in overdrive and increase the serial
           * port data rate (The actual DS2480 supports higher
           * data rates).
           */
          iBOverdriveOn();
          /* 
           * 57600 and 115200 would be better but these data rates 
           * are unsupported on some platforms. The DS2480 however 
           * should have no trouble with these higher data rates.
           */
          SetAdapterSpeed(115200);
          break;
       default:
          return;
    }
    if (PageNum)
    {
       time_t startTime, endTime;   
       double elapsed_time;
       time(&startTime);

       sprintf(temp, "PageNum");
       listBox->AddString((const char *) temp);
       /* Read all the secure memory pages 1st */
       if (iBFastAccess())
       {
          iBMemRead.CmdByte = READ_SECURE_MEMORY;
          /* Begin reading at memory address 0 */
          iBMemRead.TargetAddrLow = iBMemRead.TargetAddrHigh = 0;
          /* Send 0xFFs for each byte read */
          memset(iBMemRead.SMemBuffer, 0xFF, PageNum * PAGE_LEN);
       
          iBDataBlock(&iBMemRead.CmdByte, (int)(PageNum * PAGE_LEN + 3));
    
          /* Display received data on page boundaries */
          for (i = 0; i < PageNum; i++)
          {
             sprintf(temp, "Page #%d:", i);
             listBox->AddString((const char *) temp);
             char tempBuff[4];
             temp[0] = 0x00;
             for (j = 0; j < PAGE_LEN; j++)
             {
                ch = iBMemRead.SMemBuffer[i*PAGE_LEN + j]; 
                if (ch < 0x20)
                {
                   sprintf(tempBuff, ".");
                }
                else
                {
                   sprintf(tempBuff, "%c" ,ch);
                }
                strcat(temp, tempBuff);
             }
             if (temp[0] != 0x00)
                 listBox->AddString(temp);
          }
    
          
          /* Reprogram all memory pages */
          /*for (i = 0; i < PageNum; i++)
          {
             if (iBFastAccess())
             {
                //printf("Writing scratchpad\n");
    
                // Set write scratchpad command byte 
                iBScratchWr.CmdByte = WRITE_SCRATCHPAD;
                // Set the low byte of the target address 
                iBScratchWr.TargetAddrLow  = i << 5;
                // Set the high byte of the target address 
                iBScratchWr.TargetAddrHigh = i >> 3;
                // Initialize scratchpad buffer 
                memset(iBScratchWr.SPBuffer, OutByte, PAGE_LEN);
                
              //  iBDataByte(iBScratchWr.CmdByte);
              //  iBDataByte(iBScratchWr.TargetAddrLow);
              //  iBDataByte(iBScratchWr.TargetAddrHigh);
              //  for (kp = 0; kp < PAGE_LEN; kp++)
              //     iBDataByte(iBScratchWr.SPBuffer[i]);
              
                iBDataBlock(&iBScratchWr.CmdByte, PAGE_LEN+3);
    
                if (iBFastAccess())
                {
                   //
                    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                    //    This code is assuming that the iButton(s) 
                    // are dwelled. In a touch environment the 
                    // scratchpad should be read back and confirmed 
                    // before proceeding with the copy scratchpad 
                    // command.
                    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                    //
                  // printf("Copying scratchpad to page #%d\n", i);
    
                   // Set copy scratchpad command byte 
                   iBScratchCopy.CmdByte = COPY_SCRATCHPAD;
                   // Set the low byte of the target address 
                   iBScratchCopy.TargetAddrLow  = i << 5;
                   // Set the high byte of the target address 
                   iBScratchCopy.TargetAddrHigh = i >> 3;
                   // Copy entire scratchpad to specified page 
                   iBScratchCopy.Offset = 0x1F; 
    
                   iBDataBlock(&iBScratchCopy.CmdByte, 
                               sizeof(SPCOPY));
                }
                else
                {
                   sprintf(temp, "!!!Unable to access iButton");
                   listBox->AddString((const char *) temp);
                }
             }
             else
             {
                sprintf(temp, "!!!Unable to access iButton");
                listBox->AddString((const char *) temp);
             }
             
          }
          */
       }
       time(&endTime);
       elapsed_time=difftime(endTime, startTime);
       sprintf(temp, "Elapsed time %12.5f seconds.", elapsed_time);
       listBox->AddString((const char *) temp);
    }
    
    /* If we put the bus in overdrive restore regular speed */
    if (familyCode == DS1996_FC)
    {
       iBOverdriveOff();
       SetAdapterSpeed(9600);
    }
    return;
}
