/****************************************************************************
 *
 *  ds1996demo.h               
 *
 * DS1992,3,4,6 iButton defines and memory structures.
 *
 *****************************************************************************/

/*
 * Page length in bytes
 */
#define PAGE_LEN 32

/*
 * Device family codes
 */
#define DS1992_FC 0x08  
#define DS1993_FC 0x06  
#define DS1994_FC 0x04  
#define DS1996_FC 0x0C  

#define MAX_PAGE_NUM DS1996_PAGE_NUM

/*
 * Number of 32 byte pages per iButton 
 */
#define DS1992_PAGE_NUM 4
#define DS1993_PAGE_NUM 16
#define DS1994_PAGE_NUM 16
#define DS1996_PAGE_NUM 256

/*
 * Memory related command bytes 
 */
#define READ_SECURE_MEMORY 0xF0  
#define READ_SCRATCHPAD    0xAA  
#define WRITE_SCRATCHPAD   0x0F 
#define COPY_SCRATCHPAD    0x55  

/*
 * Structure packing assumed to be 1 !!!
 */
typedef struct _SMEMDATA
{
   uchar CmdByte;
   uchar TargetAddrLow;
   uchar TargetAddrHigh;
   uchar SMemBuffer[MAX_PAGE_NUM * PAGE_LEN]; 
}
SMEMDATA;

/*
 * Structure used for writing scratchpad
 */
typedef struct _SPDATA
{
   uchar CmdByte;
   uchar TargetAddrLow;
   uchar TargetAddrHigh;
   uchar SPBuffer[PAGE_LEN]; 
}
SPDATA;

/*
 * Structure used for copying scratchpad
 */
typedef struct _SPCOPY
{
   uchar CmdByte;
   uchar TargetAddrLow;
   uchar TargetAddrHigh;
   uchar Offset;
}
SPCOPY;
