/* DS2480Comm Win32 Version                    
*
*
* 
* Author:   Clayton Ware
* Created:  8/7/97
* Compiler: Microsoft Visual C++ 5.0
* Externals: serial.h, ds2480.h, ds2480com.h, ds2480sa.h
* NOTE: (serial.h) defines ser_dtron incorrectly -- TA
* 0.99.0 - Initial Release
* 
*/
typedef unsigned char  u_char;
typedef unsigned short u_short;
typedef unsigned long  u_long;
typedef u_char   uchar;
typedef u_short  ushort;
typedef u_long   ulong;
#include "ds2480sa.h"
#include "ds2480.h" 
#include "ds2480com.h"
#include <windows.h>
#include <largeint.h>
#include <stdio.h>

extern void FastSleep(DWORD Delay); // DS1413


// local functions
HANDLE OpenCOM(HANDLE FileDesc, int, ulong);   
short SetupCOM(HANDLE, ulong);   
void  FlushCOM(HANDLE);   
short CloseCOM(HANDLE);  
short WriteCOM(HANDLE, short, short, uchar FAR *);
short ReadCOM(HANDLE, short, short, uchar FAR *, ulong FAR *);
short BreakCOM(HANDLE, short);
short PowerCOM(HANDLE, short);

// globals for this module
static OVERLAPPED osRead,osWrite;   
char szPort[30]; // global device string
//---------------------------------------------------------------------------
//  Description:
//     Attept to open a com port.  Keep the handle in ComID.
//
HANDLE OpenCOM(HANDLE FileDesc, int Prt, ulong baudrate)
{
   short fRetVal;
   COMMTIMEOUTS CommTimeOuts;
   
   // check if need to open a new port
   if (FileDesc != 0)
      /* return TRUE; -------------------------------------------------------- */
      /* Seems like this is what is needed -- just guessing. TA */
      return(FileDesc);
   
   // load the COM prefix string and append port number
   if (!strcmp(szPort, ""))
      wsprintf( szPort, "COM%d", Prt) ;
   
   // open COMM device
   
   if ((FileDesc =
      CreateFile( szPort, GENERIC_READ | GENERIC_WRITE,
      0, //??????FILE_SHARE_READ | FILE_SHARE_WRITE, // non-exclusive access
      NULL,                 // no security attrs
      OPEN_EXISTING,
      FILE_FLAG_OVERLAPPED, // overlapped I/O
      NULL )) == (HANDLE) -1 )
   {
      FileDesc = NULL;
      return (NULL) ;
   }
   else
   {
      // create events for detection of reading and write to com port (3.00Beta4)
      osRead.hEvent = CreateEvent(NULL,TRUE,FALSE,"TMEX_COMM_READ_OVERLAPPED_EVENT");
      osWrite.hEvent = CreateEvent(NULL,TRUE,FALSE,"TMEX_COMM_WRITE_OVERLAPPED_EVENT");
      
      // get any early notifications
      SetCommMask(FileDesc, EV_RXCHAR | EV_TXEMPTY | EV_ERR | EV_BREAK);
      
      // setup device buffers
      SetupComm(FileDesc, 2048, 2048);
      
      // purge any information in the buffer
      PurgeComm(FileDesc, PURGE_TXABORT | PURGE_RXABORT |
         PURGE_TXCLEAR | PURGE_RXCLEAR );
      
      // set up for overlapped non-blocking I/O (3.00Beta4)
      CommTimeOuts.ReadIntervalTimeout = DEF_READ_INT; 
      CommTimeOuts.ReadTotalTimeoutMultiplier = DEF_READ_MULT; 
      CommTimeOuts.ReadTotalTimeoutConstant = DEF_READ_CONST; 
      CommTimeOuts.WriteTotalTimeoutMultiplier = DEF_WRITE_MULT; 
      CommTimeOuts.WriteTotalTimeoutConstant = DEF_WRITE_CONST; 
      SetCommTimeouts(FileDesc, &CommTimeOuts);
   }
   
   // get the connection
   fRetVal = SetupCOM(FileDesc,baudrate);
   
   if (!fRetVal)
   {
      CloseHandle(FileDesc);
      FileDesc = NULL;
   }
   
   return (FileDesc);
} 


//---------------------------------------------------------------------------
//  Description:
//     This routines sets up the DCB and performs a SetCommState().
//
short SetupCOM(HANDLE FileDesc, ulong baudrate)
{
   short fRetVal;
   DCB dcb;
   
   dcb.DCBlength = sizeof(DCB);
   
   GetCommState(FileDesc, &dcb);
   
   dcb.BaudRate = baudrate;               // current baud rate 
   dcb.fBinary = TRUE;                    // binary mode, no EOF check 
   dcb.fParity = FALSE;                   // enable parity checking 
   dcb.fOutxCtsFlow = FALSE;              // CTS output flow control 
   dcb.fOutxDsrFlow = FALSE;              // DSR output flow control 
   dcb.fDtrControl = DTR_CONTROL_ENABLE;  // DTR flow control type 
   dcb.fDsrSensitivity = FALSE;           // DSR sensitivity 
   dcb.fTXContinueOnXoff = TRUE;          // XOFF continues Tx 
   dcb.fOutX = FALSE;                     // XON/XOFF out flow control 
   dcb.fInX = FALSE;                      // XON/XOFF in flow control 
   dcb.fErrorChar = FALSE;                // enable error replacement 
   dcb.fNull = FALSE;                     // enable null stripping 
   dcb.fRtsControl = RTS_CONTROL_ENABLE;  // RTS flow control 
   dcb.fAbortOnError = FALSE;             // abort reads/writes on error 
   dcb.XonLim = 0;                        // transmit XON threshold 
   dcb.XoffLim = 0;                       // transmit XOFF threshold 
   dcb.ByteSize = 8;                      // number of bits/byte, 4-8 
   dcb.Parity = NOPARITY;                 // 0-4=no,odd,even,mark,space 
   dcb.StopBits = ONESTOPBIT;             // 0,1,2 = 1, 1.5, 2 
   dcb.XonChar = 0;                       // Tx and Rx XON character 
   dcb.XoffChar = 1;                      // Tx and Rx XOFF character 
   dcb.ErrorChar = 0;                     // error replacement character 
   dcb.EofChar = 0;                       // end of input character 
   dcb.EvtChar = 0;                       // received event character 
   
   fRetVal = SetCommState(FileDesc, &dcb);
   
   return (fRetVal);
} 


//---------------------------------------------------------------------------
//  Description:
//     Closes the connection to the port.
//     - Use new PurgeComm() API to clear communications driver before
//       closing device.
//
short CloseCOM(HANDLE FileDesc)
{
   // disable event notification and wait for thread
   // to halt
   SetCommMask(FileDesc, 0);
   
   // drop DTR
   //????EscapeCommFunction(FileDesc, CLRDTR);
   
   // purge any outstanding reads/writes and close device handle
   PurgeComm(FileDesc, PURGE_TXABORT | PURGE_RXABORT |
      PURGE_TXCLEAR | PURGE_RXCLEAR );
   CloseHandle(FileDesc);
   
   FileDesc = 0;
   
   return (TRUE);
   
} 

//---------------------------------------------------------------------------
//  Description:
//     flush the rx and tx buffers
//
void FlushCOM(HANDLE FileDesc)
{
   // purge any information in the buffer
   PurgeComm(FileDesc, PURGE_TXABORT | PURGE_RXABORT |
      PURGE_TXCLEAR | PURGE_RXCLEAR ) ;
}


//--------------------------------------------------------------------------
// Write an array of bytes to the COM port, verify that it was
// sent out.  Assume that baud rate has been set and the buffers have
// been flushed.
//
// Returns 1 for success and 0 for failure
//
short WriteCOM(HANDLE FileDesc, short timeout, short outlen, uchar FAR *outbuf)
{
   BOOL fWriteStat;
   DWORD dwBytesWritten=0;
   DWORD ler=0,to;
   COMMTIMEOUTS CommTimeOuts;
   // check if not using default timeout
   if (timeout > 0)
   {
      CommTimeOuts.ReadIntervalTimeout = DEF_READ_INT; 
      CommTimeOuts.ReadTotalTimeoutMultiplier = DEF_READ_MULT; 
      CommTimeOuts.ReadTotalTimeoutConstant = DEF_READ_CONST; 
      CommTimeOuts.WriteTotalTimeoutMultiplier = DEF_WRITE_MULT; 
      CommTimeOuts.WriteTotalTimeoutConstant = timeout; 
      SetCommTimeouts(FileDesc, &CommTimeOuts);
      to = timeout + outlen + 5;
   }
   // calculate a timeout
   else
      to = DEF_WRITE_MULT * outlen + DEF_WRITE_CONST + 5;
   
   // reset the write event 
   ResetEvent(osWrite.hEvent);
   
   // write the byte
   fWriteStat = WriteFile(FileDesc, (LPSTR) &outbuf[0], 
      outlen, &dwBytesWritten, &osWrite );
   
   // check for an error
   if (!fWriteStat)
      ler = GetLastError();
   
   // if not done writting then wait 
   if (!fWriteStat && ler == ERROR_IO_PENDING)
   {     
      
      if (WaitForSingleObject(osWrite.hEvent,to) != WAIT_OBJECT_0)
         return 0;  // shorted
      
      // verify all is written correctly
      fWriteStat = GetOverlappedResult(FileDesc, &osWrite, 
         &dwBytesWritten, FALSE); 
      
   } 
   
   // check if need to restore timeouts
   if (timeout > 0)
   {
      CommTimeOuts.ReadIntervalTimeout = DEF_READ_INT; 
      CommTimeOuts.ReadTotalTimeoutMultiplier = DEF_READ_MULT; 
      CommTimeOuts.ReadTotalTimeoutConstant = DEF_READ_CONST; 
      CommTimeOuts.WriteTotalTimeoutMultiplier = DEF_WRITE_MULT; 
      CommTimeOuts.WriteTotalTimeoutConstant = DEF_WRITE_CONST; 
      SetCommTimeouts(FileDesc, &CommTimeOuts);
   }
   
   // check results of write
   if (!fWriteStat || (dwBytesWritten != (unsigned short)outlen))
      return (short) 0;
   else
      return (short) 1;
}


//--------------------------------------------------------------------------
// Read an array of bytes to the COM port, verify that it was
// sent out.  Assume that baud rate has been set and the buffers have
// been flushed.
//
// Returns number of characters read
//
short ReadCOM(HANDLE FileDesc, short timeout, short inlen, uchar FAR *inbuf, 
              ulong FAR *more)
{
   DWORD dwLength=0; 
   BOOL fReadStat;
   DWORD ler=0,to;
   COMMTIMEOUTS CommTimeOuts;
   COMSTAT ComStat;
   DWORD dwErrorFlags;
   // check if not using default timeout
   if (timeout > 0)
   {
      CommTimeOuts.ReadIntervalTimeout = DEF_READ_INT; 
      CommTimeOuts.ReadTotalTimeoutMultiplier = DEF_READ_MULT; 
      CommTimeOuts.ReadTotalTimeoutConstant = timeout; 
      CommTimeOuts.WriteTotalTimeoutMultiplier = DEF_WRITE_MULT; 
      CommTimeOuts.WriteTotalTimeoutConstant = DEF_WRITE_CONST; 
      SetCommTimeouts(FileDesc, &CommTimeOuts);
      to = timeout + inlen + 5;
   }
   // calculate a timeout
   else
      to = DEF_READ_MULT * inlen + DEF_READ_CONST + 5;
   
   // reset the read event 
   ResetEvent(osRead.hEvent);
   
   // read
   fReadStat = ReadFile(FileDesc, (LPSTR) &inbuf[0],
      inlen, &dwLength, &osRead) ;
   
   // check for an error
   if (!fReadStat)
      ler = GetLastError();
   
   // if not done writing then wait 
   if (!fReadStat && ler == ERROR_IO_PENDING)
   {
      
      // wait until everything is read
      if (WaitForSingleObject(osRead.hEvent,to) != WAIT_OBJECT_0)
         return 0;  // shorted
      
      // verify all is read correctly
      fReadStat = GetOverlappedResult(FileDesc, &osRead, 
         &dwLength, FALSE); 
   }
   
   // check if need to restore timeouts
   if (timeout > 0)
   {
      CommTimeOuts.ReadIntervalTimeout = DEF_READ_INT; 
      CommTimeOuts.ReadTotalTimeoutMultiplier = DEF_READ_MULT; 
      CommTimeOuts.ReadTotalTimeoutConstant = DEF_READ_CONST; 
      CommTimeOuts.WriteTotalTimeoutMultiplier = DEF_WRITE_MULT; 
      CommTimeOuts.WriteTotalTimeoutConstant = DEF_WRITE_CONST; 
      SetCommTimeouts(FileDesc, &CommTimeOuts);
   }
   
   // check results
   if (fReadStat)
   {
      
      // check if any more bytes in buffer 
      ClearCommError(FileDesc, &dwErrorFlags, &ComStat);
      *more = ComStat.cbInQue;
      
      return (short) dwLength;
   }   
   else
      return (short) 0;
}


//--------------------------------------------------------------------------
//  Description:
//     Send a break on the com port for len ms
//
short BreakCOM(HANDLE FileDesc, short len)
{
   /* debug code 10/08/97 -- TA */
   int d_iRV1 = -99;
   int d_iRV2 = -99;
   // start the reset pulse
   d_iRV1 = SetCommBreak(FileDesc);
   
   // sleep 
   if (len < 5)   // DS1413
      FastSleep(len);
   else
      Sleep(len); 
   
   // clear the reset pulse
   d_iRV2 = ClearCommBreak(FileDesc);
   
   return 1;   
}


//--------------------------------------------------------------------------
//  Description:
//     Drop and then raise power (DTR,RTS) on the com port
//
short PowerCOM(HANDLE FileDesc, short len)
{
   DCB dcb;
   int d_RV1 = -99;
   int d_RV2 = -99;
   
   // DTR/RTS off (inverse loader mode for the 5000)
   dcb.DCBlength = sizeof(DCB);
   GetCommState(FileDesc, &dcb);
   dcb.fDtrControl = DTR_CONTROL_DISABLE;  // disable DTR
   dcb.fRtsControl = RTS_CONTROL_DISABLE;  
   d_RV1 = SetCommState(FileDesc, &dcb);
   
   // sleep 
   Sleep(len); 
   
   // DTR/RTS on 
   dcb.DCBlength = sizeof(DCB);
   GetCommState(FileDesc, &dcb);
   dcb.fDtrControl = DTR_CONTROL_ENABLE;
   dcb.fRtsControl = RTS_CONTROL_ENABLE;  
   d_RV2 = SetCommState(FileDesc, &dcb);
   
   return TRUE;   
}

DWORD GetBaudRate(HANDLE FileDesc)
{
   DCB dcb;
   // DTR/RTS off (inverse loader mode for the 5000)
   dcb.DCBlength = sizeof(DCB);
   GetCommState(FileDesc, &dcb);
   return dcb.BaudRate;
}

