//  (CCW)
//  Sam32Multi.c
//
//  Windows 95/NT Access System (10-16-97 Beta .01)
//
//  Copyright (C) 1996, 1997 Dallas Semiconductor Corporation.
//  All rights Reserved. Printed in U.S.A.
//  This software is protected by copyright laws of
//  the United States and of foreign countries.
//  This material may also be protected by patent laws of the United States
//  and of foreign countries.
//  This software is furnished under a license agreement and/or a
//  nondisclosure agreement and may only be used or copied in accordance
//  with the terms of those agreements.
//  The mere transfer of this software does not imply any licenses
//  of trade secrets, proprietary technology, copyrights, patents,
//  trademarks, maskwork rights, or any other form of intellectual
//  property whatsoever. Dallas Semiconductor retains all ownership rights.
//
//  10-16-97 Converted Sam32.c to support DS9097U on the serial port.
//  03-03-98 Added DS1413 (DS9097) support on the serial port.
//  04-21-98 Fixed the need to be administrator inorder to use this file.
//           Changed CheckDriver function.
//
// NOTE: This file will not compile and link as a cpp file.  The file must be linked as a 
//       standard c file. (CW)  My dynamic linking functions for Win32s cause errors with
//       a cpp compile.
// ALSO: Inorder to have a program run on Win32s, it must be compiled with Microsoft C++ V2.0

#include <dos.h>
#include <signal.h>
#include <stdlib.h>
#include <windows.h>
#include <stdio.h>
#include <windef.h>
#include <winbase.h>
#include <winnt.h>

typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned long u_long;

typedef u_char uchar;
typedef u_short ushort;
typedef u_long ulong;

#include "ds2480.h"
#include "sauth95.h"
#include "ds2480com.h"


/*
 * Version Info
 */
#define VERSION_MAJOR          0
#define VERSION_MINOR          9

extern   int DS1413Reset(int);
extern int DS1413Bit(int,u_char);
extern int DS1413Byte(int,u_char);

HANDLE FileDesc = NULL;


#define DS2480 0
#define DS1410 1
#define DS1413 2

#ifdef __BORLANDC__
#define PLRG_INTEGER PMYLARGE_INTEGER
#define LRG_INTEGER MYLARGE_INTEGER
#else
#define PLRG_INTEGER PLARGE_INTEGER
#define LRG_INTEGER LARGE_INTEGER
#endif

#define DO_RESET         0
#define DO_BIT           1 
#define DO_BYTE          2 
#define TOGGLE_OVERDRIVE 3 
#define TOGGLE_PASSTHRU  4 
#define CHECK_BRICK      5 
#define SET_PORT         6

#define MAX_PAR_BLOCK   16
#define DATA_BLOCK    0x20

#define SAUTH95_SEM          "SAuth95AccessSem"
#define SA16COMPAT_SEM       "SAuth95Win16BitCompatSem"
#define SAUTH95_PASSTHRU_SEM "SAuth95PassThruSem"
#define SEM_TIMEOUT          10000 //milliseconds
#define PASSTRHU_TIMEOUT     10    //milliseconds
#define ROMSEARCH            0xF0

const char version[] = "DS1411K for Windows Version 0.9 Beta";

HINSTANCE hInst;

//95 variables
HANDLE sam_hSemaphore= NULL,              // Handle of Semaphore
hSA16CompatSem= NULL;              // Semaphore for Win16 compatibility
HANDLE sam_hDriver   = NULL;              // Handle of Driver
HANDLE hThread       = NULL;              // Handle of Thread
HANDLE hPassThruSem  = NULL;              // Handle of PassThru Semaphore
uchar  RomDta[8]     = {0,0,0,0,0,0,0,0}; // Current ROM Id
uchar  DriverBuff[4];                     // Buffer for exchanging data with driver
void   *lpDriverBuff = DriverBuff;        // Pointer to data buffer
BOOL   AuthFlag      = FALSE;             // Thread has driver control?
BOOL   sam_SemCreated    = FALSE;             // Semaphore created yet?

//nt variables
HANDLE  DOWHandle;          // Handle to file representing our driver 
HANDLE  sHandle = NULL;     // Handle to our semaphore 
DWORD   NumTrans;    
UCHAR   gpn = 1;
UCHAR   Passthru = TRUE;
UCHAR   TimeOut;
UCHAR   mch[1024]; 

int gType = PARALLEL_DS1481;  // default to the parallel port
HANDLE PortHandle = NULL;
uchar SearchBuf[20];








//////////////////////////////////////////////////////////

extern uchar szPort[30];

extern HANDLE OpenCOM(HANDLE, int, ulong);
extern void CloseCOM(HANDLE);
extern int DS2480Block(int,uchar *,int);

/////////////// software auth vars ///////////////////////

static uchar  SetupOk    = FALSE;
static uchar  FailNext;
static uchar  AccessGood;
static uchar  l0         = 0;
static uchar  Compatl0   = 0;  // for SACWD300.dll compatability
static ushort pa_vals[3] = { 0x378, 0x278, 0x3BC };
static ushort bpa = 0x378;

void atexit_function(void);

typedef unsigned char uchar;
BOOL WinNT  = FALSE;
BOOL Win95  = FALSE;
BOOL Win32s = FALSE;
BOOL loaded = FALSE;

// structure for Win32s.  
typedef struct
{
   uchar   ld;            /* last discrepancy */
   uchar   lastone;       /* true when last part is seen */
   uchar   unit;          /* parallel port unit, 1, 2, or 3 */
   uchar   accflg;        /* true when access has be executed */
   ushort  count;         /* timing for probes of parallel port */
   ushort  port;          /* parallel port base address */
   ushort  setup_ok;      /* has to be equal to MAGIC */
   uchar   romdta[8];
} 
sa_struct;

sa_struct gb;

// Win32s dynamically loaded function prototypes
uchar (pascal *keyopen32)(void);
void  (pascal *keyclose32)(void);
uchar *(pascal *romdata32)(sa_struct *);
uchar (pascal *setup32)(uchar, sa_struct *);
uchar (pascal *first32)(sa_struct *);
uchar (pascal *next32)(sa_struct *);
uchar (pascal *access32)(sa_struct *);
uchar (pascal *databyte32)(uchar, sa_struct *);
uchar (pascal *gndtest32)(sa_struct *);
uchar (pascal *dowcheck32)(void);
uchar (pascal *OverdriveOn32)(void);
void  (pascal *OverdriveOff32)(void);

static void  TogglePassthru(void);
static uchar  EnterPassthru (void);
static uchar  ExitPassthru  (void);
static uchar CheckBusy     (void);
static uchar DOWBit        (uchar);
static uchar DOWByte       (uchar);
static uchar DOWReset      (void);
static uchar RomSearch     (void);
/*static*/ uchar CheckOverdrive(void);
static void   SetPortNumber();
static void MyInt64Add(PLRG_INTEGER pA, PLRG_INTEGER pB);
static BOOL MyInt64LessThanOrEqualTo(PLRG_INTEGER pA, PLRG_INTEGER pB);
static uchar CheckDriver(void);
void SetPortType(int Type, char *type );


////////////////////////////////////////////////////////////////////////////////
uchar *romid;

////////////////////////////////////////////////////////////////////////////////
static uchar CallDriver(DWORD FuncNum, uchar Param)
{
   uchar  *pByte = DriverBuff;   // first byte is data
   ushort *pBPA;                 // next two are the port address
   DWORD BuffSize = 0;           // driver returns number of data bytes to us
   
   (uchar *)pBPA = &DriverBuff[1];           
   memset(DriverBuff,0,sizeof(DriverBuff));  // clear buffer,
   *pByte = Param;                           // set parameter value
   *pBPA  = bpa;                             // and port address
   
   DeviceIoControl(sam_hDriver, // communicate with driver
      FuncNum,
      lpDriverBuff,sizeof(DriverBuff),
      lpDriverBuff,sizeof(DriverBuff),(LPDWORD)(&BuffSize),
      NULL);
   
   return (*pByte);
}
////////////////////////////////////////////////////////////////////////////////
//
//    Call 95 driver's extended functions (i.e. Block I/O, FastAccess).
//
static void CallDriverExtended(DWORD FuncNum, LPBYTE ParamBuf, BYTE BufLen)
{
   uchar  *pByte = DriverBuff;   // first byte is data
   ushort *pBPA;                 // next two are the port address
   DWORD  BuffSize = 0;          // driver returns number of data bytes to us
   
   (uchar *)pBPA = &DriverBuff[1];           
   memset(DriverBuff,0,sizeof(DriverBuff)); 
   *pByte = 0;                             
   *pBPA  = bpa;                           
   
   DriverBuff[3] = BufLen;
   memcpy(&DriverBuff[4], ParamBuf, BufLen);
   
   DeviceIoControl(sam_hDriver, 
      FuncNum,
      lpDriverBuff,BufLen + 4,
      lpDriverBuff,BufLen + 4,(LPDWORD)(&BuffSize),
      NULL);
   
   if (FuncNum == DATA_BLOCK)
      memcpy(ParamBuf, &DriverBuff[4], BufLen);
   else
      ParamBuf[0] = DriverBuff[0];
}

//////////////////////////////////////////////////////////////////////////////
void CleanUp(void)
{
   if(sam_hSemaphore)
      CloseHandle(sam_hSemaphore);// release semaphore handle to system
   return;
}
////////////////////////////////////////////////////////////////////////////////
uchar garbagebag(uchar *ld)// Added for Win16 compatibility 
{                          // returns lastone for SACWD300.dll
   *ld = Compatl0;
   return FailNext;
}
////////////////////////////////////////////////////////////////////////////////
uchar iBOverdriveOn(void)
{
   // DS1413
   if (gType == SERIAL_DS1413)
      return FALSE;

   if(!Win32s)
   {
      if (!DOWReset())
         return FALSE;
      
      // Put all overdrive parts into overdrive mode.
      DOWByte(0x3C);
      
      return ToggleOverdrive() ? TRUE : ToggleOverdrive();
   }
   else if(Win32s)
   {
      if(OverdriveOn32 != NULL)
         return (*OverdriveOn32)();   
   }
   return FALSE;
}

////////////////////////////////////////////////////////////////////////////////
void iBOverdriveOff(void)
{
   // DS1413
   if (gType == SERIAL_DS1413)
      return;

   if(!Win32s)
   {
      // Turn overdrive off
      if(ToggleOverdrive())
         ToggleOverdrive();
   }
   else if(Win32s)
   {
      if(OverdriveOff32 != NULL)
         (*OverdriveOff32)();
   }
   return;
}
////////////////////////////////////////////////////////////////////////////////
static uchar EnterPassthru(void)
{
   if(Win95 || WinNT)
   {
      TogglePassthru();
      Passthru = TRUE;
      return TRUE; 
   }
   return FALSE;
}
////////////////////////////////////////////////////////////////////////////////
static uchar ExitPassthru(void)
{
   uchar i = 0;
   
   if(Win95 || WinNT)
   {
      Passthru = TRUE;
      
      while(Passthru && (i++ < 3))
      {
         TogglePassthru();
         Passthru = !CheckBusy();// if busy lines don't drop we're in passthru mode
      }
      
      return !Passthru;
   }
   return FALSE;
}

////////////////////////////////////////////////////////////////////////////////
BOOL LoadDriver(void)
{
   SC_HANDLE hSCManager, hDS1410D;
   char Service[] = "DS1410D";
   DWORD LastError;
   
   /* Get a handle to the Service control manager database */
   hSCManager = OpenSCManager(
      NULL,
      NULL,
      SC_MANAGER_ALL_ACCESS);
   if(hSCManager)
   {
      /* get a handle to our driver */
      hDS1410D = OpenService(hSCManager,
         Service,
         SERVICE_ALL_ACCESS);
      if(hDS1410D)
      {
         /* attempt to start DS1410D.SYS */
         if(StartService(hDS1410D, 0, NULL))
            return TRUE;
         else
         {
            LastError = GetLastError();
            
            return FALSE;
         }
      }
      else
      {
         hDS1410D= CreateService(
            hSCManager, // handle to service control manager database  
            Service,    // pointer to name of service to start 
            Service,    // pointer to display name 
            SERVICE_ALL_ACCESS, // type of access to service 
            SERVICE_KERNEL_DRIVER,  // type of service 
            SERVICE_AUTO_START, // when to start service 
            SERVICE_ERROR_NORMAL,   // severity if service fails to start 
            "SYSTEM32\\drivers\\DS1410D.SYS",   // pointer to name of binary file 
            "Extended Base",    // pointer to name of load ordering group 
            NULL,   // pointer to variable to get tag identifier 
            NULL,   // pointer to array of dependency names 
            NULL,   // pointer to account name of service 
            NULL    // pointer to password for service account 
            );
         if(hDS1410D)
         {
            /* attempt to start DS1410D.SYS */
            if(StartService(hDS1410D, 0, NULL))
               return TRUE;
            else
               return FALSE;
         }
      }
   }
   return FALSE;
}

// This function is called on NT to determine if the driver is loaded on the System
// CheckDriver should only be called by dowcheck()
static uchar CheckDriver(void)
{
   
   SC_HANDLE hSCManager, hDS1410D;
   char Service[] = "DS1410D";
   /* Get a handle to the Service control manager database */
   hSCManager = OpenSCManager(
      NULL,
      NULL,
      SC_MANAGER_CONNECT);
   if(hSCManager)
   {
      /* get a handle to our driver */
      hDS1410D = OpenService(hSCManager,
         Service,
         SERVICE_QUERY_STATUS);
      if(hDS1410D)
      {
         CloseServiceHandle(hDS1410D);
         CloseServiceHandle(hSCManager);
         return TRUE;
      }
      else
      {
         CloseServiceHandle(hSCManager);
         return FALSE;
      }
   }
   return FALSE;
}
////////////////////////////////////////////////////////////////////////////////
uchar iBDOWCheck(void) // Must be used in All Apps!!!!!
{
   // Determine what version of Windows we are running under.
   // Do the approiate thing under each version.
   
   DWORD dwVersion;
   uchar i;
   dwVersion = GetVersion();

   if (dwVersion < 0x80000000)
   { // Windows NT
      Win95  = FALSE;
      Win32s = FALSE;
      WinNT  = TRUE;
   }
   else if (LOBYTE(LOWORD(dwVersion)) < 4)
   {
      // Win32s or Windows 3.1x
      if ((LOBYTE(LOWORD(dwVersion)) == 3) && (HIBYTE(LOWORD(dwVersion)) <= 0x5E))
      {
         Win95  = FALSE;
         WinNT  = FALSE;
         Win32s = TRUE;
      }
      else
      {  // Early Windows 95 Builds
         Win95  = TRUE;
         WinNT  = FALSE;
         Win32s = FALSE;
      }
   }
   else
   {
      Win95  = TRUE;
      WinNT  = FALSE;
      Win32s = FALSE;
   }
   switch(gType)
   {
      case PARALLEL_DS1481:
         if(Win95)
         {
            if((!sam_hDriver) || (sam_hDriver == INVALID_HANDLE_VALUE))
               sam_hDriver=CreateFile("\\\\.\\VSAUTHD.VXD",0,0,NULL,
               OPEN_ALWAYS,FILE_FLAG_DELETE_ON_CLOSE,NULL);
      
            if(sam_hDriver==INVALID_HANDLE_VALUE)
               return FALSE;         // could not get handle to our driver
      
            hThread=GetCurrentThread();
            if(!hPassThruSem)
            {
               if(!(hPassThruSem = OpenSemaphore(SYNCHRONIZE|SEMAPHORE_MODIFY_STATE,
                  FALSE,
                  SAUTH95_PASSTHRU_SEM)))
               {
                  hPassThruSem = CreateSemaphore(NULL,1,1,SAUTH95_PASSTHRU_SEM);
               }
            }
            return TRUE;
         }
         else if(Win32s)
         {
            if(!loaded)
            {
               hInst = LoadLibrary("swa32ut.dll");
               if(hInst != NULL)
               {
                  (FARPROC)setup32 = GetProcAddress(hInst, "setup");   
                  (FARPROC)first32 = GetProcAddress(hInst,"first");
                  (FARPROC)next32 =  GetProcAddress(hInst,"next");
                  (FARPROC)access32 = GetProcAddress(hInst,"access");
                  (FARPROC)databyte32 = GetProcAddress(hInst,"databyte");
                  (FARPROC)gndtest32 = GetProcAddress(hInst,"gndtest");
                  (FARPROC)romdata32 = GetProcAddress(hInst,"romdata");
                  (FARPROC)dowcheck32 = GetProcAddress(hInst,"dowcheck");
                  (FARPROC)keyopen32 = GetProcAddress(hInst, "keyopen");
                  (FARPROC)keyclose32 = GetProcAddress(hInst, "keyclose");
                  (FARPROC)OverdriveOn32 = GetProcAddress(hInst, "OverdriveOn");
                  (FARPROC)OverdriveOff32 = GetProcAddress(hInst, "OverdriveOff");
                  if(setup32 && first32 && next32 && access32 && databyte32 && 
                     gndtest32 && romdata32 && dowcheck32 && keyclose32 && keyopen32)
                  {
                     loaded = TRUE;
                     atexit( atexit_function );
                  }
                  else
                  {
                     FreeLibrary(hInst);
                     loaded = FALSE;
                     return FALSE;
                  }
            
               }
               else
               {
                  return FALSE;
               }
            }
            if(dowcheck32 != NULL)
               i = (*dowcheck32)();
            else
               i = 0;
            return i;
      
         }
         else if (WinNT)
         {
            if(!CheckDriver()) // driver isn't loaded try and load it
               return ((uchar)LoadDriver());
            else
               return TRUE;
         }
         return FALSE;   
         break;
      case SERIAL_DS2480:
         return TRUE;
      case SERIAL_DS1413:
         return TRUE;
   }

}
////////////////////////////////////////////////////////////////////////////////
// Do not use for win16 only.
uchar nowaitkeyopen(void)// Added for Win16 compatibility.
{                        // Must be used in Win16 Apps!!!!!
   DWORD WaitResult=0;
   if(Win95)
   {   
      
      if(!AuthFlag)
      {  
         AuthFlag = ((sam_hDriver==INVALID_HANDLE_VALUE)?FALSE:TRUE);
         
         if(AuthFlag) // have valid driver handle
         {  
            if(!sam_SemCreated)
            {
               sam_hSemaphore = CreateSemaphore(NULL,1,1,SAUTH95_SEM);
               sam_SemCreated = TRUE;
            }
            
            if(!sam_hSemaphore) // no semaphore handle yet
            {
               sam_hSemaphore = OpenSemaphore(SYNCHRONIZE|SEMAPHORE_MODIFY_STATE,
                  FALSE,
                  SAUTH95_SEM);
            }
            
            if(sam_hSemaphore)
            {
               // try to spread access to all applications evenly
               SetThreadPriority(hThread,THREAD_PRIORITY_ABOVE_NORMAL);// 1 point higher
               
               // Added for Win16 compatibility
               if(OpenSemaphore(SYNCHRONIZE|SEMAPHORE_MODIFY_STATE,FALSE,SA16COMPAT_SEM))
                  return FALSE;
               
               
               // Added for Win16 compatibility
               hSA16CompatSem=CreateSemaphore(NULL,1,1,SA16COMPAT_SEM);
               
               WaitResult=WaitForSingleObject(sam_hSemaphore,SEM_TIMEOUT);
               
               if(WaitResult==WAIT_FAILED)
               {
                  SetThreadPriority(hThread,THREAD_PRIORITY_NORMAL);
                  ReleaseSemaphore(sam_hSemaphore,1,NULL);
                  
                  // Added for Win16 compatibility
                  if(hSA16CompatSem)
                     CloseHandle(hSA16CompatSem);// release semaphore handle to system
                  
                  AuthFlag = FALSE;
                  Sleep(0);
                  return FALSE;
               }
               
            }
            else
               return FALSE;
            
         }// if(AuthFlag)
         
      }// if(!AuthFlag)
      
      if(AuthFlag)
         ExitPassthru();
      
      return AuthFlag;
   }  
   else if(WinNT)
   {
      return FALSE;
   }
   return FALSE;
}

////////////////////////////////////////////////////////////////////////////////
uchar iBKeyOpen(void) // Must be used in Win32 Apps!!!!!
{
   
   DWORD WaitResult=0;
   uchar RetVal;
   if(Win95)
   {
      switch(gType)
      {
      case PARALLEL_DS1481:
         if(!AuthFlag)
         {
            AuthFlag = ((sam_hDriver==INVALID_HANDLE_VALUE)?FALSE:TRUE);
            
            if(AuthFlag) // have valid driver handle
            {
               if(!sam_SemCreated)
               {
                  sam_hSemaphore = CreateSemaphore(NULL,1,1,SAUTH95_SEM);
                  sam_SemCreated = TRUE;
               }
               
               if(!sam_hSemaphore) // no semaphore handle yet
               {
                  sam_hSemaphore = OpenSemaphore(SYNCHRONIZE|SEMAPHORE_MODIFY_STATE,
                     FALSE,
                     SAUTH95_SEM);
               }
               
               if(sam_hSemaphore)
               {
                  // try to spread access to all applications evenly
                  SetThreadPriority(hThread,THREAD_PRIORITY_ABOVE_NORMAL);// 1 point higher
                  WaitResult=WaitForSingleObject(sam_hSemaphore,SEM_TIMEOUT);
                  
                  if(WaitResult==WAIT_FAILED)
                  {
                     SetThreadPriority(hThread,THREAD_PRIORITY_NORMAL);
                     ReleaseSemaphore(sam_hSemaphore,1,NULL);
                     AuthFlag = FALSE;
                     Sleep(0);
                     return FALSE;
                  }
                  
                  // Added for Win16 compatibility
                  hSA16CompatSem=CreateSemaphore(NULL,1,1,SA16COMPAT_SEM);
               }
               else
                  return FALSE;
            }// if(AuthFlag)
            
         }// if(!AuthFlag)
         
         if(AuthFlag)
         {
            ExitPassthru();
            if(CheckOverdrive())
               iBOverdriveOff();       // call overdrive off if mixed stacking is not enabled
         }
         return AuthFlag;
         break;
      case SERIAL_DS2480:
         AuthFlag = TRUE;
         if (!FileDesc)
            FileDesc = OpenCOM(FileDesc, gpn, 9600);
         if(FileDesc)
         {
            //ser_dtroff((int)FileDesc);
            //ser_dtron((int)FileDesc);
            DOWReset();
            SetAdapterSpeed(9600);
            RetVal = DOWReset();
            if (!RetVal)
            {
               ser_dtroff((int)FileDesc);
               ser_dtron((int)FileDesc);
               Sleep(300);
               DOWReset();
               SetAdapterSpeed(9600);
               RetVal = DOWReset();
               if (!RetVal)
                  AuthFlag = FALSE;
            }  
            return RetVal;
         }

         AuthFlag = FALSE;
         return FALSE;
         break;
      case SERIAL_DS1413:  // DS1413
         if (!FileDesc)
            FileDesc = OpenCOM(FileDesc, gpn, 115200);
         if(FileDesc)
            AuthFlag = TRUE;
         else
            AuthFlag = FALSE;
         return AuthFlag;
         break;
      }
   }
   else if(WinNT)
   {
      switch(gType)
      {
      case PARALLEL_DS1481:
         if (!AuthFlag)                
         {
            // If it existed we still don't have a handle 
            if (sHandle == NULL || !sam_SemCreated) 
            {
               sHandle = OpenSemaphore(SYNCHRONIZE | SEMAPHORE_MODIFY_STATE, 
                  FALSE, 
                  "DS1410XAccessSem");
               // Make sure we got a handle.
               if (sHandle != NULL)
                  sam_SemCreated = TRUE;
            }
            // Create semaphore if it doesn't exist 
            if (!sam_SemCreated)           
            {
               sHandle = CreateSemaphore(NULL, 1, 1, "DS1410XAccessSem");
               if (sHandle != NULL)
                  sam_SemCreated = TRUE;
            }
            
            if (sam_SemCreated == TRUE)
            {
               // Wait until semaphore value = 0, or 5 second timeout 
               WaitForSingleObject(sHandle, 5000); 
               
               // Once we've got the semaphore we should be able to get the handle
               // (unless semaphore wait timed out, then we fail CreateFile)
               // Try to get handle to our driver
               AuthFlag = !((DOWHandle = CreateFile("LPT9",     
                  GENERIC_READ | GENERIC_WRITE,
                  0,       
                  NULL,   
                  OPEN_EXISTING,
                  FILE_ATTRIBUTE_NORMAL,
                  NULL)) == INVALID_HANDLE_VALUE);
               if(AuthFlag)
               {
                  // Set port number in the driver
                  SetPortNumber();
                  
                  // Enter EPP passthru mode
                  ExitPassthru();
                  if (CheckOverdrive())
                     iBOverdriveOff();
               }
               else
               {
                  ReleaseSemaphore(sHandle, 1, NULL);      
                  return FALSE;
               }
            }
            else
               return AuthFlag;
         }
         return AuthFlag;
         break;
      case SERIAL_DS2480:
         /*AuthFlag = TRUE;
         FileDesc = OpenCOM(FileDesc, gpn, 9600);
         if(FileDesc)
         {
            ser_dtroff((int)FileDesc);
            ser_dtron((int)FileDesc);
            DOWReset();
            SetAdapterSpeed(9600);
            return DOWReset();
         }
         */
         AuthFlag = TRUE;
         if (!FileDesc)
            FileDesc = OpenCOM(FileDesc, gpn, 9600);
         if(FileDesc)
         {
            //ser_dtroff((int)FileDesc);
            //ser_dtron((int)FileDesc);
            DOWReset();
            SetAdapterSpeed(9600);
            RetVal = DOWReset();
            if (!RetVal)
            {
               ser_dtroff((int)FileDesc);
               ser_dtron((int)FileDesc);
               Sleep(300);
               DOWReset();
               SetAdapterSpeed(9600);
               RetVal = DOWReset();
               if (!RetVal)
                  AuthFlag = FALSE;
            }  
            return RetVal;
         }

         AuthFlag = FALSE;
         return FALSE;

         break;
      case SERIAL_DS1413:  // DS1413
         if (!FileDesc)
            FileDesc = OpenCOM(FileDesc, gpn, 115200);
         if(FileDesc)
            AuthFlag = TRUE;
         else
            AuthFlag = FALSE;
         return AuthFlag;
         break;
      }
   }
   else if(Win32s)
   {
      return (*keyopen32)();
   }
   return FALSE;
}
////////////////////////////////////////////////////////////////////////////////
uchar iBKeyClose(void) // Must be Used in All Apps!!!!!
{
   if(Win95)
   {
      switch(gType)
      {
      case PARALLEL_DS1481:
         if(AuthFlag)
         {
            EnterPassthru();
            // Added for Win16 compatibility
            if(hSA16CompatSem)
               CloseHandle(hSA16CompatSem);// release semaphore handle to system
            
            
            ReleaseSemaphore(sam_hSemaphore,1,NULL);
            AuthFlag = FALSE;
            // allow fair access to other applications
            SetThreadPriority(hThread,THREAD_PRIORITY_BELOW_NORMAL);// 1 point lower
            Sleep(0); //release time slice
            SetThreadPriority(hThread,THREAD_PRIORITY_NORMAL);
         }  
         break;
      case SERIAL_DS2480: case SERIAL_DS1413: // DS1413
         AuthFlag = FALSE;
         if (FileDesc)
            CloseCOM(FileDesc);
         FileDesc = NULL;
         break;
      }
      
   }
   else if(WinNT)
   {
      switch(gType)
      {
      case PARALLEL_DS1481:
         // If we had control, release control 
         if (AuthFlag)                    
         {
            // Enter EPP passthru mode
            EnterPassthru();
            // Close handle to DS1410E.SYS 
            CloseHandle(DOWHandle);               
            // Set semaphore value back to 0 
            ReleaseSemaphore(sHandle, 1, NULL);  
            AuthFlag = FALSE;      
         }
         break;
      case SERIAL_DS2480: case SERIAL_DS1413: // DS1413
         AuthFlag = FALSE;
         /*PurgeComm(FileDesc, PURGE_TXABORT | PURGE_RXABORT |
            PURGE_TXCLEAR | PURGE_RXCLEAR ) ;*/

         
         if(FileDesc)
            CloseCOM(FileDesc);
         FileDesc = NULL;
         
         break;
      }
      
   }
   else if(Win32s)
      (*keyclose32)();
   szPort[0] = 0;
   return TRUE;
}

void ClosePort()
{
   AuthFlag = FALSE;
   if (FileDesc)
      CloseCOM(FileDesc);
    FileDesc = NULL;
   return;
}

////////////////////////////////////////////////////////////////////////////////
uchar iBFirst(void)
{
   if(!Win32s)
   {
      // Don't force a failure here
      FailNext = FALSE;
      // Point Rom Search algorithm to the top
      l0 = 0;
      
      // Go look for the first DOW part on the bus
      return iBNext();
   }
   else if(Win32s)
      return (*first32)(&gb);
   return FALSE;
}
////////////////////////////////////////////////////////////////////////////////
uchar iBNext(void)
{
   uchar tr;
   if(Win95)
   {
      if (SetupOk)
      {
         // See if last search found last button
         if (FailNext)
         {
            FailNext = FALSE;
            
            // Reset next function
            l0 = 0;
         }
         else
            while ((tr = RomSearch()) != 0) // Do that ROM search thang
            {
               // See if we should force failure
               if (tr == 2)
                  FailNext = 1;
               
               // Detect short circuit
               
               if (!RomDta[0])
                  return FALSE;
               
               return TRUE;         
            }//else
            
      }//if (SetupOk)
      return FALSE;
   }
   else if(WinNT)
   {
      if (SetupOk)
      {
         // See if last search found last button
         if (FailNext)                    
         {
            FailNext = FALSE; 
            
            // Reset next function 
            l0 = 0;                                        
         } 
         else while ((tr = RomSearch()) != 0) 
         {
            // See if we should force failure
            if (tr == 2) 
               FailNext = 1;                
            
            // Detect short circuit
            if (!RomDta[0])       
               return FALSE;
            
            AccessGood = TRUE;
            
            return TRUE;
         }
      }
      return FALSE;
   }
   else if(Win32s)
      return (*next32)(&gb);
   return FALSE;
}
uchar iBFastAccess(void)
{
   return iBAccess();
}

uchar iBStrongAccess(void)
{
   uchar i, j;             
   uchar mask = 0x80;
   uchar byte;
   uchar bit;
   uchar bytesend[24]; 

   /* Assume failure  */
   AccessGood = FALSE;                                   

   /* Send reset pulse */
   if (DOWReset())                                      
   {
	   
      /* ROM search command byte */
      DOWByte(0xF0);                             

      switch (gType)
      {
        case SERIAL_DS2480:
			
          /* Setup the 24 byte search block */
          for (i = 0;i < 24;i++)
            bytesend[i] = 0xFF;
          byte = 0;
          bit = 2;
          for (i = 0;i < 8;i++)
          {
            for (j = 0;j < 8;j++)
            {
              if (((RomDta[i] >> j) & 1) != 1)
                bytesend[byte] &= ~(mask >> (7 - bit));
              bit += 3;
              if (bit >= 8)
                byte++;
              bit = (bit) % 8;
            }
          }
          /* Send the block. */
          DS2480Block((int)FileDesc,bytesend,24);
		  
          if((bytesend[15] & 0xC0) == 0xC0)
		  {
			  
			  return FALSE;
		  }
		  
          break;
        case PARALLEL_DS1481: case SERIAL_DS1413: // DS1413
			
          /* Byte loop */
          for (i = 0; i < 8; i++)          
          {
            /* Bit loop */
            for (j = 0; j < 8; j++)      
            {
              /* Send two read time slots */
              if (((DOWBit(TRUE) << 1) | DOWBit(TRUE)) == 3)                
                return FALSE;         

              /* Send write time slot */
              DOWBit((uchar) ((RomDta[i] >> j) & 1));
            }      
          }
          break;
        default:
          break;
      }
      
      /* Success if we made it through all bits */
      AccessGood = TRUE;      
   }

   return AccessGood;
}
////////////////////////////////////////////////////////////////////////////////
uchar iBAccess(void)
{
   uchar i, j;
   uchar accessarray[9];
   switch(gType)
   {
   case SERIAL_DS2480:
      AccessGood = FALSE;
      
      if (DOWReset())
      {
         AccessGood = TRUE;
         
         /* Set up block for transmit */
         accessarray[0] = 0x55;
         for (i = 1;i < 9;i++)
            accessarray[i] = RomDta[i-1];
         /* Transmit block. */    
         iBDataBlock(accessarray,9);
      }
      
      return AccessGood;
      break;
   case PARALLEL_DS1481: case SERIAL_DS1413: // DS1413
      if(Win95)
      {
         // Assume failure
         AccessGood = FALSE;
         
         // Send reset pulse
         if (DOWReset())
         {
            // ROM search command byte
            DOWByte(ROMSEARCH);
            
            // Byte loop
            for (i = 0; i < 8; i++)
            {
               // Bit loop
               for (j = 0; j < 8; j++)
               {
                  if (((DOWBit(TRUE) << 1) | DOWBit(TRUE)) == 3)
                     return FALSE;     // Part not there
                  
                  // Send write time slot
                  DOWBit((uchar) ((RomDta[i] >> j) & 1));
               }
            }
            
            // Success if we made it through all the bits
            AccessGood = TRUE;
         }
         
         return AccessGood;
      }
      else if(WinNT)
      {
         // Assume failure 
         AccessGood = FALSE;                                       
         
         // Send reset pulse
         if (DOWReset())                                         
         {
            // ROM search command byte
            DOWByte(0xF0);                                
            
            // Byte loop
            for (i = 0; i < 8; i++)                                     
            {
               // Bit loop
               for (j = 0; j < 8; j++)                                   
               {
                  if (((DOWBit(TRUE) << 1) | DOWBit(TRUE)) == 3)                
                     return FALSE;     
                  
                  // Send write time slot
                  DOWBit((UCHAR) ((RomDta[i] >> j) & 1));    
               }      
            }
            
            // Success if we made it through all the bits
            AccessGood = TRUE;         
         }
         
         return AccessGood;
      }
      else if(Win32s)
         return (*access32)(&gb);
      return FALSE;
      break;
   }
}
////////////////////////////////////////////////////////////////////////////////
uchar gndtest(void)
{
   if(Win95)
   {
      if (SetupOk)
      {
         DOWReset();
         return DOWBit(TRUE);
      }
      
      return FALSE;
   }
   else if(WinNT)
      return SetupOk;
   else if(Win32s)
      return (*gndtest32)(&gb);
   return FALSE;
}
////////////////////////////////////////////////////////////////////////////////
uchar *iBROMData(void)
{
   ushort i;
   if(!Win32s)
      return (uchar *)RomDta;
   else if(Win32s)
   {
      if(romdata32 != NULL)
      {
         romid = (*romdata32)(&gb);
         for (i = 0; i < 8; i++)
            gb.romdta[i] = romid[i];
         return gb.romdta;
      }
   }
   return FALSE;
}
////////////////////////////////////////////////////////////////////////////////
uchar iBDataByte(uchar data)
{
   if(!Win32s)
      return (SetupOk && AccessGood) ? DOWByte(data) : data;
   else if(Win32s)
   {
      if(databyte32 != NULL)
         return (*databyte32)(data, &gb);
   }
   return FALSE;
}
/* Send a stream of bytes to the port. */
static int DOWBlock(uchar *barr, int length)
{
   int i;
   
   if (AuthFlag)
   {
      switch(gType)
      {
      case SERIAL_DS2480:
         for (i = 0;i < length;i += SERIAL_DS2480_BLKSIZE)
         {
            if ((length - i) < SERIAL_DS2480_BLKSIZE && (length - i) > 0)
               DS2480Block((int)FileDesc,(barr + i),(int)length - i);
            else
               DS2480Block((int)FileDesc,(barr + i),(int)SERIAL_DS2480_BLKSIZE);
         }
         return TRUE;
         break;
         
      case PARALLEL_DS1481:
         return FALSE;
         break;
         
      default:
         return FALSE;
         break;
      }
   }  
}
///////////////////////////////////////////////////////////////////////////////
//
//    Block I/O command. Transmit data in blocks of size PAR_BLOCK_SIZE. 
// Return received bytes in the same buffer.
//
uchar iBDataBlock(uchar *data, int count)
{
   int BlockLen, BlockCnt = 0;
   int i;
   
   if (!Win32s && (gType != SERIAL_DS1413))  // DS1413
   {
      switch(gType)
      {
      case SERIAL_DS2480: 
         DOWBlock(data,count);
         break;
      case PARALLEL_DS1481:
         
         while (count)
         {
            BlockLen = (count >= MAX_PAR_BLOCK) ? MAX_PAR_BLOCK : count;
            
            mch[0] = DATA_BLOCK;
            mch[1] = BlockLen;
            
            for (i = 0; i < BlockLen; i++)
               mch[i+2] = data[BlockCnt*MAX_PAR_BLOCK + i];
            
            if (WinNT)
            {
               WriteFile(DOWHandle, (LPSTR) mch, BlockLen+2, &NumTrans, NULL);
               ReadFile(DOWHandle, (LPSTR) mch, BlockLen, &NumTrans, NULL);
            }
            else
            {
               // Call 95 driver
               //static void CallDriverExtended(DWORD FuncNum, LPBYTE ParamBuf, BYTE BufLen)
               CallDriverExtended((DWORD)DATA_BLOCK, &mch[2], (BYTE)BlockLen);
            }
            
            if (WinNT)
            {
               for (i = 0; i < BlockLen; i++)
                  data[BlockCnt*MAX_PAR_BLOCK + i] = mch[i];
            }
            else
            {
               for (i = 0; i < BlockLen; i++)
                  data[BlockCnt*MAX_PAR_BLOCK + i] = mch[i+2];
            }
            
            count -= BlockLen;
            ++BlockCnt;
         }
         break;
      }
   }
   else
   {
      /* Byte-bang the thing */
      for (i = 0; i < count; i++)
         data[i] = iBDataByte(data[i]);
   }
   return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
uchar iBSetup(uchar pn)
{
   if(Win95)
   {
      SetupOk = FailNext = AccessGood = FALSE;         // Initialize global flags
      
      // Reset RomSearch (first, next) algorithm
      FailNext = FALSE;
      l0 = 0;
      
      //????????????????????
      if (pn > 0 && pn < 4 || gType == DS2480)                     // Make sure port number is valid
      {
         // This allows all other functions to execute
         SetupOk = TRUE;
         // Set base port address
         bpa = pa_vals[pn - 1];
      }
      else
      {
         bpa = pa_vals[0];  // Set to default in case caller ignores FALSE return
         pn = 1;
      }
      
      gpn = pn;
      return SetupOk;                          // Return result of setup function
   }
   else if(WinNT)
   {
      // Initialize global flags
      SetupOk = FailNext = AccessGood = FALSE;         
      
      // Reset RomSearch (first, next) algorithm 
      l0 = 0;                            
      
      // Make sure port number is valid
      if (pn > 0 && pn < 4 || gType == DS2480)           
      {
         // This allows all other functions to execute
         SetupOk = TRUE;            
         // Assign port number
         gpn = pn;
      }
      else
         gpn = 1; 
      
      // Return result of setup function
      return SetupOk;
   }
   else if(Win32s)
   {
      if(setup32 != NULL)
         return (*setup32)(pn, &gb);
      else
         return FALSE;
   }
   return FALSE;
}
//////////////////////////////////////////////////////////////////////////////
//
//    Added for CiB comm layer.
//
uchar iBDataBit(uchar bit)
{
   return DOWBit(bit);
}
////////////////////////////////////////////////////////////////////////////////
static 
uchar DOWBit(uchar bit_val)
{
   BOOLEAN BitResult = TRUE;
   switch(gType)
   {
   case SERIAL_DS2480:
      if(DS2480Bit((int)FileDesc, bit_val) == 1)
         return (1);
      else 
         return (0);
      break;
   case PARALLEL_DS1481:
      
      if(Win95)
         return CallDriver(DOWBIT,bit_val);
      else if(WinNT)
      {
         if (AuthFlag)
         {
            mch[0] = DO_BIT;  // Tell driver to do a bit 
            mch[1] = bit_val; // Specify bit value 
            
            if (WriteFile(DOWHandle, (LPSTR) mch, 2, &NumTrans, NULL) &&
               ReadFile(DOWHandle, (LPSTR) mch, 1, &NumTrans, NULL))
            {
               BitResult = (BOOLEAN) *mch; 
            }
         } 
         
         return BitResult;
      }
      return FALSE;
      break;
   case SERIAL_DS1413:  // DS1413
      if(DS1413Bit((int)FileDesc, bit_val) == 1)
         return (1);
      else 
         return (0);
      break;
   }
}
////////////////////////////////////////////////////////////////////////////////
static 
uchar DOWByte(uchar byte_val)
{
   UCHAR ByteResult = byte_val;
   switch(gType)
   {
   case SERIAL_DS2480:
      return (DS2480Byte((int)FileDesc, byte_val));
      break;
   case PARALLEL_DS1481:
      if(Win95)
         return CallDriver(DOWBYTE,byte_val);
      else if(WinNT)
      {
         if (AuthFlag)
         {
            mch[0] = DO_BYTE;  // Tell driver to do a bit 
            mch[1] = byte_val; // Specify bit value 
            
            if (WriteFile(DOWHandle, (LPSTR) mch, 2, &NumTrans, NULL) &&
               ReadFile(DOWHandle, (LPSTR) mch, 1, &NumTrans, NULL))
            {
               ByteResult = *mch;                  
            }
         } 
         
         return ByteResult;
      }
      return FALSE;
      break;
   case SERIAL_DS1413:  // DS1413
      return (DS1413Byte((int)FileDesc, byte_val));
      break;
   }
}
////////////////////////////////////////////////////////////////////////////////
uchar iBDOWReset() /* Wrapped this to complete native calls. -- TA */
{
   return(DOWReset());
}
////////////////////////////////////////////////////////////////////////////////
static  
uchar DOWReset()
{
   BOOLEAN ResetResult = FALSE;
   switch(gType)
   {
   case SERIAL_DS2480:
      if (DS2480Reset((int)FileDesc) == 1)
         return(1);
      else
         return(0);
      break;
   case PARALLEL_DS1481:
      if(Win95)
         return CallDriver(DOWRESET,0);
      else if (WinNT)
      {
         if (AuthFlag)
         {
            mch[0] = DO_RESET; // Tell driver to do a reset 
            mch[1] = gpn;      // Specify a port 
            
            if (WriteFile(DOWHandle, (LPSTR) mch, 2, &NumTrans, NULL) && 
               ReadFile(DOWHandle, (LPSTR) mch, 1, &NumTrans, NULL))
            {
               // Assign result 
               ResetResult = (BOOLEAN) *mch;                     
            }
            Sleep(1);
         } 
         
         return ResetResult;
      }
      return FALSE;
   case SERIAL_DS1413:  // DS1413
      if (DS1413Reset((int)FileDesc) == 1)
         return(1);
      else
         return(0);
      break;
   }
   
}
////////////////////////////////////////////////////////////////////////////////
static 
uchar ToggleOverdrive()
{
   UCHAR ByteResult = 0;
   switch(gType)
   {
   case SERIAL_DS2480:
      return (DS2480ToggleOverdrive((int)FileDesc));
      break;
   case PARALLEL_DS1481:
      
      if(Win95)
         return CallDriver(DOWTOGGLEOD,0);
      else if(WinNT)
      {
         if (AuthFlag)
         {
            mch[0] = TOGGLE_OVERDRIVE; 
            
            if (WriteFile(DOWHandle, (LPSTR) mch, 2, &NumTrans, NULL) &&
               ReadFile(DOWHandle, (LPSTR) mch, 1, &NumTrans, NULL))
            {
               ByteResult = *mch;                  
            }
         } 
         return ByteResult;
      }
      return FALSE;
      break;
   }
}
////////////////////////////////////////////////////////////////////////////////
static uchar CheckOverdrive()
{
   uchar ByteResult = 0;
   
   if(Win95)
   {
      return CallDriver(CHECK_OVERDRIVE,0);//Busy Lines Dropped
   }
   else if(WinNT)
   {
      if (AuthFlag)
      {
         mch[0] = CHECK_OVERDRIVE; 
         
         if (WriteFile(DOWHandle, (LPSTR) mch, 2, &NumTrans, NULL) &&
            ReadFile(DOWHandle, (LPSTR) mch, 1, &NumTrans, NULL))
         {
            ByteResult = mch[0];                  
         }
      } 
      
      return ByteResult;
   }
   return FALSE;
}
////////////////////////////////////////////////////////////////////////////////
static 
uchar CheckBusy()
{
   UCHAR ByteResult = 0;
   if(Win95)
      return CallDriver(DOWCHECKBSY,0);//Busy Lines Dropped
   else if(WinNT)
   {
      if (AuthFlag)
      {
         mch[0] = CHECK_BRICK; 
         
         if (WriteFile(DOWHandle, (LPSTR) mch, 2, &NumTrans, NULL) &&
            ReadFile(DOWHandle, (LPSTR) mch, 1, &NumTrans, NULL))
         {
            ByteResult = *mch;                  
         }
      } 
      
      return ByteResult;
   }
   return FALSE;
}
////////////////////////////////////////////////////////////////////////////////
static
void TogglePassthru(void)
{
   UCHAR i;
   if(Win95)
      CallDriver(DOWTOGGLEPASS,0);
   else if(WinNT)
   {
      for (i = 0; i < 4; i++)
         ToggleOverdrive();
   }
   FastSleep(10);
   return;
}
////////////////////////////////////////////////////////////////////////////////
static 
uchar RomSearch(void)
{
   uchar
      i = 0,
      x = 0,
      ld = l0;
   uchar RomBit,
      Mask;
   
   switch(gType)
   {
   case PARALLEL_DS1481: case SERIAL_DS1413: // DS1413
      if(!Win32s)
      {
         // Reset DOW bus
         if (DOWReset())
            DOWByte(ROMSEARCH);  // Send search command
         else
         {
            return FALSE;   // No DOW parts were found on bus
         }
         // While not done and not bus error
         while ((i++ < 64) && (x < 3))
         {
            Mask = 1 << ((i - 1) % 8);
            
            // Get last pass bit
            RomBit = RomDta[(i - 1) >> 3] & Mask ? TRUE : FALSE;
            
            // Send read time slots
            x = DOWBit(TRUE) << 1;
            x |= DOWBit(TRUE);
            
            // Is there a disagreement in this bit position
            if (!x)
            {
               // Stay on old path or pick a new one ?
               if (i >= ld)
                  RomBit = (i == ld);         // Send write 1 if at position of ld 
               
               // Save this value as temp last disagreement
               if (!RomBit)
                  l0 = i;
            }
            else
               RomBit = (x & 1) ^ 1;          // Get lsb of x and flip it
            
            if (RomBit)
               RomDta[(i - 1) >> 3] |= Mask;          // Set bit in Rom Data byte
            else
               RomDta[(i - 1) >> 3] &= (Mask ^ 0xFF); // Clear bit in Rom Data byte
            
            // Send write time slot
            DOWBit(RomBit);
         }
         
         Compatl0=l0;
         break;
         
      }
      return FALSE;
      break;
   case SERIAL_DS2480:
      
      /* Set up 16 bytes of ROMID data */
      for (i = 0;i < 16;i++) SearchBuf[i] = 0x00;
      /* If we're not doing a first. */
      if (l0 != 0)
      {
         i = 0;
         while (i++ < 64)
         {
            if (i >= ld)
            {
               if (i == ld)
                  RomBit = 1;
               else
                  RomBit = 0;
            }
            else
               RomBit = (RomDta[(i - 1) / 8] >> ((i - 1) % 8)) & 0x01;
            SearchBuf[(i - 1) / 4] |= RomBit << (((i-1)%4)*2+1);
         }
      }
      
      /* Returns false if Presence Pulse not detected. */
      if (DS2480Search((int)FileDesc,SearchBuf) < 0)
         return(FALSE);
      
      /* Check for invalid search */
      if ((SearchBuf[15] & 0xC0) == 0xC0)
         x = 3;
      
      /* Copy into the RomDta buffer */
      for (i = 0;i < 8;i++) RomDta[i] = 0x00;
      i = 0;
      while (i++ < 64)
      {
         RomBit = (SearchBuf[(i - 1) / 4] >> (((i - 1) % 4) * 2 + 1)) & 0x01;
         RomDta[(i - 1) / 8] |= (RomBit << (i - 1)%8);
      }
      /* Find the last discrepancy */
      i = 64;
      while (i > 0)
      {
         if ( SearchBuf[(i - 1) / 4] & (0x01 << (((i-1)%4) * 2)) &&
            !(SearchBuf[(i - 1) / 4] & (0x01 << (((i-1)%4) * 2 + 1))) )
         {
            l0 = i;
            i = 1;
         }
         i--;
      }
      break;
   }
   return (x == 3) ? 0 : 1 + (ld == l0);    
}
////////////////////////////////////////////////////////////////////////////////
void atexit_function(void)
{
   if (hInst != NULL)
      FreeLibrary(hInst);
}

////////////////////////////////////////////////////////////////////////////////
static void SetPortNumber()
{
   UCHAR ByteResult = 0;
   
   if (AuthFlag)
   {
      mch[0] = SET_PORT; 
      mch[1] = gpn; 
      
      WriteFile(DOWHandle, (LPSTR) mch, 2, &NumTrans, NULL);
      ReadFile(DOWHandle, (LPSTR) mch, 1, &NumTrans, NULL);
   } 
   return;
}

static void MyInt64Add(PLRG_INTEGER pA, PLRG_INTEGER pB)
{
   BYTE c = 0;
   
   if ((pA->LowPart != 0L) && (pB->LowPart != 0L))
      c = ((pA->LowPart + pB->LowPart) < pA->LowPart) ? 1 : 0;
   
   pA->LowPart  += pB->LowPart;
   pA->HighPart += pB->HighPart + c;
   return;
}

//////////////////////////////////////////////////////////////////////////////
//
//   Returns TRUE is A <= B.
//
static BOOL MyInt64LessThanOrEqualTo(PLRG_INTEGER pA, PLRG_INTEGER pB)
{
   BOOL CompRes = FALSE;
   
   if (pA->HighPart < pB->HighPart)
      CompRes = TRUE;
   else if ((pA->HighPart == pB->HighPart) && (pA->LowPart <= pB->LowPart))
      CompRes = TRUE;
   
   return CompRes;
}
void FastSleep(DWORD Delay)
{
   LRG_INTEGER CountsPerSec, CurrentCount, FinalCount, DelayCounts;
   BOOL          UseOldSleep = TRUE;
   
   if (QueryPerformanceFrequency(&CountsPerSec))
   {
      if (CountsPerSec.HighPart == 0L)
      {
         DelayCounts.HighPart = 0;
         DelayCounts.LowPart  = (CountsPerSec.LowPart / 1000L) * Delay;
         
         if (DelayCounts.LowPart)
         {
            // Get current count value
            QueryPerformanceCounter(&FinalCount);
            // FinalCount += DelayCounts
            MyInt64Add(&FinalCount, &DelayCounts);
            
            do
            {
               SleepEx(1, FALSE);
               QueryPerformanceCounter(&CurrentCount);   
            }
            while (MyInt64LessThanOrEqualTo(&CurrentCount, &FinalCount));
            
            UseOldSleep = FALSE;
         }
      }
   }
   
   if (UseOldSleep)
   {
      // Use regular sleep if hardware doesn't support a performance counter
      SleepEx(Delay, FALSE);
   }
   return;
}
////////////////////////////////////////////////////////////////////////////////
// SAM32.c


uchar SetAdapterType(uchar Type, char *type)
{
   if (FileDesc)
   {
      AuthFlag = FALSE;
      CloseCOM(FileDesc);
      FileDesc = NULL;
   }
   SetPortType((int)Type, type);
   return TRUE;
}

void SetPortType(int Type, char *type )
{
   switch(Type)
   {
   case SERIAL_DS2480:
      gType = DS2480;
      if (type != NULL)
         strcpy(szPort, type);   
      break;
   case PARALLEL_DS1481:
      gType = DS1410;
      break;
   case SERIAL_DS1413:  // DS1413
      gType = DS1413;
      if (type != NULL)
         strcpy(szPort, type);   
      break;
   }
   return;
}

uchar SetAdapterSpeed(ulong speed)
{
   switch (gType)
   {
   case SERIAL_DS2480:
      if (DS2480SetSpeed((int)FileDesc,speed) >= 0)
      {
         return TRUE;
      }
      else
      {
         return FALSE;
      }
      break;
      
   default:
      break;
   }
   
   return TRUE;
}

uchar SetAdapter5VTime(uchar time)
{
   switch (gType)
   {
   case SERIAL_DS2480:
      if (DS2480SetParm((int)FileDesc,PARMSEL_5VPULSE,time) >= 0)
      {
         return TRUE;
      }
      else
      {
         return FALSE;
      }
      break;
      
   default:
      break;
   }
   return TRUE;
}

uchar Adapter5VPrime(void)
{
   switch(gType)
   {
   case SERIAL_DS2480:
      DS2480BitPrime();
      break;
   }
   return TRUE;
}

uchar Adapter5VCancel(void)
{
   switch (gType)
   {
   case SERIAL_DS2480:
      if (DS2480StrongPUOff((int)FileDesc) >= 0)
         return TRUE;
      else
         return FALSE;
      break;
      
   }
   return TRUE;
}

int Adapter5VActivate(ulong ustimeout)
{
   switch (gType)
   {
   case SERIAL_DS2480:
      if (DS2480StrongPUOn((int)FileDesc) >= 0)
      {
         Sleep(ustimeout/1000 + 1);
         /* Turn off just to make sure */
         DS2480StrongPUOff((int)FileDesc);
         return TRUE;
      }
      else
      {
         return TRUE;
      }
      break;
   }
   return(TRUE);
}

uchar iBStreamRS(uchar *arr,int length,int run)
{
  int i;
  int AccessGood = FALSE;
  uchar accessarray[9];
  
  switch (gType)
  {
    case SERIAL_DS2480:
      AccessGood = DS2480StreamRS((int)FileDesc,RomDta,arr,length,run);
      break;
      
    default:
      if (DOWReset())
      {
        AccessGood = TRUE;
  
        /* Set up block for transmit */
        accessarray[0] = 0x55;
        for (i = 1;i < 9;i++)
          accessarray[i] = RomDta[i-1];
        /* Transmit block. */    
        iBDataBlock(accessarray,9);
        iBDataBlock(arr,length);
        if (run == 1)
        {
          SetAdapter5VTime(PARMSET_infinite);
          Adapter5VPrime();
          AccessGood = (iBDataBit(1)?0:1);
        }
      }
      break;
  }

  return AccessGood;  
}

uchar iBStream(uchar *arr,int length)
{
  int i;
  int AccessGood = FALSE;
  uchar accessarray[9];
  
  switch (gType)
  {
    case SERIAL_DS2480:
      AccessGood = DS2480Stream((int)FileDesc,RomDta,arr,length);
      break;
      
    default:
      	  
      if (DOWReset())
      {
		  AccessGood = TRUE;
  
        /* Set up block for transmit */
        accessarray[0] = 0x55;
        for (i = 1;i < 9;i++)
          accessarray[i] = RomDta[i-1];
        /* Transmit block. */    
        iBDataBlock(accessarray,9);
        iBDataBlock(arr,length);
      }
	   break;
  }

  return AccessGood;  
}

/*
 * Get the version of the Access Layer.
 */
unsigned long GetAccessAPIVersion()
{
  return (((unsigned long)VERSION_MINOR)<<16) + VERSION_MAJOR;
}
