/*****************************************************************************
 *
 * sauthunx.h        
 *
 *   Main include file for sauthunx.c (iButton access system)
 *
 ****************************************************************************/

#include "ds2480com.h"
#include "ds2480.h"
#include "serial.h"

#define TRUE  1
#define FALSE 0

#define SERIAL_DS2480   0
#define PARALLEL_DS1481 1
#define MAXTYPE	        1
#define MAXFILENAMELEN  40

#define DO_RESET         0
#define DO_BIT           1 
#define DO_BYTE          2 
#define TOGGLE_OVERDRIVE 3 
#define TOGGLE_PASSTHRU  4 
#define CHECK_BRICK      5 

#define DS1410_KEY    0x135506C4; 
#define OUR_SEM_PERMS 0x1B6;      /* Any process is allowed sem access */

typedef unsigned char uchar;

typedef struct _DOWComm
{
   uchar Command;
   uchar Xfer;
}
DOWComm, *PDOWComm;

/*
 *  DS1481 mode control functions
 */
uchar EnterPassthru(void);
uchar ExitPassthru(void);
void  TogglePassthru(void);
uchar iBOverdriveOn(void);
void  iBOverdriveOff(void);

/*
 *   These functions communicate directly with DOW PDD or TTY driver.
 */
int DOWReset(void);
int DOWBit(uchar);
int DOWByte(uchar);
int DOWBlock(uchar *,int);
int ToggleOverdrive(void);
int Send4(void);
int DS1481Present(void);

/*
 *   Implements DOW ROM search algorithm.
 */
int RomSearch(void);

/*
 *  Access system functions
 */
uchar iBDOWCheck(void);                 
uchar iBKeyOpen(void);
uchar iBKeyClose(void);
uchar iBSetup(uchar);
uchar iBNext(void);
uchar iBFirst(void);
uchar iBAccess(void);
uchar iBFastAccess(void);
uchar gndtest(void);
uchar iBDataByte(uchar);
uchar iBDataBlock(uchar *, int);
uchar *iBROMData(void);
uchar SetAdapterSpeed(ulong);
uchar SetAdapterType(uchar, char *);
