/* ************************************************************************* */
/* Sauth400.c                                                                */
/* DS Software Authorization SDK 4.3                                         */
/* Disk 1 - Dos Object & Source Files                                        */
/* 02/06/98                                                                  */
/*                                                                           */
/* Copyright (C) 1996 Dallas Semiconductor Corporation.                      */
/* All rights Reserved. Printed in U.S.A.                                    */
/* This software is protected by copyright laws of                           */
/* the United States and of foreign countries.                               */
/* This software is furnished under a license agreement and/or a             */
/* nondisclosure agreement and may only be used or copied in accordance      */
/* with the terms of those agreements.                                       */
/* The mere transfer of this software does not imply any licenses            */
/* of trade secrets, proprietary technology, copyrights, patents,            */
/* trademarks, maskwork rights, or any other form of intellectual            */
/* property whatsoever. Dallas Semiconductor retains all ownership rights.   */
/*                                                                           */
/* Additional Notes:                                                         */
/*    This code was compiled using Boreland 4.5 along with the Turbo         */
/*    Assembler.  Use of other compilers may require slight modification.    */
/*                                                                           */
/*    This software is intended for use with DS1410D and DS1410E and later   */
/*    model parallel port adapters only.                                     */
/*                                                                           */
/*       Version 4.2 -> Added DS1410E support                                */
/*       Version 4.3 -> Fixed timeout values                                 */
/*                      Fixed timit routine on Pentium Pros - uses longs     */
/*                           for BurnUSec                                    */
/*                      Fixed printer grounding pin 14 on ds1410E, add out to*/
/*                      DATA_REG of 0xEC - 6/19/97 - CW                      */
/*                                                                           */
/* ************************************************************************* */ 
#include <dos.h>
#include <stdio.h>
#include <conio.h>

#ifdef __BORLANDC__
#define ASM asm  
#pragma inline  
#define DISABLE disable
#define ENABLE  enable
#else
#define ASM _asm      
#define DISABLE _disable
#define ENABLE  _enable
#endif




#define TRUE  1
#define FALSE 0

#define inb  inp
#define outb outp

#define RESET 0xFD  // Set data lines to 0xFD to perform a reset
#define W0BIT 0xFE  // Set data lines to 0xFE to send a write 0 
#define RWBIT 0xFF  // Set data lines to 0xFF to send a write 1 or read 0/1 

#define C_DIVIDEND 4888

//
//    MAX_2 * 2 = the number of us before a bit is timed out.
//
#define MAX_W 2000     
#define MAX_WAIT_TS 25

/*
   This must be uncommented if the target platform is 32-bits !
#define PROC_32
*/

typedef unsigned char  uchar;
typedef unsigned short ushort;
typedef unsigned long  ulong;

//
//    Timing functions
//
static void   SpinUSec(ushort);
static void   SpinMSec(ushort);
static void   SpinCal(void);
static ushort TimeIt(ushort);
static uchar  CheckOD(void);

//
//    Internal function prototypes
//
static uchar DOWBit(uchar);      
static uchar DOWByte(uchar);
static uchar DOWReset(void);
static uchar DS1481Comm(uchar);
static uchar RomSearch(void);
static uchar ToggleOverdrive(void);
static void  TogglePassthru(void);
static uchar EnterPassthru(void);
static uchar ExitPassthru(void);
static uchar DS1481Present(void);

//
//    Access system function prototypes
//
uchar far pascal dowcheck(void);      
uchar far pascal keyopen(void);
uchar far pascal keyclose(void);
uchar far pascal first(void);   
uchar far pascal next(void);
uchar far pascal access(void);
uchar far pascal gndtest(void);
uchar far pascal databyte(uchar);
uchar far pascal setup(uchar);
void  far pascal OverdriveOff(void);
uchar far pascal OverdriveOn(void);
uchar far * far pascal romdata(void);

static  uchar  SetupOk = FALSE; 
static  uchar  Passthru = TRUE;
static  uchar  FailNext;
static  uchar  AccessGood;
static  uchar  TimeOut;
static  uchar  l0 = 0;
static  uchar  RomDta[8] = { 0, 0, 0, 0, 0, 0, 0, 0 };
static  ushort pa_vals[3] = { 0x378, 0x278, 0x3BC };
static  ushort bpa = 0x378; 

uchar far pascal keyopen(void)   
{
   ExitPassthru();

   if(CheckOD())
      OverdriveOff();              // call overdrive off if mixed stacking is not enabled
   return TRUE;
}

uchar far pascal keyclose(void)
{
   EnterPassthru();
   return TRUE;
}
//
//    No device driver is required for DOS operation, so dowcheck will 
// simply return TRUE.
//
uchar far pascal dowcheck(void)                          
{
   return TRUE;    
}

static void TogglePassthru(void)
{
   uchar i;

   for (i = 0; i < 4; i++)
      ToggleOverdrive();
   SpinMSec(20);
}

static uchar EnterPassthru(void)
{
   uchar i = 0;
   Passthru = FALSE;
   while (!Passthru && (i++ < 3))
   {
      TogglePassthru();
      Passthru = !DS1481Present();
   }
   return TRUE; 
}

static uchar ExitPassthru(void)
{
   uchar i = 0;

   Passthru = TRUE; 
   while (Passthru && (i++ < 3))
   {
      TogglePassthru();
      
      Passthru = !DS1481Present();
   }
   return !Passthru;
}

//
//    This function sets the base port address.
//
uchar far pascal setup(uchar pn)             
{
   // Initialize global flags
   SetupOk = FailNext = AccessGood = FALSE;         

   // Reset RomSearch (first, next) algorithm 
   FailNext = FALSE;                             
   l0 = 0;                            

   // Make sure port number is valid
   if (pn > 0 && pn < 4)           
   {
      // This allows all other functions to execute
      SetupOk = TRUE;            
      // Set base port address
      bpa = pa_vals[pn - 1]; 
   }
   else
      bpa = pa_vals[0];  // Set to default in case caller ignores FALSE return

   // Return result of setup function
   return SetupOk;                          
}

//
//    Find next DOW part on selected LPT port
//
uchar far pascal next(void)               
{
   uchar tr;

   if (SetupOk)
   {
      // See if last search found last button
      if (FailNext)                    
      {
         FailNext = FALSE; 

         // Reset next function 
         l0 = 0;                                        
      } 
      else while ((tr = RomSearch()) != 0) 
      {
         // See if we should force failure
         if (tr == 2) 
            FailNext = 1;                
   
         // Detect short circuit
         if (!RomDta[0])       
            return FALSE;

         AccessGood = TRUE;

         return TRUE;
      }
   }

   return FALSE;                                                    
}

//
//    Find first DOW part on specified port
//
uchar far pascal first(void)        
{
   // Don't force a failure here 
   FailNext = FALSE;                             
   // Point Rom Search algorithm to the top
   l0 = 0;                            

   // Go look for the first DOW part on the bus 
   return next();               
}

//
//    Strong access
//
uchar far pascal access(void)                               
{
   uchar i, j;                                     

   // Assume failure 
   AccessGood = FALSE;                                       

   // Send reset pulse
   if (DOWReset())                                         
   {
      // ROM search command byte
      DOWByte(0xF0);                                

      // Byte loop
      for (i = 0; i < 8; i++)                                     
      {
         // Bit loop
         for (j = 0; j < 8; j++)                                   
         {
            if (((DOWBit(TRUE) << 1) | DOWBit(TRUE)) == 3)                
               return FALSE;     
            // Send write time slot
            DOWBit((uchar) ((RomDta[i] >> j) & 1));    
         }      
      }
      // Success if we made it through all the bits
      AccessGood = TRUE;         
   }
   return AccessGood;  
}
//
//    Transmit data to buttons on the selected LPT port
//
uchar far pascal databyte(uchar br)      
{
   return (SetupOk && AccessGood) ? DOWByte(br) : br;
}

uchar far pascal gndtest(void)
{
   return SetupOk;
}

uchar far * far pascal romdata(void)
{
   // Return pointer to ROM Data buffer 
   return RomDta;                         
}

//
//     This function performs a ROM search and finds one part on the DOW bus
// per call.
//
//      Return values : 0 => No parts on bus or bus error
//                      1 => A part was found and more are out there
//                      2 => A part was found and it was last one on the bus
//
static uchar RomSearch(void) 
{
   uchar i = 0, x = 0, ld = l0;
   uchar RomBit, Mask;

   // Reset DOW bus
   if (DOWReset())      
      DOWByte(0xF0);  // Send search command
   else
      return FALSE;   // No DOW parts were found on bus

   // While not done and not bus error
   while ((i++ < 64) && (x < 3))     
   {
      // Get bit mask
      Mask = 1 << ((i - 1) % 8);                               

      // Get last pass bit
      RomBit = RomDta[(i - 1) >> 3] & Mask ? TRUE : FALSE; 

      // Send read time slots
      x = DOWBit(TRUE) << 1;  
      x |= DOWBit(TRUE);     

      // Is there a disagreement in this bit position
      if (!x)                  
      {
         // Stay on old path or pick a new one ?
         if (i >= ld)                 
            RomBit = (i == ld);         // Send write 1 if at position of ld 
         // Save this value as temp last disagreement 
         if (!RomBit)             
            l0 = i;
      } 
      else 
         RomBit = (x & 1) ^ 1;          // Get lsb of x and flip it 

      if (RomBit)              
         RomDta[(i - 1) >> 3] |= Mask;          // Set bit in Rom Data byte
      else
         RomDta[(i - 1) >> 3] &= (Mask ^ 0xFF); // Clear bit in Rom Data byte
      // Send write time slot
      DOWBit(RomBit);                                  
   }
   return (x == 3) ? 0 : 1 + (ld == l0);        
}

static uchar DOWReset(void)     
{
   // Extra reset to clear passthru communication for DS1410D
   DS1481Comm(RESET); 
   // Sampling a low => presence detected => success
   return DS1481Comm(RESET) ^ 1; 
}

static uchar DOWBit(uchar tbit)
{
   // Return sampled value 
   return DS1481Comm(tbit ? RWBIT : W0BIT);            
}

static uchar DOWByte(uchar bts)
{
   uchar i, brecv = 0;
   // Call DOWBit 8 times to transfer entire byte
   for (i = 0; i < 8; i++)      
   {
      brecv >>= 1;
      // Smush bit into byte
      brecv |= DOWBit((uchar) (bts & 1)) ? 0x80 : 0;    
      bts >>= 1;
   }
   // Return result sampled on 1-wire bus
   return brecv;                        
}

uchar far pascal OverdriveOn(void)
{
   if (!DOWReset())
      return FALSE;

   // Put all parts in overdrive mode 
   DOWByte(0x3C);

   return ToggleOverdrive() ? TRUE : ToggleOverdrive();
}

void far pascal OverdriveOff(void)
{
   // Turn overdrive off
   if (ToggleOverdrive())
      ToggleOverdrive();
   return;
}
//
//    Change state of overdrive ff in all 1481s on LPT port.
//
static uchar ToggleOverdrive(void)
{
   uchar DOWRes, ControlReg;
   
   // Disable interrupts 
   ASM cli;                                           
   // Set initial state of data lines, don't drop /ENI
   outb(bpa, 0xEC);
   SpinUSec(2);
   // Set initial state of data lines to FC (D0, D1 low)&drop /ENI if 14 is grounded
   outb(bpa, 0xFC);                     
   // Save I/O pins and force 16 high
   ControlReg = inb(bpa + 2) | 0x04;        
   // Mask EPP bits 
   ControlReg &= 0x1C;      
   // Drive 14 (chip select) low 
   outb(bpa + 2, ControlReg | 0x02);             
   // Spin around for 4 us.  
   SpinUSec(8);
   // Get bit result
   DOWRes = ((inb(bpa + 1) ^ 0x80) & 0x90) ? TRUE : FALSE;   
   // Spin around for 4 us.  
   SpinUSec(8);
   // Drive pin 14 back high again !!!
   outb(bpa + 2, ControlReg & 0xFD); 
   outb(bpa, 0xCF);
   SpinUSec(8);
   // Allow interrupts back in 
   ASM sti;                                      
   return DOWRes;
}

static uchar DS1481Present(void)
{
   // Do a reset to invoke last part detect circuitry
   DS1481Comm(RESET);
   if (DS1481Comm(0xFF)) 
      return !TimeOut;
   return FALSE;
}

static uchar CheckOD(void)
{
   uchar OverDrive = FALSE;
   uchar ControlReg;
   ushort MDelay;
   // Set initial state of data lines w/out dropping /ENI
   outb(bpa, 0xEC);
   SpinUSec(2);
   // Set initial state of data lines
   outb(bpa, 0xFF);
   SpinUSec(2);
   // Save I/O pins and force 16 high
   ControlReg = (inb(bpa + 2) | 0x04) & 0x1C;
   // Start time slot
   ASM cli;
   outb(bpa + 2, ControlReg | 0x02);
   SpinUSec(16);
   OverDrive = ((inb(bpa + 1) ^ 0x80) & 0x90) ? TRUE : FALSE;
   ASM sti;
   MDelay = 0;  // bug fix 4.3 (used to be i = 0)
   outb(bpa, 0xFF);
   while (!((inb(bpa + 1) ^ 0x80) & 0x90) && (MDelay++ < MAX_W))
      SpinUSec(4);
   // drive clk line low to get our bit
   outb(bpa, 0xFE);
   SpinUSec(4);

   //Get bit result
   inb(bpa + 1);

   outb(bpa + 2, (ControlReg & 0xFD));
   outb(bpa, 0xCF);
   SpinUSec(5);
   return OverDrive;
}

static uchar DS1481Comm(uchar DRegByte)
{
   uchar  DOWRes, ControlReg;
   ushort MDelay;
   ASM cli;                                           
   outb(bpa, 0xEC);
   SpinUSec(2);
   // Set initial state of data lines
   outb(bpa, DRegByte);                     
   // Save I/O pins and force 16 high
   ControlReg = inb(bpa + 2) | 0x04;        
   // Mask EPP bits 
   ControlReg &= 0x1C;      
   // Drive 14 (chip select) low 
   outb(bpa + 2, ControlReg | 0x02);             
   MDelay = 0;
   // Wait for DS1481 to issue busy signal
   while (((inb(bpa + 1) ^ 0x80) & 0x90) && (MDelay++ < MAX_W)) 
      SpinUSec(4);
   
   ASM sti
   SpinUSec(4);
   // Now we can change the state of the data lines 
   outb(bpa, 0xFF);           
   // Wait for busy signal to go away
   while (!((inb(bpa + 1) ^ 0x80) & 0x90) && (MDelay++ < MAX_W))
      SpinUSec(4);
   // Drive clk line low to get our bit
   outb(bpa, 0xFE);                       
   // Wait for valid bit result
   SpinUSec(4);
   // Get bit result
   DOWRes = ((inb(bpa + 1) ^ 0x80) & 0x90) ? TRUE : FALSE;   
   if (DOWRes && DRegByte == RESET)
   {
      SpinUSec(400);
      outb(bpa, 0xFF);
      SpinUSec(4);
      outb(bpa, 0xFE);
      SpinUSec(4);
      DOWRes = ((inb(bpa + 1) ^ 0x80) & 0x90) ? TRUE : FALSE;
   }
   // Drive pin 14 back high again !!!
   outb(bpa + 2, ControlReg & 0xFD); 
   //
   //    Restore supply lines, But leave a couple low to disable chip 
   // select if 14 is grounded on printer side.
   //
   outb(bpa, 0xCF);
   // Wait a while with supply lines high 
   SpinUSec(12);
   TimeOut = (MDelay < MAX_W) ? FALSE : TRUE;
   // Return 1-wire result  
   return DOWRes;                                      
}

static  ushort CountVal = 0;

static void SpinUSec(ushort USec)
{
   long   mulval, checkval; 
   ushort tempvalHi, tempvalLo;     
   ushort tempval,i;              

   checkval = 0x0000FFFF;       // this does away with a couple of warnings
   // Perform initial timing calibration
   if (!CountVal)
      SpinCal(); 
   for (i = 0; i < USec; i++)
   {
#ifdef PROC_32
      // ECX is used in loop instruction in 32-bit protected mode!
      _ECX = 0;
      _EAX = 0;
#endif
#ifdef __BORLANDC__
       _CX = (ushort)CountVal;
#else
       tempval = (ushort)CountVal;
       ASM mov cx, tempval
#endif
b1:
       ASM loop b1
   }
  
}

static void SpinMSec(ushort MSec)
{
   ushort i,j;

   // Wait for MSec ms
   for (i = 0; i < MSec; i++)
         SpinUSec(1000);
}

static  void SpinCal(void)
{
   // Turn off interrupts for accurate timing measurements
   ASM cli;
   // if _CX = CountVal, loop $ will burn 1 usec.
   CountVal = (C_DIVIDEND / (TimeIt(2049) - TimeIt(1))) + 1;
   // Turn interrupts back on
   CountVal *= 2;
   ASM sti;
}

static  ushort ReadCounter(void)
{
   ushort Count;
   // Freeze counter
   outb(0x43, 0);
   // Read the low byte of the counter
   Count = inb(0x40); 
   // Compute 16-bit count value
   return  Count | (ushort) (inb(0x40) << 8); 
}

static  ushort TimeIt(ushort LoopCount)
{
   ushort InitCount, FinalCount;
   // Read initial counter value
   InitCount = ReadCounter(); 
#ifdef PROC_32
   // ECX is used in loop instruction in 32-bit protected mode!
   _ECX = 0; 
#endif 

#ifdef __BORLANDC__
   _CX = LoopCount;
#else
	ASM mov cx, LoopCount
#endif  

t1:
   ASM loop t1
   // Read current value of the counter
   FinalCount = ReadCounter(); 
   // Return difference
   return (InitCount - FinalCount);
}
