////////////////// Copyright 1994-1996 Dallas Semiconduction /////////////////////
/////////////////////////////////////////////////////////////////////////////
//  TSECC.CPP - Main module for the example program calling on SATLINK.DLL.
// 
//  Version 4.00
//

#include <afxwin.h>
#include "resource.h"
#include "TSECC.h"

/////////////////////////////////////////////////////////////////////////////
// theApp:
// Just creating this application object runs the whole application.
//
CTheApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////

// CMainWindow constructor:
// Create the window with the appropriate style, size, menu, etc.
//
CMainWindow::CMainWindow()
{
    LoadAccelTable( "MainAccelTable" );
    Create( NULL, "TSECC - SATLINK example C++ Program",
        WS_OVERLAPPEDWINDOW, rectDefault, NULL, "MainMenu" );
}


/////////////////////////////////////////////////////////////////////////////
// Display the about box
//
void CMainWindow::OnAbout()
{
    CDialog about( "AboutBox", this );
    about.DoModal();
}

// CMainWindow message map:
// Associate messages with member functions.
//
// It is implied that the ON_WM_PAINT macro expects a member function
// "void OnPaint()".
//
// It is implied that members connected with the ON_COMMAND macro
// receive no arguments and are void of return type, e.g., "void OnAbout()".
//
BEGIN_MESSAGE_MAP( CMainWindow, CFrameWnd )
    //{{AFX_MSG_MAP( CMainWindow )
    ON_COMMAND( IDM_ABOUT, OnAbout )
    ON_COMMAND(IDM_CHECKTIMER, OnChecktimer)
    ON_COMMAND(IDM_EXIT, OnExit)
    ON_COMMAND(IDM_READDATA, OnReaddata)
    ON_COMMAND(IDM_READID, OnReadid)
    ON_COMMAND(IDM_READTIMER, OnReadtimer)
    ON_COMMAND(IDM_SETTIMER, OnSettimer)
    ON_COMMAND(IDM_WRITEDATA, OnWritedata)
    ON_COMMAND(IDM_WRITEPROTTECT, OnWriteprottect)
    ON_COMMAND(IDM_NEXTDEVICE, OnNextdevice)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTheApp
// InitInstance:
// When any CTheApp object is created, this member function is automatically
// called.  Any data may be set up at this point.
//
// Also, the main window of the application should be created and shown here.
// Return TRUE if the initialization is successful.
//
BOOL CTheApp::InitInstance()
{
    SetDialogBkColor();     // hook gray dialogs (was default in MFC V1)

    m_pMainWnd = new CMainWindow();
    m_pMainWnd->ShowWindow( m_nCmdShow );
    m_pMainWnd->UpdateWindow();

    return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// Check to see it the timer has expired on the DS1427/DS1994
//                                                         
void CMainWindow::OnChecktimer()
{
    if (CheckTimer())  
        MessageBox("NOT EXPIRED","TSECC",MB_OK);
    else
        MessageBox("EXPIRED or Not present","TSECC",MB_OK);     
}


/////////////////////////////////////////////////////////////////////////////
//  Quit the application
//
void CMainWindow::OnExit()
{                                        
    DestroyWindow();
}


/////////////////////////////////////////////////////////////////////////////
//  Attempt to read a default data packet in the nv-ram space
//  of the DS1427/DS1994.
//
void CMainWindow::OnReaddata()
{
    uchar b[512]; 
    char txt[200]; 
    int len;
        
    len = ReadData(b);                       
    if (len > 0)  
    {             
        sprintf(txt,"The DS1427/DS1994 data:\n %s",b);
        MessageBox(txt,"TSECC",MB_OK);
    }
    else
        MessageBox("Error trying to read, key not "
               "present or no data!","TSECC",MB_OK);
}


/////////////////////////////////////////////////////////////////////////////
// Attempt to read the id of the DS1427/DS1994
//
void CMainWindow::OnReadid()
{
    uchar b[10]; 
    char txt[200];
                       
    if (ReadID(b))  
    {             
        sprintf(txt,"The DS1427/DS1994 ID is %02X%02X%02X%02X%02X%02X%02X%02X",
            b[7],b[6],b[5],b[4],b[3],b[2],b[1],b[0]);
        MessageBox(txt,"TSECC",MB_OK);
    }
    else
        MessageBox("Could not find the DS1427/DS1994!","TSECC",MB_OK);
}


/////////////////////////////////////////////////////////////////////////////
// Attempt to read the real time clock and alarm of the DS1427/DS1994
//
void CMainWindow::OnReadtimer()
{
    uchar cl[50],cla[50]; 
    char txt[200];
                       
    if (ReadTimer(cl,cla))  
    {             
        sprintf(txt,"DS1427/DS1994 Real-time clock\n %s\n"
            "Real-time clock alarm\n %s",
            cl,cla);
        MessageBox(txt,"TSECC",MB_OK);
    }
    else
        MessageBox("Could not find the DS1427/DS1994!","TSECC",MB_OK);
}


/////////////////////////////////////////////////////////////////////////////
// Attempt to set the timer to a 3 day limit
//
void CMainWindow::OnSettimer()
{
    if (TimerSet(3))  
        MessageBox("Timer set for 3 days from now.","TSECC",MB_OK);
    else
        MessageBox("Error trying to set the timer, key not"
               " present or write protected!","TSECC",MB_OK);       
}


/////////////////////////////////////////////////////////////////////////////
// Attempt to write the message 'this is a test' to the nv-ram
// space of the DS1427/DS1994.
//
void CMainWindow::OnWritedata()
{
    if (WriteData((uchar far *)"This is a test",14))  
        MessageBox("Data written to DS1427/DS1994","TSECC",MB_OK);
    else
        MessageBox("Error trying to write, key not"
               " present or write protected!","TSECC",MB_OK);       
}


/////////////////////////////////////////////////////////////////////////////
// Search for the next DS1427/DS1994
//
void CMainWindow::OnNextdevice()
{
    if (NextDS1427())  
        MessageBox("Found Next DS1427/DS1994","TSECC",MB_OK);
    else
        MessageBox("End of DS1427/DS1994 List","TSECC",MB_OK); 
}


/////////////////////////////////////////////////////////////////////////////
// Attempt to write protect the clock and clock alarm registers
// in the DS1427/DS1994.
//
void CMainWindow::OnWriteprottect()
{                                
    // prompt to make sure you want to writeprotect
    if (MessageBox("This operation will write protect the Real-time clock "
           "and alarm register of the DS1427/DS1994. Once the alarm "
           "expires, everything on the DS1427/DS1994 will be write "
           "protected!  Continue anyway?","TSECC",
           MB_ICONQUESTION | MB_OKCANCEL) == IDOK)
    {
    if (WriteProtectT()) 
        MessageBox("The DS1427's/DS1994's Real-time clock and alarm register"
               " are now write protected.","TSECC",MB_OK);
    else
        MessageBox("Error trying to write protect DS1427/DS1994!","TSECC",MB_OK);
    }
}

