//
//   sacwd400.c                                       { Ver 4.00 05/02/96 }  
//  (CCW)                                             
//  Copyright (C) 1994, 1995, 1996 Dallas Semiconductor Corporation. 
//  All rights Reserved. Printed in U.S.A.
//  This software is protected by copyright laws of
//  the United States and of foreign countries.
//  This material may also be protected by patent laws of the United States 
//  and of foreign countries.
//  This software is furnished under a license agreement and/or a
//  nondisclosure agreement and may only be used or copied in accordance
//  with the terms of those agreements.
//  The mere transfer of this software does not imply any licenses
//  of trade secrets, proprietary technology, copyrights, patents,
//  trademarks, maskwork rights, or any other form of intellectual
//  property whatsoever. Dallas Semiconductor retains all ownership rights.
//
//       Version 4.2 -> Added DS1410E support
//       Version 4.3 -> Fixed timeout values in ds1481comm
//                      Fixed timit routine on Pentium Pros - uses longs
//                         for BurnUSec
//                      Fixed printer grounding pin 14 on ds1410E, added out to
//                         DATA_REG of 0xEC - 6/19/97 - CW

#include <windows.h>
#include <dos.h> 
#include <conio.h>
#include "sacwd400.h"

//int semaphore;

#define inb  inp
#define outb outp 

#ifdef __BORLANDC__

#define ASM asm  
#pragma inline  
#define DISABLE disable
#define ENABLE  enable
#else
 
#define ASM _asm      
#define DISABLE _disable
#define ENABLE  _enable
#endif


#define INITTIME  0x00
#define CHECKTIME 0x01

#define RESET 0xFD  // Set data lines to 0xFD to perform a reset
#define W0BIT 0xFE  // Set data lines to 0xFE to send a write 0 
#define RWBIT 0xFF  // Set data lines to 0xFF to send a write 1 or read 0/1 

#define C_DIVIDEND 4888

//
//    MAX_2 * 2 = the number of us before a bit is timed out.
//
#define MAX_W 2000     
#define MAX_WAIT_TS 25
/*
   This mus be uncommented if the target platform is 32-bits !
#define PROC_32
*/
typedef unsigned char  uchar;
typedef unsigned int   uint;
typedef unsigned long  ulong;
typedef unsigned short ushort;

uint  far      _export pascal setup(uchar, sa_struct far *);
uint  far      _export pascal first(sa_struct far *);
uint  far      _export pascal next(sa_struct far *);
uint  far      _export pascal access(sa_struct far *);
uint  far      _export pascal saccess(sa_struct far *);
uint  far      _export pascal databyte(uchar, sa_struct far *);
uint  far      _export pascal gndtest(sa_struct far *);
uchar far *far _export pascal romdata(sa_struct far *);
uchar far      _export pascal keyopen(void);
void  far      _export pascal keyclose(void);
void  far      _export pascal copyromdata(int far *, sa_struct far *);
void  far      _export pascal copy2romdata(int far *, sa_struct far *);
void  far      _export pascal OverdriveOff(void);
uchar far      _export pascal OverdriveOn(void);
uchar far      _export pascal databit(uchar tbit, sa_struct far *);
uchar far      _export pascal dowcheck(void);
//
//    Timing functions
//
static void   SpinUSec(ushort);
static void   SpinMSec(ushort);
static void   SpinCal(void);
static ushort TimeIt(ushort);
static uchar  CheckOD(void);

//
//    Internal function prototypes
//
static uchar ToggleOverdrive(void);
static void  TogglePassthru(void);
static uchar EnterPassthru(void);
static uchar ExitPassthru(void);
static uchar DS1481Present(void);



static uchar DS1481Comm(uchar);
static uchar touchreset(void);
static uchar touchbyte(uchar);
static uchar touchbit(uchar);

#define MAGIC 0x695a

static char  *copyright = "COPYRIGHT (C) 1991, 1992, 1994, 1995, 1996 DALLAS SEMICONDUCTOR";
static uint  bpa;
static uint  pavals[3] = { 0x378, 0x278, 0x3BC };
static ulong far *SysClock;
static ulong InitTime;
static uchar TimeOutFlag;
static uchar TimeOut;
static uchar Passthru = TRUE;

#pragma argsused

int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSegment,
                       WORD      wHeapSize, LPSTR lpszCmdLine)
{
    if (wHeapSize != 0)
        UnlockData(0);

    return 1;
} 

uchar far _export pascal dowcheck(void)
{
   return TRUE;
}
//
//  SETUP must be called before any of the other functions to
//  establish the printer port number to be used.
//
//  The function returns 1 if 1 <= port_num <= 3. 
//
//  This function can be called at any time to to switch to a different 
//  printer port.
// 
uint far _export pascal setup(uchar port_num, sa_struct far *gb)
{
   gb->ld       = 0;    // initialize the 'garbage bag'   
   gb->lastone  = 0;
   gb->unit     = 0;
   gb->count    = 0;
   gb->port     = 0;
   gb->accflg   = 0;
   gb->setup_ok = 0;

   if ((port_num < 1) || (port_num > 3))   
      return 0;

   bpa = pavals[port_num - 1];
   gb->unit     = port_num;
   gb->port     = bpa;   // *(base+port_num);
   gb->setup_ok = MAGIC;

   //bpa = gb->port;                      

   SysClock = MK_FP(0x40, 0x6C);

   return 1;
}

//
//   Romsearch looks for the next device that is connected.
//   It returns 1 and romdta if something is found.  0 is 
//   returned when nothing is on the line.  Romsearch relies 
//   on the contents of the 'garbage bag'.  Notice that ONLY 
//   next() calls romsearch.
//  
static int romsearch(sa_struct far *gb)
{
   uchar i;                     // rombit index   
   uchar j = 0;
   int   flag;
   uchar k = 1;
   uchar g;
   uchar lo = 0;
   uchar nxt;
   uchar x;

   nxt = 0;                     // set the next flag to false   

   if (gb->lastone)
   {
      gb->lastone = 0;
      return 0;
   }

   i    = 1;
   flag = touchreset();

   // if there are no parts or alarming parts on 1-wire, return 0  
   if (!(flag == 1 || flag == 2))
   {
      gb->ld = 0;                // reset the search   
      return 0;
   }

   x = touchbyte(0xf0);         // issue the search rom command   

   do                           // look for ds1991,2,3 or 4  
   {
      x  = touchbit(1) << 1;    // read bit a   
      x |= touchbit(1);         // read bit b   

      if (x == 3)               // there are no devices on 1-wire   
      {
         gb->ld = 0;
         return nxt; 
      }

      if (x > 0)                // all devices coupled have 0 or 1   
         g = !(x & 0x01);       // bit write value for search   
      else                      // bit a = bit b = 0   
      {
         // if this discrepancy if before the last discrepancy
         //  on a previous next then pick the same as last time   
         if (i < gb->ld)
            g = ((gb->romdta[j] & k) > 0);
         else                   // if equal to last pick 1   
            g = (i == gb->ld);   // if not then pick 0        

         if (g == 0)
            lo = i;             // if 0 was picked, record its position in lo   
      }
      if (g == 1)
         gb->romdta[j] |= k;     // set the bit in the rom byte   
      else
         gb->romdta[j] &= ~k;    // clear the bit in the rom byte   

      g = touchbit(g);          // rom search write   

      i++;                      // inc the byte counter and shift the mask   
      k = k << 1;
      if (!k)
      {
         ++j;
         ++k;
      }
   }
   while(j < 8);                // loop through all 8 rom bytes   

   if (i < 65)                  // if the search was unsuccessful then   
      gb->ld = 0;                // reset the last discrepancy to 0   
   else
   {                            // search successful to set ld,lastone,nxt   
      gb->ld = lo;
      gb->lastone = (gb->ld == 0);
      nxt = 1;
   }
   return nxt;
}

//
//   Next searchs for the next Software Authorization part.
// If one is found that qualifies, 1 is returned, otherwise
// a 0 is returned.  If the last part on the line is not
// a Software Authorization part, then romdta is cleared.
//   
uint far _export pascal next(sa_struct far *gb)
{
   int i;
   uchar tr;

   if (gb->setup_ok != MAGIC)    // check that setup has been called   
       return 0;
   if (gb->lastone)
   {
      gb->lastone = 0;
   }
   else while ((tr = romsearch(gb)) != 0) 
   {
      if (tr == 2)
         gb->lastone = 1;
      if (!(gb->romdta[0]))
         return FALSE;
      else
         return TRUE;
   }
   return 0;                    // didn't find anything   
}

//
//   Reset search state of romsearch.  Return next.
//  
uint far _export pascal first(sa_struct far *gb)
{
   if (gb->setup_ok != MAGIC)
       return 0;

   gb->ld      = 0;
   gb->lastone = 0;


   return(next(gb));   // go get rom data of first part   
}

//
//   Access issues a touchreset and returns 0 if no presence pulse was 
// detected.  Otherwise it transmits the ROM match command followed 
// by the specific pattern in the internal eight byte buffer and 
// returns 1.  Note that we don't care what is in romdta!
//  
uint far _export pascal saccess(sa_struct far *gb)
{
	return access(gb);
}
uint far _export pascal access(sa_struct far *gb)
{
	int i, j;
   if (gb->setup_ok != MAGIC)
      return 0;
   gb->accflg = 0;
   if (touchreset())
   {
      touchbyte(0xF0);
      for (i = 0; i < 8; i++)
      {
         for (j = 0; j < 8; j++)
         {
            if(((touchbit(TRUE) << 1) | touchbit(TRUE)) == 3)
               return FALSE;        // Part not there
            touchbit((uchar) ((gb->romdta[i] >> j) & 1));
         }
      }
      gb->accflg = 1;
   }
   return gb->accflg;

}

//
//   Databyte returns the value x if setup has never been
// called or if the most recent call to access returned 
// a 0.  Otherwise, it transmits the byte.
//  
uint far _export pascal databyte(unsigned char x, sa_struct far *gb)
{
   if (gb->setup_ok != MAGIC)
       return x;

    if (gb->accflg) 
       return(touchbyte(x)); 
    else 
       return x;
}
// Databit
uchar far _export pascal databit(uchar tbit, sa_struct far *gb)
{
   if (gb->setup_ok != MAGIC)
      return tbit;
   if (gb->accflg)
      return(touchbit(tbit));
   else
      return tbit;
}
//
//  Romdata returns a far pointer to the internal eight byte buffer.
//
uchar far *far _export pascal romdata(sa_struct far *gb)
{
   uchar far *romptr;

   romptr = &(gb->romdta[0]); // point to the first byte of romdta array   
   return(romptr);            // send far pointer back to caller   
}

//
//   Copyromdata copies the byte in romdata to the integers pointed to by ip.
//  
void far _export pascal copyromdata(int far *ip, sa_struct far *gb)
{
   int i;

   for (i = 0; i < 8; ++i)
      ip[i] = (int) gb->romdta[i];
}

//
//   Copy2romdata copies the integers (bottom 8 bits) pointed to by ip
// into romdta.
// 
void far _export pascal copy2romdata(int far *ip, sa_struct far *gb)
{
   int i;

   for (i = 0; i < 8; ++i)
      gb->romdta[i] = 0xff & ip[i];
}

//
//   Gndtest attempts to determine if we can access the parts.  Failure
// often occurs if a printer is connected on the line but is turned
// of or if it is offline.
//   
uint far _export pascal gndtest(sa_struct far *gb)
{
   int status = 0;
   if (gb->setup_ok != MAGIC)
       return 0;
   else
      return TRUE;
}

static int semaphore;

uchar far _export pascal keyopen(void)
{
   uchar retval;

   retval = 1;
   ASM cli;
   if (semaphore)
      retval = 0;
   else
      semaphore = 0;
  
   ASM sti;
   ExitPassthru();
   if(CheckOD())
      OverdriveOff();
   return retval;
}

void far _export pascal keyclose(void)
{
   semaphore = 0;
   EnterPassthru();
}

static uchar touchreset()     
{
   // Extra reset to clear passthru communication for DS1410E
   DS1481Comm(RESET);
   // Sampling a low => presence detected => success
   return DS1481Comm(RESET) ^ 1;
}


static uchar CheckOD(void)
{
   uchar OverDrive = FALSE;
   uchar DOWRes, Busy      = FALSE;
   uchar ControlReg;
   ushort MDelay;
   
   outb(bpa, 0xEC);
   SpinUSec(2);
   // Set initial state of data lines
   outb(bpa, 0xFF);
   SpinUSec(2);
   // Save I/O pins and force 16 high
   ControlReg = (inb(bpa + 2) | 0x04) & 0x1C;
   // Start time slot
   ASM cli;
   outb(bpa + 2, ControlReg | 0x02);
   SpinUSec(16);
   OverDrive = ((inb(bpa + 1) ^ 0x80) & 0x90) ? TRUE : FALSE;
   ASM sti;
   MDelay = 0;
   outb(bpa, 0xFF);
   while (!((inb(bpa + 1) ^ 0x80) & 0x90) && (MDelay++ < MAX_W))
      SpinUSec(4);
   // drive clk line low to get our bit
   outb(bpa, 0xFE);
   SpinUSec(4);

   //Get bit result
   inb(bpa + 1);

   outb(bpa + 2, (ControlReg & 0xFD));
   outb(bpa, 0xCF);
   SpinUSec(5);
   return OverDrive;
}

static uchar touchbit(uchar tbit)
{
   // Get bit from DS1480 
   return DS1481Comm((uchar)(tbit ? RWBIT : W0BIT));   
}

static uchar touchbyte(uchar bts)
{
   uchar bl, brecv = 0;
   // Call DOWBit 8 time to transfer entire byte
   for (bl = 0; bl < 8; bl++)
   {
      brecv >>= 1;
      brecv |= (uchar)touchbit((uchar)(bts & 1)) ? 0x80 : 0;     
      bts >>= 1;
   }
   return brecv;
}

uchar far _export pascal OverdriveOn(void)
{
   if (!touchreset())
      return FALSE;
   // Put all parts in overdrive mode
   touchbyte(0x3C);
   return ToggleOverdrive() ? TRUE : ToggleOverdrive();
}

void far _export pascal OverdriveOff(void)
{
   // Turn overdrive off
   if (ToggleOverdrive())
      ToggleOverdrive();
   return;
}

// Change state of overdrive ff in all 1481s on LPT port.
static uchar ToggleOverdrive(void)
{
   uchar DOWRes, ControlReg;
   ushort i;
   // disable interrupts
   ASM cli
   outb(bpa, 0xEC);
   SpinUSec(2);
   // Set initial state of data lines to FC (D0, D1 low).
   outb(bpa, 0xFC);
   // Save I/O pins and force 16 high
   ControlReg = inb(bpa +2) | 0x04;
   // Mask EPP bits
   ControlReg &= 0x1C;
   //Drive 14 (chip select) low
   outb(bpa + 2, ControlReg |0x02);
   // Spin around for 8us.
   SpinUSec(8);
   //Get bit result
   DOWRes = ((inb(bpa +1) ^ 0x80) & 0x90) ? TRUE : FALSE;
   // Spin around for 8us.
   SpinUSec(8);
   //Drive pin 14 back high again!!
   outb(bpa + 2, ControlReg & 0xFD);
   outb(bpa, 0xCF);
   SpinUSec(8);

   // allow interrupts back in
   ASM sti
   return DOWRes;
}

static uchar DS1481Present(void)
{
   // Do a reset to invoke last part detect circuitry
   DS1481Comm(RESET);
   if (DS1481Comm(0xFF)) 
      return !TimeOut;
   return FALSE;  
}
static uchar DS1481Comm(uchar DRegByte)
{
   uchar  DOWRes, ControlReg;
   ushort MDelay;

   ASM cli
   // Set initial state of data lines
   outb(bpa, 0xEC);
   SpinUSec(2);
   outb(bpa, DRegByte);                     
   // Save I/O pins and force 16 high
   ControlReg = inb(bpa + 2) | 0x04;        
   // Mask EPP bits 
   ControlReg &= 0x1C;      
   // Drive 14 (chip select) low 
   outb(bpa + 2, ControlReg | 0x02);             

   ASM sti
   MDelay = 0;

   // Wait for DS1481 to issue busy signal
   while (((inb(bpa + 1) ^ 0x80) & 0x90) && (MDelay++ < MAX_W)) 
      SpinUSec(4);

   SpinUSec(4);

   // Now we can change the state of the data lines 
   outb(bpa, 0xFF);           

   // Wait for busy signal to go away
   while (!((inb(bpa + 1) ^ 0x80) & 0x90) && (MDelay++ < MAX_W))
      SpinUSec(4);
   
   // Drive clk line low to get our bit
   outb(bpa, 0xFE);                       

   // Wait for valid bit result
   SpinUSec(4);

   // Get bit result
   DOWRes = ((inb(bpa + 1) ^ 0x80) & 0x90) ? TRUE : FALSE;   
   if(DOWRes && DRegByte == RESET)
   {
      SpinUSec(400);
      // Drive clock line high again (fix for alarming parts)
      outb(bpa, 0xFF);
      SpinUSec(4);
      // Drive clock line low to get the bit
      outb(bpa, 0xFE);
      SpinUSec(4);
      // Get bit result
      DOWRes = ((inb(bpa + 1) ^ 0x80) & 0x90) ? TRUE : FALSE;   
   }
   // wait
  // SpinUSec(4);
   // Drive pin 14 back high again !!!
   outb(bpa + 2, (uchar)(ControlReg & 0xFD)); 

   //
   //    Restore supply lines, But leave a couple low to disable chip 
   // select if 14 is grounded on printer side.
   //
   outb(bpa, 0xCF);

   // Wait a while with supply lines high 
   SpinUSec(12);

   TimeOut = (MDelay < MAX_W) ? FALSE : TRUE;
//   SpinUSec(400);
   // Return 1-wire result  
   return DOWRes;                                      

}



static ushort CountVal = 0;

void SpinUSec(ushort USec)
{
   unsigned long mulval, checkval;
   ushort tempval, tempvalHi, tempvalLo,i;
   checkval = 0x0000FFFF;       // this does away with a couple of warnings
   // Perform initial timing calibration
   if (!CountVal)
      SpinCal(); 
   for (i = 0; i < USec; i++)
   {
#ifdef PROC_32
      // ECX is used in loop instruction in 32-bit protected mode!
      _ECX = 0;
      _EAX = 0;
#endif
#ifdef __BORLANDC__
       _CX = (ushort)CountVal;
#else
       tempval = (ushort)CountVal;
       ASM mov cx, tempval
#endif
b1:
       ASM loop b1
   }
}

void SpinMSec(ushort MSec)
{
   ushort i,j;

   // Wait for MSec ms
   for (i = 0; i < MSec; i++)
      for (j = 0; j < 1000; j++)
         SpinUSec(1);
}

static void SpinCal(void)
{
   // Turn off interrupts for accurate timing measurements
   ASM cli
   // if _CX = CountVal, loop $ will burn 1 usec.
   CountVal = (C_DIVIDEND / (TimeIt(2049) - TimeIt(1))) + 1;
   // Turn interrupts back on
   ASM sti
}

static ushort ReadCounter(void)
{
   ushort Count;

   // Freeze counter
   outb(0x43, 0);
   // Read the low byte of the counter
   Count = inb(0x40); 

   // Compute 16-bit count value
   return  Count | (ushort) (inb(0x40) << 8); 
}

static ushort TimeIt(ushort LoopCount)
{
   ushort InitCount, FinalCount;
union REGS wordType;
   // Read initial counter value
   InitCount = ReadCounter(); 

#ifdef PROC_32
   // ECX is used in loop instruction in 32-bit protected mode!
   _ECX = 0; 
#endif 

   wordType.x.cx = LoopCount;

t1:
   ASM loop t1


   // Read current value of the counter
   FinalCount = ReadCounter(); 

   // Return difference
   return (InitCount - FinalCount);
}

static uchar EnterPassthru(void)
{
   uchar i = 0;
   Passthru = FALSE;
   while (!Passthru && (i++ < 3))
   {
      TogglePassthru();
      Passthru = !DS1481Present();
   }
   return TRUE; 
}

static uchar ExitPassthru(void)
{
   uchar i = 0;

   Passthru = TRUE; 
   while (Passthru && (i++ < 3))
   {
      TogglePassthru();
      Passthru = !DS1481Present();
   }
   return !Passthru;
}
static void TogglePassthru(void)
{
   uchar i;

   for (i = 0; i < 4; i++)
      ToggleOverdrive();

   SpinMSec(20);
}

