Attribute VB_Name = "SKEYMOD"
' ************************************************************************* '
' SKEYMOD.BAS                                                               '
' DS Software Authorization SDK 4.3                                         '
' Disk 3 - 16-bit Visual Basic Examples                                     '
' 02/13/98                                                                  '
'                                                                           '
' Copyright (C) 1996 Dallas Semiconductor Corporation.                      '
' All rights Reserved. Printed in U.S.A.                                    '
' This software is protected by copyright laws of                           '
' the United States and of foreign countries.                               '
' This material may also be protected by patent laws of the United States   '
' and of foreign countries.                                                 '
' This software is furnished under a license agreement and/or a             '
' nondisclosure agreement and may only be used or copied in accordance      '
' with the terms of those agreements.                                       '
' The mere transfer of this software does not imply any licenses            '
' of trade secrets, proprietary technology, copyrights, patents,            '
' trademarks, maskwork rights, or any other form of intellectual            '
' property whatsoever. Dallas Semiconductor retains all ownership rights.   '
'                                                                           '
' Additional Notes:                                                         '
'                                                                           '
'    This software is intended for use with DS1410D and DS1410E and later   '
'    model parallel port adapters only.                                     '
'                                                                           '
' ************************************************************************* '

'// function declarations from SKEY.DLL
Declare Function GetKList% Lib "SKEY.DLL" (ByVal Buf$)
Declare Function ReadScratch% Lib "SKEY.DLL" (ByVal Num%, ByVal Buf$)
Declare Function ReadSubkey% Lib "SKEY.DLL" (ByVal Num%, ByVal Sbk%, ByVal Ps$, ByVal Id$, ByVal Buf$)
Declare Function SetPassID% Lib "SKEY.DLL" (ByVal Num%, ByVal Sbk%, ByVal Id$, ByVal Ps$)
Declare Function WriteScratch% Lib "SKEY.DLL" (ByVal Num%, ByVal Buf$)
Declare Function WriteSubkey% Lib "SKEY.DLL" (ByVal Num%, ByVal Sbk%, ByVal Ps$, ByVal Buf$)
Declare Function SmartPortSearch% Lib "SKEY.DLL" ()

Global PortNum As Integer
Global DeviceNum As Integer
Global SbkNum As Integer

Sub main()
    '// set intro values
    DeviceNum = -1
    SetEnable 1, True

    SKey.Top = (Screen.Height - SKey.Height) / 2
    SKey.Left = (Screen.Width - SKey.Width) / 2
    SKey.Show
End Sub

Sub ReadAll()
    Dim Buf As String * 200
    Dim Ps As String * 20
    Dim Id As String * 20
    Dim i As Integer
    Dim T As Integer

    '// attempt to read all fields of DeviceNum
    If (SKey.ScratchTxt.ForeColor <> &H0&) Then
        SKey.ScratchTxt.ForeColor = &H0&
    End If
    If (ReadScratch(DeviceNum, Buf) = 1) Then
        SKey.ScratchTxt.Text = Left$(Buf, 64)
    Else
        SKey.ScratchTxt.Text = ""
    End If
        
    For i = 0 To 2
        Ps = SKey.PasswordTxt(i).Text
        T = ReadSubkey(DeviceNum, i, Ps, Id, Buf)
        If (SKey.SKText(i).ForeColor <> &H0&) Then
            SKey.SKText(i).ForeColor = &H0&
        End If
        If (T = 1) Then
            SKey.SKText(i).Text = Left$(Buf, 48)
            SKey.IDLab(i).Caption = Left$(Id, 8)
        ElseIf (T = -1) Then
            SKey.SKText(i).Text = "..............................................."
            SKey.IDLab(i).Caption = Left$(Id, 8)
        Else
            SKey.IDLab(i).Caption = ""
            SKey.SKText(i).Text = ""
        End If
    Next i
    Beep
End Sub

Sub SetEnable(Num As Integer, ST As Integer)
    Dim i As Integer

    If (Num = 1) Then
        If (SKey.DeviceFrm.Enabled <> ST) Then
            SKey.ComRom.Enabled = ST
            SKey.SearchButton.Enabled = ST
            SKey.DeviceFrm.Enabled = ST
        End If
        '// remove items in list
        While (SKey.ComRom.ListCount > 0)
            SKey.ComRom.RemoveItem 0
        Wend
    ElseIf (Num = 2 And SKey.ScratchFrm.Enabled <> ST) Then
        If (ST = False) Then
            '// remove all of the strings
            SKey.ScratchTxt.Text = ""
            For i = 0 To 2
                SKey.IDLab(i).Caption = ""
                SKey.PasswordTxt(i).Text = ""
                SKey.SKText(i).Text = ""
            Next i
        End If
        SKey.ScratchFrm.Enabled = ST
        SKey.ScratchTxt.Enabled = ST
        SKey.SCRReadButton.Enabled = ST
        SKey.SCRWriteButton.Enabled = ST
        SKey.SKeyFrm.Enabled = ST
        For i = 0 To 2
            SKey.Dmmy(i).Enabled = ST
            SKey.Dmy(i).Enabled = ST
            SKey.IDLab(i).Enabled = ST
            SKey.PasswordTxt(i).Enabled = ST
            SKey.ChangeButton(i).Enabled = ST
            SKey.SKText(i).Enabled = ST
            SKey.ReadSkButton(i).Enabled = ST
            SKey.WriteSkButton(i).Enabled = ST
        Next i
    End If
End Sub

