Attribute VB_Name = "SECAP1"
Option Explicit
'//--------------------------------------------------------------------------
'// Copyright (C) 1992,1993,1994,1995 Dallas Semiconductor Corporation.
'// All rights Reserved. Printed in U.S.A.
'// This software is protected by copyright laws of
'// the United States and of foreign countries.
'// This material may also be protected by patent laws of the United States
'// and of foreign countries.
'// This software is furnished under a license agreement and/or a
'// nondisclosure agreement and may only be used or copied in accordance
'// with the terms of those agreements.
'// The mere transfer of this software does not imply any licenses
'// of trade secrets, proprietary technology, copyrights, patents,
'// trademarks, maskwork rights, or any other form of intellectual
'// property whatsoever. Dallas Semiconductor retains all ownership rights.
'//--------------------------------------------------------------------------
' Version 4.00
'

'// Declare the functions
Declare Function ReadID% Lib "SATLINK.DLL" (ByVal Buf$)
Declare Function ReadData% Lib "SATLINK.DLL" (ByVal Buf$)
Declare Function WriteData% Lib "SATLINK.DLL" (ByVal Buf$, ByVal ln%)
Declare Function TimerSet% Lib "SATLINK.DLL" (ByVal days%)
Declare Function CheckTimer% Lib "SATLINK.DLL" ()
Declare Function ReadTimer% Lib "SATLINK.DLL" (ByVal cl$, ByVal cla$)
Declare Function WriteProtectT% Lib "SATLINK.DLL" ()
Declare Function NextDS1427% Lib "SATLINK.DLL" ()

Sub Main()

    '// start program or end depending on
    '// Software Authorization Check result.
    If (SA_Check()) Then
        Beep
        Secapx.Show
    Else
        Beep
        Beep
        MsgBox "This Program requires a DS1410E with a DS1427 button.  Aborting Program!", 16, "Secure AP"
        End
    End If

End Sub

' SA_Check is a function that attempts to set a time limit
' of 30 days for the DS1410E/DS1427.  This time limit is then write
' protected.  The DS1427 ID is read and its nv ram is written
' and read from.  If all this is successful then SA_Check
' returns TRUE.
'
' This function could be called at the begining
' of a program to see if the time limit has expired.  Since
' the time register is write protected the first time it is
' called, subsequent calling of this function will not effect
' the time limit.
'
' Note that this function may not be sufficient
' Software protection in and of itself.  Other functions should
' be called periodically during the execution of the program
' to verify the key is still there.
'
Function SA_Check() As Integer
    Dim Chk As Integer
    Dim cl As String * 24
    Dim cla As String * 24
    Dim RM As String * 9
    Dim S As String
    Dim Buf As String * 512
    Dim flag As Integer
    
    '// Reset the search on the one-wire bus
    ResetSearch
    
    '// Find the first DS1427/DS1994
    If (NextDS1427() = 1) Then
    End If
    '// assume fail secure check
    Chk = False

    '// attempt to set a time limit of 30 days
    flag = TimerSet(30)
    If (flag = 1 Or CheckTimer() = 1) Then
        '// ok if could set timer of timer already write protected
        If (WriteProtectT() = 1) Then
            '// ok if could write protect or already write protected
            If (ReadTimer(cl, cla) = 1) Then
                '// ok could read the timers
                If (ReadID(RM) = 1) Then
                    '// ok could read ID
                    S = "Acme " + cl + "  " + cla + "  " + RM
                    flag = Len(S)
                    If (WriteData(S, flag) = 1) Then
                        '// ok could write to data space
                        flag = ReadData(Buf)
                        If (flag = Len(S) And S = Left$(Buf, flag)) Then
                            '// ok could read back data
                            Chk = True  '// so it is secure
                        End If
                    End If
                End If
            End If
        End If
    End If
    
    '// return the result of the check
    SA_Check = Chk

End Function
Private Sub ResetSearch()
    While (NextDS1427() = 1)
    Wend
End Sub
