/*  Project proj
    
	 Copyright  1994. All Rights Reserved.

    SUBSYSTEM:    proj.exe Application
	 FILE:         prjtdlgc.cpp
    AUTHOR:       


    OVERVIEW
    ========
    Source file for implementation of projTDLGClient (TDialog).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "sacwd400.h"
#include "projapp.h"
#include "prjtdlgc.h"
#include <stdio.h>

	// Access system function prototypes
extern "C"	uint far       pascal setup(unsigned char, sa_struct far *);
extern "C"   uint far       pascal next(sa_struct far *);
extern "C"   uint far       pascal first(sa_struct far *);
extern "C"   uint far       pascal saccess(sa_struct far *);
extern "C"   uint far       pascal databyte(unsigned char, sa_struct far *);
extern "C"   uint far       pascal gndtest(sa_struct far *);
extern "C"   uchar far *far pascal romdata(sa_struct far *);
extern "C"   uchar far      pascal keyopen();
extern "C"   void  far      pascal keyclose();
sa_struct gb;
//{{projTDLGClient Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(projTDLGClient, TDialog)
//{{projTDLGClientRSP_TBL_BEGIN}}
    EV_BN_CLICKED(IDOK, BNClicked),
//{{projTDLGClientRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// projTDLGClient
// ==========
// Construction/Destruction handling.
projTDLGClient::projTDLGClient (TDocument& doc, TWindow* parent)
		: TView(doc), TDialog(parent, IDD_CLIENT)
{
	 // INSERT>> Your constructor code here.
	 
	 SetBkgndColor(TColor::LtGray);
	 PRomBox = new TListBox(this, ROM_LISTBOX);
}


projTDLGClient::~projTDLGClient ()
{
    // INSERT>> Your destructor code here.

}


bool projTDLGClient::CanClose ()
{
    return TWindow::CanClose() && Doc->CanClose();
}

void projTDLGClient::BNClicked ()
{
    // INSERT>> Your code here.
	uchar pn = 1;
	char  RomStr[17], TempStr[100];
	uint roundNum = 0, Rounds = 1;
	uint numButtons = 0, k;
	uchar far *ROM;
	

	// Found zero buttons so far
	PRomBox->ClearList();
	
	if(pn > 3) pn = 0;
	// Try every port address
	for (k = 0; k < Rounds; k++)
	{
		if(pn > 3) pn = 1;
		while (setup(pn++, &gb))
		{
			keyopen();
			if (gndtest(&gb))
			{
				// See if we can find a button on selected port address
				if (first(&gb))
				{
					do
					{
						strcpy(RomStr, "");
						numButtons++;
						for (int i = 0; i < 8; i++)
						{
							sprintf(TempStr, "%2.2X", *(romdata(&gb) + i));
							strcat(RomStr, TempStr); 
						}

						// Display new button ID
						PRomBox->AddString(RomStr); 
						ROM = romdata(&gb); 
						if(ROM[0] != 0x81 || ROM[0] != 0x01)
						{
							i = saccess(&gb); 
							i = databyte(0x0F,&gb);
							i = databyte(0,&gb); 
							i = databyte(0,&gb);
							
							
							i = databyte(0,&gb);
							i = databyte(0xFF,&gb);
							i = databyte(0xFF,&gb);
										
							i = saccess(&gb);

							i = databyte(0xAA,&gb);
							i = databyte(0xFF,&gb); 
							i = databyte(0xFF,&gb);
							i = databyte(0xFF,&gb);        
						}
					}
					while (next(&gb));  // Find all buttons on this port

					PRomBox->SetSelIndex(0);
				}
				//else
				//   break;
			}
			keyclose();
		}//setup
	}
	sprintf(TempStr, "Buttons = %f", ((float)(numButtons / Rounds)));
	PRomBox->AddString(TempStr);
}

