/*  Project proj
    
	 Copyright  1994. All Rights Reserved.

    SUBSYSTEM:    proj.exe Application
	 FILE:         prjtdlgc.cpp
    AUTHOR:       


    OVERVIEW
    ========
    Source file for implementation of projTDLGClient (TDialog).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "projapp.h"
#include "prjtdlgc.h"
#include <stdio.h>

extern "C"
{ 
   uchar far pascal dowcheck(void); /* Access system functions */
   uchar far pascal keyopen(void);
   uchar far pascal keyclose(void);
   uchar far pascal setup(uchar);
   uchar far pascal next(void);
   uchar far pascal first(void);
   uchar far pascal gndtest(void);
   uchar far pascal databyte(uchar);
   uchar far pascal OverdriveOn(void);
   void  far pascal OverdriveOff(void);
   uchar far * far pascal romdata(void);
}
//{{projTDLGClient Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(projTDLGClient, TDialog)
//{{projTDLGClientRSP_TBL_BEGIN}}
	 EV_BN_CLICKED(IDOK, BNClicked),
//{{projTDLGClientRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// projTDLGClient
// ==========
// Construction/Destruction handling.
projTDLGClient::projTDLGClient (TDocument& doc, TWindow* parent)
		: TView(doc), TDialog(parent, IDD_CLIENT)
{
	 // INSERT>> Your constructor code here.
	 
	 SetBkgndColor(TColor::LtGray);
	 PRomBox = new TListBox(this, ROM_LISTBOX);
}


projTDLGClient::~projTDLGClient ()
{
    // INSERT>> Your destructor code here.

}


bool projTDLGClient::CanClose ()
{
    return TWindow::CanClose() && Doc->CanClose();
}

void projTDLGClient::BNClicked ()
{
    // INSERT>> Your code here.
    uchar pn = 1;
   char  RomStr[17], TempStr[100];
	uint numButtons = 0, k;
	uint roundNum = 0, Rounds = 1;
 
	// Found zero buttons so far
	PRomBox->ClearList();
	
	// Try every port address
	if(pn > 3) pn = 1;
	while (setup(pn++))
	{
		keyopen();
		// See if we can find a button on selected port address
		if (first())
		{
			do
			{
				strcpy(RomStr, "");
				numButtons++;
				for (int i = 0; i < 8; i++)
				{
					sprintf(TempStr, "%2.2X", *(romdata() + i));
					strcat(RomStr, TempStr); 
				}

				// Display new button ID
				PRomBox->AddString(RomStr);            
			}
			while (next());  // Find all buttons on this port

			PRomBox->SetSelIndex(0);
		}
		keyclose();
	}//setup
   sprintf(TempStr, "Buttons = %f", ((float)(numButtons / Rounds)));
	PRomBox->AddString(TempStr);
}

