/*  Project proj
    
    Copyright  1994. All Rights Reserved.

    SUBSYSTEM:    proj.exe Application
    FILE:         projapp.cpp
    AUTHOR:       


    OVERVIEW
    ========
    Source file for implementation of projApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "projapp.h"
#include "prjtdlgc.h"                        // Definition of client class.       


//{{projApp Implementation}}



DEFINE_DOC_TEMPLATE_CLASS(TFileDocument, projTDLGClient, DlgDTPL);
DlgDTPL __dlogClnt("All Files (*.*)", "*.*", 0, "TXT", dtAutoDelete | dtUpdateDir);


//{{DOC_VIEW}}
//{{DOC_VIEW_END}}

//{{DOC_MANAGER}}
//{{DOC_MANAGER_END}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(projApp, TApplication)
//{{projAppRSP_TBL_BEGIN}}
    EV_OWLVIEW(dnCreate, EvNewView),
    EV_OWLVIEW(dnClose,  EvCloseView),
    EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
//{{projAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// projApp
// =====
//
projApp::projApp () : TApplication("Windows 16-bit DLL Example")
{
    SetDocManager(new TDocManager(dmSDI, this));

    // INSERT>> Your constructor code here.
}


projApp::~projApp ()
{
    // INSERT>> Your destructor code here.
}




//////////////////////////////////////////////////////////
// projApp
// =====
// Application intialization.
//
void projApp::InitMainWindow ()
{
    if (nCmdShow != SW_HIDE)
        nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

    SDIDecFrame *frame = new SDIDecFrame(0, GetName(), 0, false, this);

    // Override the default window style for the main window.
	 frame->Attr.Style |= WS_BORDER | WS_CAPTION | WS_CLIPCHILDREN | WS_SYSMENU | WS_THICKFRAME | WS_VISIBLE;
	 frame->Attr.Style &= ~(WS_CHILD | WS_MAXIMIZEBOX | WS_MINIMIZEBOX);

	 frame->Attr.X = 100; frame->Attr.Y = 100; frame->Attr.H = 220; frame->Attr.W = 370;
	 //
	 // Assign ICON w/ this application.
	 //
	 frame->SetIcon(this, IDI_SDIAPPLICATION);
	 SetMainWindow(frame);

}


//////////////////////////////////////////////////////////
// projApp
// =====
// Application instance initialization.
//
void projApp::InitInstance ()
{
    TApplication::InitInstance();
    GetDocManager()->CreateAnyDoc(0, dtNewDoc);
}


//////////////////////////////////////////////////////////
// projApp
// =====
// Response Table handlers:
//
void projApp::EvNewView (TView& view)
{
    GetMainWindow()->SetClientWindow(view.GetWindow());
    if (!view.IsOK())
        GetMainWindow()->SetClientWindow(0);
    else if (view.GetViewMenu())
        GetMainWindow()->MergeMenu(*view.GetViewMenu());
}


void projApp::EvCloseView (TView&)
{
    GetMainWindow()->SetClientWindow(0);
    GetMainWindow()->SetCaption("Windows 16-bit DLL Example");
}


//{{SDIDecFrame Implementation}}


SDIDecFrame::SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, bool trackMenuSelection, TModule *module)
    : TDecoratedFrame(parent, title, clientWnd, trackMenuSelection, module)
{
    // INSERT>> Your constructor code here.

}


SDIDecFrame::~SDIDecFrame ()
{
    // INSERT>> Your destructor code here.

}


//////////////////////////////////////////////////////////
// projApp
// ===========
// Menu Help About proj.exe command
void projApp::CmHelpAbout ()
{
}


int OwlMain (int , char* [])
{
    try {
        projApp    app;
        return app.Run();
    }
    catch (xmsg& x) {
        ::MessageBox(0, x.why().c_str(), "Exception", MB_OK);
    }

    return -1;
}
