
#define STRICT
#include <windows.h>

#include <stdlib.h>
#include <stdio.h>

#include "debug.h"

BOOL EnablePrivileges(VOID);
BOOL GetUserSid(LPCSTR lpszUserName);
BOOL DoOneFileOrDir(LPTSTR lpszFullName);
VOID CleanUp(VOID);

VOID usage(VOID);

PSID  psidUserSID = NULL;

/* Usage: chown user filename */

UINT main(UINT argc, char *argv[])
{
  
	BOOL bRecursive = FALSE;

	if(argc < 3) {
		usage();
		return(1);
	}

	if(argc == 4) {
		if((argv[1][0] == '-') & (argv[1][1] == 'R')) {
			bRecursive = TRUE;
		} else {
			usage();
			return(1);
		}
		argv++;
	}
	/* 
		Now	argv[1] = UserName
			argv[2] = File or Dir Name
	*/
		

	if(!EnablePrivileges()) {
		return(1);
	}

	if(!GetUserSid(argv[1])) {
		return(1);
	}

	if(!DoOneFileOrDir(argv[2])) {
		CleanUp();
		return(1);
	}

	CleanUp();

	return(0);


}


VOID CleanUp(VOID)
{
	if(psidUserSID != NULL)
		free(psidUserSID);

}

VOID usage(VOID)
{
	printf("CHange OWNer 1.0  Written by Felix Enescu <felix.enescu@usa.net>\n\n");
	printf("Usage:\n");
	printf("\tchown user file\n\n");
	//printf("If '-R' is present chown will recurse directories.\n\n");
	printf("To use this program you need 'Take ownership' and 'Restore files' rights.\n");
}