#define STRICT
#include <windows.h>

#include <stdio.h>

#include "debug.h"
#include "consts.h"


/* Almost verbatim copy from SIDCLEAN.C (MSVC 4.0 sample) */

BOOL SetOwner(PSECURITY_DESCRIPTOR psdFileSD, LPTSTR  lpszFullName);

extern PSID  psidUserSID;

BOOL GetFullFileOrDirName(LPTSTR lpszFileName)
{
	UCHAR	ucPathBuf[SZ_NAME_BUF];
	DWORD	dwSzReturned;
	LPTSTR	lpszLastNamePart;
	LPTSTR	lpszFullName;

	dwSzReturned = GetFullPathName(lpszFileName,
				(DWORD)SZ_NAME_BUF,
				(LPTSTR)&ucPathBuf,
				(LPTSTR *)&lpszLastNamePart);

	if (0 == dwSzReturned)
		switch (GetLastError()) {
			case ERROR_INVALID_NAME:
				printf("\nError invalid file full-name (on GetFullPathName)");
				return(FALSE);
			default:
				PERR("GetFullPathName - unexpected return code");
				return(FALSE);
		}

	if (dwSzReturned > SZ_NAME_BUF) {
		PERR("GetFullPathName - buffer too small");
		return(FALSE);
	}

	lpszFullName = CharLower((LPTSTR)&ucPathBuf);

	if (!lpszFullName) {
		PERR("CharLower failure");
		return(FALSE);
	}

	return(TRUE);

}


BOOL DoOneFileOrDir(LPTSTR lpszFullName)
{

  UCHAR                ucBuf             [SZ_REL_SD_BUF];
  UCHAR                ucBufAbs          [SZ_ABS_SD_BUF];
  UCHAR                ucBufCtrl         [sizeof(PSECURITY_DESCRIPTOR_CONTROL)];
  UCHAR                ucBufSidOwn       [SZ_SID_OWN_BUF];
  DWORD                dwSDLength       = SZ_REL_SD_BUF;
  DWORD                dwSidOwnLength   = SZ_SID_OWN_BUF;
  DWORD                dwSDLengthNeeded;
  PSECURITY_DESCRIPTOR psdSrelFileSD    = (PSECURITY_DESCRIPTOR)&ucBuf;
  PSECURITY_DESCRIPTOR psdAbsFileSD     = (PSECURITY_DESCRIPTOR)&ucBufAbs;
  PSECURITY_DESCRIPTOR_CONTROL psdcCtrl = (PSECURITY_DESCRIPTOR_CONTROL)&ucBufCtrl;
  PSID                 psidSidOwn       = (PSID)&ucBufSidOwn;
  BOOL                 bSDSelfRelative;
  DWORD                dwRevision;

	if (!GetFullFileOrDirName(lpszFullName))
		return(FALSE);

  /**************************************************************************\
  *
  * Now the input argument's name is accurate:  it is expanded and lower-case
  *
  \**************************************************************************/

//	printf("\nChecking %s",lpszFullName);

  
	if (!GetFileSecurity(lpszFullName,
		(SECURITY_INFORMATION)( OWNER_SECURITY_INFORMATION),
		psdSrelFileSD,
		dwSDLength,
		(LPDWORD)&dwSDLengthNeeded)) {
		
		PERR("GetFileSecurity");
		return(FALSE);
	}


  /**************************************************************************\
  *
  *  Build File SD in absolute format for potential later modification
  *
  *  First Initialize a new SD, which is by definition in absolute format
  *
  *  Then Set in the fields from the relative format SD we just fetched
  *
  \**************************************************************************/

	if (!InitializeSecurityDescriptor(psdAbsFileSD,
			SECURITY_DESCRIPTOR_REVISION)) {

		PERR("InitializeSecurityDescriptor");
		return FALSE;
	}

  /**************************************************************************\
  *
  * Get Control from relative format File SD
  *
  * This control info isn't much queried in the code that follows, as the
  *   Get/Set calls are more convienent in this case, but it does give us a
  *   change to verify that the SD is in relative format
  *
  \**************************************************************************/

	if (!GetSecurityDescriptorControl(psdSrelFileSD,
			psdcCtrl,
			&dwRevision)) {

		PERR("GetSecurityDescriptorControl");
		return FALSE;
	}

	bSDSelfRelative = (SE_SELF_RELATIVE & *psdcCtrl);


  /**************************************************************************\
  *
  * This validity check is here for demonstration pruposes.  It's not likely a
  *   real app would need to check the validity of the SD after it was just
  *   built into absolute format.  The validity check APIs are more intended
  *   to check validity after app code has manipulated the structure and is
  *   about to hand it back to the system
  *
  * One thing to notice is that IsValidSecurityDescriptor will succeed on both
  *   self-relative and absolute format SDs.  However, some other api's, such
  *   as SetSecurityDescriptorOwner, require the SD to be in a certain format,
  *   and will give a return code of Invalid SD if the SD passed to the api is
  *   valid, but in the wrong format.  In other words, when an api such as
  *   SetSecurityDescriptorOwner gives the retun code Invalid SD, this doesn't
  *   mean the SD passed in was necessarily invalid.  It might have been in
  *   the wrong format
  *
  \**************************************************************************/

	if (!IsValidSecurityDescriptor(psdAbsFileSD)) {
		PERR("IsValidSecurityDescriptor said bad SD");
		return(FALSE);
	}


	if (!SetOwner(psdAbsFileSD,lpszFullName))
		return(FALSE);

	return(TRUE);
}


/* Here is the magic ... */
BOOL SetOwner(PSECURITY_DESCRIPTOR psdFileSD, LPTSTR  lpszFullName)
{

        /********************************************************************\
        *
        * Modify the SD in virtual memory.  No check on the new owning SID
        *   here, because we validity checked it when we fetched it in
        *   GetProcessSid
        *
        \********************************************************************/

	if (!SetSecurityDescriptorOwner(psdFileSD,
			psidUserSID,
			FALSE)) {             // New owner explicitly specified

		PERR("SetSecurityDescriptorOwner");
		return(FALSE);
	}

        /********************************************************************\
        *
        *  This validity check is something a real app might actually like to
        *    do.  We manupulated the SD, so before we write it back out to the
        *    file system, a check is worth considering.
        *
        \********************************************************************/

	if (!IsValidSecurityDescriptor(psdFileSD)) {
		PERR("IsValidSecurityDescriptor said bad SD");
		return(FALSE);
	}

        /********************************************************************\
        *
        * Modify the SD on the hard disk
        *
        \********************************************************************/

	if (!SetFileSecurity(lpszFullName,
		(SECURITY_INFORMATION)(OWNER_SECURITY_INFORMATION),
		psdFileSD)) {
		
		PERR("SetFileSecurity");
		return(FALSE);
	}

	return(TRUE);
}