#define STRICT
#include <windows.h>
#include <stdio.h>

#include "debug.h"

BOOL EnablePrivileges(VOID)
{

	HANDLE			hProcess;
	HANDLE			hAccessToken;
	LUID			luidPrivilegeLUID;
	TOKEN_PRIVILEGES	tpTokenPrivilege;


	hProcess = GetCurrentProcess();
	if (!hProcess){
		PERR("GetCurrentProcess");
		return(FALSE);
	}

	if (!OpenProcessToken(hProcess,
		TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY,
		&hAccessToken)){

		PERR("OpenProcessToken");
		return(FALSE);
	}
	
	if (!LookupPrivilegeValue(NULL,
		"SeTakeOwnershipPrivilege",
		&luidPrivilegeLUID)){

		PERR("LookupPrivilegeValue");
		return(FALSE);
	}
	
	tpTokenPrivilege.PrivilegeCount = 1;
	tpTokenPrivilege.Privileges[0].Luid = luidPrivilegeLUID;
	tpTokenPrivilege.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;

	AdjustTokenPrivileges (hAccessToken,
		FALSE,  // Do not disable all
		&tpTokenPrivilege,
		sizeof(TOKEN_PRIVILEGES),
		NULL,   // Ignore previous info
		NULL);  // Ignore previous info

	if ( GetLastError() != NO_ERROR ){
		//PERR("AdjustTokenPrivileges");
		printf("\nYou need to use User Manager (menu item");
		printf("\n  Policies\\UserRights) turn on the 'Take ownership of...' ");
		printf("\n  privilege, log off, log back on.");
		return(FALSE);
	}

	if (!LookupPrivilegeValue(NULL,
		"SeRestorePrivilege",
		&luidPrivilegeLUID)){
		
		PERR("LookupPrivilegeValue");
		return(FALSE);
	}

	tpTokenPrivilege.PrivilegeCount = 1;
	tpTokenPrivilege.Privileges[0].Luid = luidPrivilegeLUID;
	tpTokenPrivilege.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;

	AdjustTokenPrivileges (hAccessToken,
		FALSE,  // Do not disable all
		&tpTokenPrivilege,
		sizeof(TOKEN_PRIVILEGES),
		NULL,   // Ignore previous info
		NULL);  // Ignore previous info

	if ( GetLastError() != NO_ERROR ){
		//PERR("AdjustTokenPrivileges");
		printf("\nYou need to use User Manager (menu item");
		printf("\n  Policies\\UserRights) turn on the 'Restore files ...' ");
		printf("\n  privilege, log off, log back on.");
		return(FALSE);
	}

	return(TRUE);
	
}
