
#define STRICT
#include <windows.h>

#include <stdio.h>

#include "debug.h"
#include "consts.h"

extern PSID  psidUserSID;

BOOL GetUserSid(LPCSTR lpszUserName)
{

	UCHAR		ucSIDBuf[SZ_SID_BUF];
	PSID		psdUserSIDTemp=(PSID)&ucSIDBuf;
	DWORD		dwSIDLengthNeeded = sizeof(ucSIDBuf);

	SID_NAME_USE	peAcctNameUse;

	UCHAR		ucDomainBuf[SZ_NAME_BUF];
	LPTSTR		lpszDomainName = (LPTSTR)&ucDomainBuf;
	DWORD		dwDNLengthNeeded = sizeof(ucDomainBuf);

	DWORD		dwLastError;

	if(!LookupAccountName(
		NULL,				//LPCTSTR  lpSystemName,	// address of string for system name
		lpszUserName,			//LPCTSTR  lpAccountName,	// address of string for account name
		psdUserSIDTemp,			//PSID  Sid,	// address of security identifier
		(LPDWORD)&dwSIDLengthNeeded,	//LPDWORD cbSid,	// address of size of security identifier
		lpszDomainName,			//LPTSTR  ReferencedDomainName,	// address of string for referenced domain 
		(LPDWORD)&dwDNLengthNeeded,	//LPDWORD  cbReferencedDomainName,	// address of size of domain string
		&peAcctNameUse			//PSID_NAME_USE  peUse 	// address of SID-type indicator
		) ){

		dwLastError = GetLastError();
		if (ERROR_INSUFFICIENT_BUFFER == dwLastError) {
			printf("Insufficient buffer.\n");
			return(FALSE);
		} else if (ERROR_NONE_MAPPED == dwLastError) {
			printf("User not found (%s).\n", lpszUserName);
			return(FALSE);
		} else {
			PERR("LookupAccountName");
			return(FALSE);
		}
	}

	dwSIDLengthNeeded = GetLengthSid(psdUserSIDTemp);

	psidUserSID = malloc(dwSIDLengthNeeded);

	if (NULL == psidUserSID)
		PERR("GetUserSid - ran out of heap space");

	if (!CopySid(dwSIDLengthNeeded,
		psidUserSID,
		psdUserSIDTemp)) {
	
		PERR("CopySid");

		free(psidUserSID);
		psidUserSID=NULL;

		return(FALSE);
	}


	return(TRUE);

}
