.486
locals
jumps
.model flat,STDCALL

UNICODE=0
include w32.inc
include imghdr.inc
include writeerr.inc

 lp                            EQU  OFFSET
 ID_PATCH		       EQU    1
 IDTEST                        EQU    2
 ID_BROWSE		       EQU    3
 IDC_FILENAME                  EQU    1001
 IDC_OFF                       EQU    1002
 ID_LIST                       EQU    1003
 IDC_NOPAT		       EQU    1005
 IDI_ICON1                     EQU    101
 IDR_MENU1                     EQU    102
 ID_DIALOG1                    EQU    103
; ID_NOPAT		       EQU    104
 ID_EXIT                       EQU    40001
 ID_ABOUT                      EQU    40002
 IDC_STATIC                    EQU    -1

 ListBoxSize		       EQU 6





.data
;WorkHorseData
Patched		dd 600h			; File Offset Address
size		dd 3			; Size Of patch [3:=min align to dword boundry]
FileAttr	dd 0
hExeFile	dd 0
FileOpened	dd FALSE		; BOOL - is file opened?
MapOfFile	dd FALSE		; BOOL - Is file MemMapped?
FileSize	dd 0 
FMObjectName	db "2nd&mi",0	; Name of memory object + personal tag.
hFMObject	dd 0 
lpMapOfFile	dd 0 
lpObjTbl	dd 0
DispPatched	dd 0
disppage	dd 0
page		dd 0
;.... rest of stuff

newhwnd          dd 0
lppaint          PAINTSTRUCT <?>
align 4		 ; dword alignment makes for speed
msg              MSG   <?>
wc               WNDCLASSEX  <?>
OFN		 OPENFILENAME <?>


hInst            dd 0
hMenu            dd 0
hDlg             dd 0
hList		 dd 0			; Handle of list (status) box
hFileName	 dd 0			; Handle of FileName (editbox) box

szTitleName      db "Stone's Reloc Patcher",0
szClassName      db 'SKOD',0
szMenuName       db 'MENU',0       
szFileOff	 db 6 dup (0)		; Carries string of typed patched offset
szPathName	 db MAX_PATH dup (0)
Filter 		db "Executable Files (*.exe, *.dll)",0,"*.exe;*.dll",0,"All Files",0,"*.*",0,0


;Messages 
szAboutCaption     db "About Stone's Reloc-Patcher",0
szAboutText	   db 10,13
		   db "Stone's Reloc Patcher 1.01",10,13
		   db "Written by Stone 1998",0
szUnableToOpen     db "Unable to Open File",0
szUnableToMapFile  db "Unable to Map File",0
szUnableToViewFile db "Unable To create MapView of file",0
szNotAValidPE	   db "File is not a valid PE-file",0
szNoRelocTable	   db "No reloc table in file",0
szNoRelocsOnPage   db "No relocs on the entire page",0
szNoRelocHere      db "The Queried address contains no reloc-items",0
szRelocFound	   db "The Queried Address is touched by a reloc item",0
szFileOffRequired  db "A File offset is REQUIRED input!!",0
szNoBytesToPatch   db "A number of bytes is REQUIRED input!!",0


.code
start:

        call    GetModuleHandle,0         ; get hmod (in eax)
        mov     [hInst], eax            ; hInstance is same as HMODULE


	mov	[wc.wc_cbSize], WNDCLASSEX_
        mov     [wc.wc_style], CS_HREDRAW + CS_VREDRAW 
        mov     [wc.wc_lpfnWndProc], offset Ab_DlgProc
        mov     [wc.wc_cbClsExtra], 0
        mov     [wc.wc_cbWndExtra], DLGWINDOWEXTRA

        mov     eax, [hInst]
        mov     [wc.wc_hInstance], eax

        call    LoadIcon,[hInst], IDI_ICON1

        mov     [wc.wc_hIcon], eax
	mov	[wc.wc_hIconSm], eax	

        call    LoadCursor,0, IDC_ARROW
        mov     [wc.wc_hCursor], eax

        mov     [wc.wc_hbrBackground], COLOR_BACKGROUND
        mov     dword ptr [wc.wc_lpszMenuName], IDR_MENU1 ;offset szMenuName
        mov     dword ptr [wc.wc_lpszClassName], offset szClassName

        call    RegisterClassEx, offset wc


	call	CreateDialogParam, [hInst], ID_DIALOG1, 0, offset Ab_DlgProc,0
        mov     [newhwnd], eax

	call	GetDlgItem, [newhwnd], ID_LIST
	mov	[hList], eax
	call	GetDlgItem, [newhwnd], IDC_FILENAME
	mov	[hFileName],eax


	call	SendMessage, [hList], LB_RESETCONTENT,0,0
	

        call    ShowWindow, [newhwnd], SW_SHOWNORMAL

        call    UpdateWindow, [newhwnd]

msg_loop:
        call    GetMessage, offset msg, 0, 0, 0

        cmp     ax, 0
        je      end_loop

        call    TranslateMessage, offset msg

        call    DispatchMessage, offset msg

        jmp     msg_loop

end_loop:
        push    [msg.ms_wParam]
        call    ExitProcess             



Ab_DlgProc proc hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

        push    ebx
        push    esi
        push    edi

        cmp     [wmsg],WM_COMMAND
        je      ab_command
        cmp     [wmsg], WM_CLOSE
        je      ab_dlgdestroy
        mov     eax,FALSE
ab_finish:
        pop     edi
        pop     esi
        pop     ebx
        ret
ab_command:
	
;@@NotIDD_OK:
	cmp	[wparam], ID_ABOUT
	jne	@@NotID_ABOUT
	CALL	MessageBoxA, [newhwnd], lp szAboutText, lp szAboutCaption, 0
	jmp	ab_finish

@@NotID_ABOUT:
	cmp	[wparam], ID_EXIT
	je	ab_dlgdestroy		; exit



	cmp	[wparam], ID_BROWSE
	jnz	@@NotID_BROWSE

	push	eax
	call	Browse
	pop	eax
	jmp	ab_finish
	
@@NotID_BROWSE:
	cmp	[wparam], ID_PATCH
	jnz	@@NotID_PATCH
	call	WorkHorse, 0
	jmp	ab_finish

@@NotID_PATCH:
	cmp	[wparam], IDTEST
	jnz	@@NotID_TEST

	call	WorkHorse, TRUE			; Is just a test!!
	jmp	ab_finish

@@NotID_TEST:


	jmp	ab_finish



ab_dlgdestroy:
        call    EndDialog, [hwnd], 0       ;Close dialog
        call    PostQuitMessage, NULL 

        mov     eax,TRUE        
        jmp     ab_finish
ab_nothing:
        mov     eax,FALSE
        jmp     ab_finish

Ab_DlgProc    endp
public Ab_DlgProc


AddString	PROC	StringToAdd: DWORD
	push 	eax
	call	SendMessage, hList, LB_ADDSTRING, 0, StringToAdd
	call	SendMessage, hList, LB_GETCOUNT, 0, 0
	sub	eax, ListBoxSize
	call	SendMessage, hList, LB_SETTOPINDEX, eax, 0
	pop 	eax
	ret
AddString	ENDP

Browse	proc	

	push	eax
; Fill OPENFILENAME Structure (OFN)
	mov	[OFN.on_lStructSize], OPENFILENAME_
	mov	eax, DWORD PTR [newhwnd]
	mov	[OFN.on_hwndOwner], eax
	mov    	eax, [hInst]
	mov	[OFN.on_hInstance], eax
	mov	[OFN.on_lpstrFilter], OFFSET Filter
	mov 	[OFN.on_lpstrFile], OFFSET szPathName
	mov	[OFN.on_nMaxFile], MAX_PATH-1
	mov 	[OFN.on_Flags], OFN_PATHMUSTEXIST+OFN_FILEMUSTEXIST + OFN_HIDEREADONLY
	call    GetOpenFileName, offset OFN
	cmp	eax, TRUE
	JNZ	@@EndBrowse
; Change EditBox text 
	call	SetWindowText, hFileName, offset szPathName
; Change Status Windows Text
;	call	SetStatusText, offset Msg8

@@EndBrowse:
	pop	eax	
	ret

Browse	ENDP

WorkHorse Proc  IsTest:BOOL
	;int 3
	call	GetDlgItemHex, [newhwnd], IDC_OFF
	test	eax,eax
	jnz	@@FileOffOk
	call    AddString, lp szFileOffRequired
	jmp	Exit

@@FileOffOk:
	mov	[Patched], eax

	call	GetDlgItemHex, [newhwnd], IDC_NOPAT
	test	eax,eax
	jnz	@@BytesToPatch
	call	AddString, lp szNoBytesToPatch	
	jmp	Exit

@@BytesToPatch:
	add	eax, 3
	mov	[size], eax

	call	GetWindowText, [hFileName], lp szPathName, MAX_PATH
	call 	CreateFile, offset szPathName, GENERIC_READ + GENERIC_WRITE, \
			    FILE_SHARE_READ + FILE_SHARE_WRITE, 0, 3, \
			    offset FileAttr, 0
	cmp	eax, -1
	jnz	@@Opened
	
	Call	AddString, lp szUnableToOpen
	Call	WriteErrorCode
	call	AddString, eax
	jmp	Exit

@@Opened:
	mov	[hExeFile], eax
	mov	[FileOpened], TRUE
	
@GetFileSize:  
	call	GetFileSize, dword ptr [hExeFile], 0
	mov 	[FileSize], eax
	call	CreateFileMappingA, hExeFile, NULL, PAGE_READWRITE, 0, eax, offset FMObjectName
	test	eax,eax
	jnz	@@MapViewOfFile

	 call AddString, lp szUnableToMapFile
	; call WriteErrorCode
	call CloseHandle, hExeFile
	jmp	Exit
	
@@MapViewOfFile:
	mov	[hFMObject], eax
	mov	[MapOfFile], TRUE

	call	MapViewOfFile, dword ptr [hFMObject], FILE_MAP_WRITE + FILE_MAP_READ, 0, 0, 0
	test	eax,eax
	jnz	@@Mapped
	call	AddString, lp szUnableToViewFile
	jmp	Exit
	;call	WriteErrorCode
	;Call	Terminate

@@Mapped:
	mov	[lpMapOfFile], eax

	add 	eax, 03ch	; eax ->lpPEHeader
	mov	ebx, [eax]	; eax -> PE-signature
	add	ebx, [lpMapOfFile]
	call	IsBadReadPtr, ebx, 100h
	test	eax,eax
	jnz	@@NotPE


	cmp	dword ptr [ebx], IMAGE_NT_SIGNATURE	; PE
	JZ	@IsPe
@@NotPE:
	Call	AddString, lp szNotAValidPE
	jmp	Exit
	; Call	Terminate

@IsPe:
	movzx	eax, [ebx.SizeOfOptionalHeader]
	add	eax, ebx
	add	eax, 24				; PE-header=24 => eax ->first object

	mov	[lpObjTbl], eax			; Objecttable located here

	movzx	edx, word ptr [ebx.NumberOfSections]
	call	Phys2RVA, eax, edx, dword ptr [Patched]
	test	eax,eax
	jnz	@@Phys2RVAOK
	;Call	WriteLn, lp szErrorDealingWith
	;Call	Terminate

@@Phys2RVAOK:
	push	eax
	and	eax, 0fffff000h
	mov	[page],eax
	pop	eax
	and	eax, 0fffh
	mov	[disppage], eax

	mov	edx, [ebx+160]			; RVA of reloc
	movzx	ecx, word ptr [ebx.NumberOfSections]
	call	RVA2Phys, dword ptr [lpObjTbl], ecx, edx
	test	eax,eax
	jnz	@@NoRelocTable
	;call	AddString, lp szNoRelocTable
	jmp	Exit

@@NoRelocTable:

	add	eax, [lpMapOfFile]		; eax -> relocations.

	call	FindRelocForPage, eax, dword ptr [page]
	test	eax,eax
	jnz	@@RelocsForPage

; No reloctions found for the page of the patch.
	call	AddString, lp szNoRelocsOnPage
	jmp	Exit	

@@RelocsForPage:

	call	TraverseRelocForDisp,eax, dword ptr [disppage], [size]
	test	eax,eax
	jnz	@@RelocItemHere

	; A reloc Item was found.. 
	call	AddString, lp szNoRelocHere
	jmp	Exit

@@RelocItemHere:

	call	AddString, lp szRelocFound
	cmp	[IsTest], TRUE
	jz	Exit

@@Patch:
	mov	bx, word ptr [eax]
	and	ebx, 08fffh
	mov	word ptr [eax], bx

Exit:
	cmp	[MapOfFile], TRUE
	jz	@@NoMapOfFile
	call	FlushViewOfFile, lpMapOfFile, 0
	;call   UnMapViewOfFile, lpMapOfFile
	call	CloseHandle, [hFMObject]
@@NoMapOfFile:
	cmp	[FileOpened], TRUE
	jnz 	@@FileNotOpen

@@FileNotOpen:
	call	CloseHandle, [hExeFile]

	RET
WorkHorse EndP


TraverseRelocForDisp PROC
arg	RelocPage:LPVOID, ToFIND:DWORD, Boundry:DWORD

	mov	eax, RelocPage
	mov	edx, ToFIND			; lower boundry
	mov	ecx, [eax+4]			; ecx=
	add	ecx, eax			; ecx -> nextpage

	mov	edi,  eax			; edi= variable for loop
	add	edi, 8

	mov	eax, [size]

	mov	eax, edx
	add	eax, Boundry	
	sub	eax, 4


@@NextRelocItem:
	mov	bx, word ptr [edi]

	push	ebx			; Not A type 3 fixup!
	and	ebx, 3000h
	cmp	ebx, 3000h
	jnz	@@NotRight
	pop	ebx

	and	ebx, 8fffh
	cmp	ebx, eax
	jg	@@NotRight
	add	ebx, Boundry
	cmp	ebx, edx
	jle	@@NotRight

	mov	eax, edi
	jmp	@@Found

@@NotRight:
	add	edi, 2
	cmp	edi, ecx
	jle	@@NextRelocItem	
	xor	eax,eax

@@Found:
	ret
TraverseRelocForDisp ENDP


FindRelocForPage PROC
arg	RelocTbl:LPVOID, ToFIND:DWORD
	mov 	eax, RelocTbl
	mov	edx, ToFIND
	xor	ecx,ecx
@@NextPage:
	cmp	ecx, [eax]		; End of relocation table?
	jz	@@NotFound
	cmp	edx, [eax]		; Our page?
	jz	@@Found

	add	eax, [eax+4]		; Next Page
	jmp 	@@NextPage

@@NotFound:
	xor	eax, eax
@@Found:
	ret
FindRelocForPage ENDP

RVA2Phys Proc
arg	ObjTbl:LPVOID, NumOfSec:DWORD,ToFIND:LPVOID

	mov	eax,ObjTbl
	mov	ecx, NumOfSec

@@NextSection:
	mov	edx, [eax.SVirtualAddress]
	cmp	ToFIND, edx
	jl	@@NotThisObject
	add	edx, [eax.SVirtualSize]
	cmp	ToFIND, edx
	jge	@@NotThisObject
	
	mov	edx, ToFIND
	sub 	edx, [eax.SVirtualAddress]
	add	edx, [eax.PointerToRawData]
	xchg	eax, edx
	jmp	@@Done

@@NotThisObject:
	add	eax, 40
	dec 	ecx
	jnz	@@NextSection
	xor	eax,eax
	
@@Done:

	ret
RVA2Phys ENDP

Phys2RVA	PROC   	
arg	ObjTbl:LPVOID, NumOfSec:DWORD,ToFIND:LPVOID

	mov	eax, ObjTbl
	mov	ecx, NumOfSec
	mov	edx,  ToFIND
	mov	[Patched], edx


@@NextSection:
	mov	edx, [eax.PointerToRawData]
	cmp	edx, [Patched]
	jg	@NotThisObject
	add	edx, [eax.SizeOfRawData]
	cmp	edx, [Patched]
	jl	@NotThisObject
	
	mov	edx, [Patched]
	sub	edx, [eax.PointerToRawData]
	add	edx, [eax.SVirtualAddress]
	xchg	eax, edx			; EAX = RVA of address in question

	jmp	@ObjectFound

@NotThisObject:
	add	eax, 40			; Size of a object entry
	dec	ecx
	jnz	@@NextSection

	xor 	eax,eax
@ObjectFound:				; Find page in question

	ret


Phys2RVA ENDP

Terminate PROC
arg	ErrorCode:Dword
	cmp	[hExeFile], 0
	jnz	@@NoFileOpen
	call	CloseHandle, dword ptr [hExeFile]
	
@@NoFileOpen:

	call ExitProcess, ErrorCode
	RET
Terminate ENDP


GetDlgItemHex	PROC	hD, ID
	call	GetDlgItemText, hD, ID, offset szFileOff, 10
	call	HexToInt, offset szFileOff, eax
	ret
GetDlgItemHex	ENDP

HexToInt	PROC	StringOffset:DWORD, StrLen:DWORD
	pushf
	push ebx ecx edi esi ebp
	xor	eax, eax
	mov	esi, StringOffset
	mov	eax, StrLen
	test 	eax, eax
	jz	EndHTI
	mov	ecx, eax

	mov EBP, 10			; EBX =	  Upperpart
	cmp	byte ptr [esi], "$"
	jnz	@@NotDecimal
	inc	esi
	mov	ebp, 10h
	dec	ecx

@@NotDecimal:
	xor eax, eax			; init
	xor ebx, ebx 			; init

nextchar:
	xor edx, edx			; EDX=0 - needed ?
	imul ebx, ebx, 10h		; Update upperpart
        mul EBP				; Update lowerpart
 	add ebx, edx			; Add "carry"

	movzx edi, byte ptr [esi]	; fetch char
	cmp edi, 40h
	jl number
	sub edi,7

number:
	add eax, edi			; add next char
	adc ebx, 0				; Adjust if carry
	sub eax, 30h			; subtract "char" value

	inc esi				; next letter
	dec ecx				; oneless letter to go
	jnz nextchar			; was it the last?

	xchg edx, ebx			; output is EDX:EAX
EndHTI:
	pop ebp esi edi ecx ebx 
	popf
	RET
	
HexToInt ENDP

end start






