comment %
	2nd&mi
	stone@one.se

	%	

.386P
LOCALS
JUMPS
.MODEL FLAT, STDCALL			; with STDCALL we must reverse the sequence of pushes 
					; before a APIn call. 

UNICODE = 0				; Needed for w32.inc
INCLUDE W32.inc				; Windows definitions
include wincrypt.inc
include fnal.inc

extrn	CryptAcquireContextA	: PROC
extrn	CryptCreateHash		: PROC
extrn	_wsprintfA		: PROC
extrn	CryptHashData		: PROC
extrn	CryptDeriveKey		: PROC
extrn	CryptEncrypt		: PROC
extrn	CryptDestroyHash	: PROC
extrn	CryptReleaseContext	: PROC
extrn	CryptDestroyKey		: PROC


.DATA
align 4
hProv		dd 0					; Crypto Context handle
hKey		dd 0					; Crypto key handle
hHash		dd 0					; Hash handle
szPassword	db 8 dup (0) 				; buffer for password
szCryptData     db "2nd&mi78"				; random string.
lpBuffer	dd 8					; number of bytes in random string.
szCryptedData   db 098h, 0a3h, 037h, 070h, 0ADh, 01fh,06eh, 06h
;szCryptedData   db 054h, 075h, 0B6h, 0ddh, 060h, 01eh, 01ch, 0efh	; "2nd&mi78" encrypted with password "12345678"


szPathName	db "keyfile.dat",0			; name of keyfile
FileAttr	dd FILE_ATTRIBUTE_NORMAL		; fileattributes
dwNumBytes	dd 0					; number of bytes read.

szWeee		db "Weeeeeeeeeeeee!",0			
szSuccesful 	db "Keyfile.dat is a valid key file",0

.CODE
start:
	int 3

	call	LoadPassword
	test	eax,eax
	jnz	@@CryptPassword
	StnError <"Unable to read keyfile.dat"> <MSG11> <0>
	jmp	@@Exit

@@CryptPassword:
	call	Crypt
	test	eax, eax
	jnz	@@TestPassword
	StnError <"Unable to initiate crypto-api"> <MSG12> <0>
	jmp	@@Exit

@@TestPassword:

	call	Compare, offset szCryptedData, offset szCryptData, 8
	test	eax,eax
	jz	Exit
	Call	MessageBoxA, 0, offset szSuccesful, offset szWeee, 0

@@Exit:
	call	ExitProcess

Compare	Proc	
	arg 	pString1:Dword, pString2:Dword, dwNumbBytes:Dword
	mov	eax, TRUE
	mov	edi, pString1
	mov	esi, pString2
	MOV	ecx, dwNumbBytes
	rep	cmpsb
	jcxz	@@Compares
	MOV	EAX, FALSE
@@Compares:
	Ret
Compare ENDP

LoadPassword	Proc
	call 	CreateFile, offset szPathName, GENERIC_READ + GENERIC_WRITE, \
			    FILE_SHARE_READ + FILE_SHARE_WRITE, 0, 3, \
			    offset FileAttr, 0		; open file
	cmp	eax, -1					; Were we able to?
	jnz	@@Opened
	mov	EAX, FALSE
	jmp	Exit

@@Opened:
	call	ReadFile, eax, offset szPassword, \ ; Load old file into memory
			  8, offset dwNumBytes, 0
	test	eax,eax
	jnz	@@ReadOk
		mov	eax, FALSE
	jmp	Exit
@@ReadOk:
	mov	eax, TRUE
Exit:
	ret
LoadPassword	ENDP

Crypt PROC
	local   IsCryptContext:BOOL, IsCryptHash:BOOL, IsCryptKey:BOOL, \
		ReturnCode:BOOL
		
	xor	eax,eax
	mov	[IsCryptContext], eax
	mov	[IsCryptHash], eax
	mov	[IsCryptKey], eax
	mov	[ReturnCode], eax

	call	CryptAcquireContextA, offset hProv, NULL, NULL, \
				      PROV_RSA_FULL, NULL
	test	eax,eax
	jnz	@@NoError1

	call	CryptAcquireContextA, offset hProv, NULL, NULL, \
				      PROV_RSA_FULL, CRYPT_NEWKEYSET
	test	eax, eax
	jnz	@@NoError1

	call	GetLastError
	StnError <"An error 0x%x ocurred during CryptAcquireContextA"> <Msg1> <eax>
	jmp	@@Exit

@@NoError1:
	mov	[IsCryptContext], TRUE

	call	CryptCreateHash, [hProv], CALG_MD5 , 0, 0, offset hHash	
	test	eax,eax
	jnz	@@NoError2

	call	GetLastError
	StnError <"An error 0x%x ocurred during CryptCreateHash"> <Msg2> <eax>
	jmp	@@Exit

@@NoError2:
	mov	[IsCryptHash], TRUE
	call	CryptHashData, [hHash], offset szPassword, 8, 0
	test	eax, eax
	jnz	@@NoError3

	call	GetLastError
	StnError <"An error 0x%x ocurred during CryptHashData"> <Msg3> <EAX>
	jmp	@@Exit

@@NoError3:
	call	CryptDeriveKey, [hProv], CALG_RC4, [hHash], CRYPT_EXPORTABLE, \
		offset hKey
	test	eax,eax
	jnz	@@NoError4
	
	call	GetLastError
	StnError <"An error 0x%x ocurred during CryptDeriveKey"> <Msg6> <EAX>

@@NoError4:
	mov	[IsCryptKey], TRUE
	call	CryptEncrypt, [hKey], 0, TRUE, 0, offset szCryptData, \
				offset lpBuffer, 8
	
	test	eax,eax
	jnz	@@NoError5
	call	GetLastError
	StnError <"An error 0x%x ocurred during CryptEncrypt"> <Msg4> <EAX>
	jmp	@@Exit
@@NoError5:
	mov	[ReturnCode], TRUE			; it was successfull

@@Exit:
	cmp	[IsCryptHash], TRUE			; did we open a hash?
	jnz	@@NoClose1
	call	CryptDestroyHash, [hHash]		; close hash
@@NoClose1:
	cmp	[IsCryptKey], TRUE			; did we make a key?
	jnz	@@NoClose2
	Call	CryptDestroyKey, [hKey]			; close key
@@NoClose2:
	cmp	[IsCryptContext], TRUE			; did we create a context?
	jnz	@@NoClose3			
	call	CryptReleaseContext, [hProv], 0		; release context

@@NoClose3:
	mov	eax, [ReturnCode]			; return with proper error code
	ret
Crypt ENDP	

ends
end start
	
