; To compile 
; TASM /M stngcd
; TLINK /t stngcd
; I used TASM 5.0 and Tlink that belongs to tasm 3.2 (it requires less memory)
; Btw - email me as stone@one.se
 model tiny
.Code					; Code starts
Org      100h				; COM!

 Start:
.386P
	mov f1ax,ax			; Save all intro registers
	mov f1bx,bx
	mov f1cx,cx
	mov f1dx,dx
	mov f1di,di
	mov f1si,si
	mov f1bp,bp

	mov ah,4ah			; Free Mem Block
	mov bx,200h
	int 21h

	mov ah,48h			; Allocate memory
	mov bx,1000h
	int 21h
	jc MemNotOk
	mov word ptr [Empty],ax		; Save pointer

	sub ax,10h 			; Account for "missing" PSP
	mov word ptr cs:[jump-2], ax
	mov word ptr [MemPtr],ax
	jmp MemAllocOk

MemNotOk:
	mov dx, offset MsgMemFail	; Apparently we couldn't allocate mem
	call WriteLn
	call Exit

MemAllocOk:
	mov edx, offset MsgMemOk	; Everything ok
	call WriteLn
	
	mov ax, 55AAh
	xor edi,edi
	mov es, [Empty]
	mov ecx, 1000h*10h/2
	rep stosw
	push cs
	pop es
	
	mov dx, Offset MsgMemFilled     ; MemFilled Succesfully
	call WriteLn

	mov ax, 4b03h			; Load COM file
	mov dx, offset InFile
	mov bx, offset Empty
	int 21h
	jnc LoadOk
	call Exit	

LoadOk:
	mov dx, offset MsgLoaded	; Loaded succesfully
	call WriteLn

	mov dx, offset int1handler	; set interupt handler
	mov ax,2501h
	int 21h

	mov dx, offset MsgInt1Inst	; Loaded succesfully
	call WriteLn

	mov ax, cs			; setup own stack frame
	mov ownstackss, ax
	
	cli				; Setup registers
	mov sp, 0ffffh
	mov ss, [MemPtr]
	mov es, [MemPtr]
	mov ds, [MemPtr]
	sti

	pushf				; Turn on tracer
	pop ax
	or ah,1
	push ax
	popf
	
	mov ax,cs:[f1ax]		; Registers as on INTRO
	mov bx,cs:[f1bx]
	mov cx,cs:[f1cx]
	mov dx,cs:[f1dx]
	mov di,cs:[f1di]
	mov si,cs:[f1si]
	mov bp,cs:[f1bp]


	db 0eah,0,1,0,0				; Jump to code
	jump: dw 0 

call Exit

MsgMemFail 	db '  Memory Allocation Failed$'
MsgMemOk   	db '  Memory Allocation Ok$'
MsgMemFilled 	db '  Memory Filled with Pattern$'
MsgLoaded  	db '  ComFile Loaded$'
MsgInt1Inst	db '  Interupt 1 vector installed$'
MsgLn      	db 10,13,'$'
MemPtr 		dw 0
InFile 		db 'input.com',0
flaf  		db 0
Empty 		dw 0
tag 		db '2nd&mi' ; personal tag.. not used
;registers
f1ax 	dw 0
f1bx 	dw 0
f1cx 	dw 0
f1dx 	dw 0
f1di 	dw 0
f1si 	dw 0
f1bp 	dw 0

include func.inc	; Various procedures
include tracer.inc	; Int1 Handler
include Writeout.inc	; Function to writeoutput

End Start


