; DUMPEXE detector by Stone/UCF 1997
; MCB-search code partially Ripped from Jammer/UCF's Softice detection
; Full credit for this IDEA and the code utilized by this method of detection
; should go to the allmighty Jammer, whom we can only admire!


.model small
.stack 100h

.data         
McbStatus       equ 0           ; Offset of MCB status
InChain         equ 'M'         ; If MCB:0 equals 'M' then MCB is in chain
LastInChain     equ 'Z'         ; If MCB:0 equals 'Z' it's last in chain
BlockStatus     equ 1           ; Offset of Block status
FreeBlock       equ 0           ; If MCB:1 equals 0 then block is free
OwnerDos        equ 8           ; If MCB:1 equals 8 then MCB belongs to DOS
BlockSize       equ 3           ; Offset of Block size in paragraphs
MCBName         equ 8

SearchResult    db 0
StringSize      equ 5

bugsy        db 'BUGSY',0	; Used by method 3 & 4 (could & should be different)
bugsyoff     equ 1375h   ; offset of string "bugsy" string
string       db 090h,090h,090h,090h,01eh,02eh,08eh,01eh,0ch,035h ; used by method 1

int9det      db 'DumpExe found on INT 9h vector' ,10,13,'$'
intfbdet     db 'DumpExe found on INT 0FBh vector',10,13,'$'
bugsyf       db 'DumpExe was found on Bugsy''s TAG',10,13,'$'
dumpexeh     db 'DumpExe was found thru MCB search',10,13,'$'


.code
	mov ax, @data            ; Make DS&ES point to the DATA
	mov ds,ax
	mov es,ax

	xor ax,ax
	mov ds,ax

	mov si, 4h*9h			; Fetch interupt 9h
	mov ax, word ptr [si]
	mov bx, word ptr [si+2]

	mov ds, bx
	mov si, ax
	mov cx, 9h
	lea di,string			; Compare with int9 handler
	repz cmpsb
	jcxz dumpexe_here		
	jmp next			; Not it wasn't!
dumpexe_here:
	lea dx, int9det
	call write
next:
	xor ax,ax			; This method is the method EXEDUMP
	mov ds,ax			; It self does!
	mov si,4*0fbh
	mov di, [si]
	mov bx, [si+2]
	mov ds,bx
	mov dx, word ptr [di+2]
	cmp dx, 'UD'
	jnz next2
	mov dx, word ptr [di+4]
	cmp dx, 'PM'
	jnz next2
	lea dx, intfbdet
	call write

next2:
	xor ax,ax
	mov ds,ax
	mov si,4*0fbh
	mov di, [si+2]
	mov ds, di
	mov si, bugsyoff
	lea di, [bugsy]
	mov cx,5
	repz cmpsb
	jcxz bugsyh
	jmp next3
bugsyh:
	lea dx, bugsyf
	call write        

next3:
     		mov ax, @data
		mov ds, ax
	        call    GetFirstMCB	; Get address of First MCB in chain
                call    scanfordumpexe
                mov     al,SearchResult
		cmp     al,1
		jnz     quit
		lea     dx, dumpexeh
		call    write
quit:	
mov ax,4c01h
int 21h



write PROC
	mov ax,@data
	mov ds,ax
	mov ah,9h
	int 21h
	ret
endP write

GetFirstMcb     proc
                push    es bx           ; Save ES BX
                mov     ah,52h          ; Get SYSVARS in ES:BX
                int     21h
                mov     ax,es:[bx-2]    ; [ES:BX-2] = First MCB seg
                pop     bx es           ; Restore ES:BX
                ret
GetFirstMcb     endp

scanfordumpexe      proc
                push    es
                mov     es,ax           ; Get segment of first MCB

ScanMcb:        cmp     byte ptr es:[McbStatus],LastInChain ; Check if last
                je      ExitScan        ; jump if last in chain
                cmp     word ptr es:[BlockStatus],FreeBlock ; Check if free
                je      ScanNextMcb     ; Jump if free block
                call    Searchde
                jc      ScanNextMcb     ; Carry = Not found
ExitScan:       pop     es              ; Pop back segments
                ret                     ; We're done.. found or not

ScanNextMcb:    mov     ax,es           ; Put MCB seg in AX
                add     ax,es:[BlockSize] ; Add block size
                inc     ax              ; Include MCB paragraph
                mov     es,ax           ; ES = Next MCB
                jmp     ScanMcb         ; Loop
scanfordumpexe      endp


Searchde        proc
                push    es
		mov ax,es
		inc ax			; Adjust for MCB
		mov es,ax
		mov cx, stringsize
		mov di, bugsyoff+100h	; Offset of bugsy, adjust for PSP
		lea si, bugsy
		repz cmpsb
		jnz DeNotFound

	        mov      SearchResult,1
                clc
                pop     es
                ret
DeNotFound:
                stc
                pop     es
                ret
Searchde      endp


end










