;
;
;                   FILE.INC - macros for accessing one file
;                   (C) Copyright 1998 by ANAKiN [DaVinci]
;
;

Comment %
          fileopen  <filename>
          fileclose
          filelseek <distance>
          fileread  <buffer> <bytes>
          filewrite <buffer> <bytes>
        %

;
; imports
;

Extrn   CreateFileA    : PROC
Extrn   CloseHandle    : PROC
Extrn   ReadFile       : PROC
Extrn   WriteFile      : PROC
Extrn   SetFilePointer : PROC

;
; constants
;

FILE_BEGIN      equ 0

GENERIC_READ    equ 80000000h
GENERIC_WRITE   equ 40000000h
GENERIC_RW      equ GENERIC_READ + GENERIC_WRITE

CREATE_NEW      equ 1
CREATE_ALWAYS   equ 2
OPEN_EXISTING   equ 3
OPEN_ALWAYS     equ 4

;
; data
;

.data

FileAttr        dd 0
NumberOfBytesRW dd 0
FileHandle      dd 0

;
; macros
;

.code

;
; fileopen - opens a file for read & write access
; IN:
;  _filename
; OUT:
;  FileHandle filled
;

fileopen macro  _filename
        PUSH    0                 ; hTemplateFile
        PUSH    offset FileAttr   ; fdwAttrs
        PUSH    OPEN_EXISTING     ; fdwCreate
        PUSH    0                 ; lpsa
        PUSH    0                 ; fdwShareMode
        PUSH    GENERIC_RW        ; fdwAccess
        PUSH    filename          ; lpszName
        CALL    CreateFileA
        MOV     [FileHandle], EAX
endm

;
; fileclose - close file
; IN:
;  nothing
; OUT:
;  nothing
;

fileclose macro
        PUSH    [FileHandle]
        CALL    CloseHandle
endm

;
; filelseek - seek to fileposition
; IN:
;  distance
; OUT:
;  nothing
;

filelseek macro _distance
        PUSH    FILE_BEGIN
        PUSH    0
        PUSH    _distance
        PUSH    [FileHandle]
        CALL    SetFilePointer
endm

;
; fileread - read a specific number of bytes from the file
; IN:
;  buffer
;  number of bytes
; OUT:
;  buffer filled, (EAX == -1) -> failed
;

fileread macro  _buffer, _BytesToRead
        PUSH    0                        ; lpOverlapped
        PUSH    offset NumberOfBytesRW   ; lpNoBR
        PUSH    _BytesToRead             ; lpNoBTR
        PUSH    offset _buffer           ; lpBuffer
        PUSH    [FileHandle]             ; hFile
        CALL    ReadFile
endm

;
; filewrite - write a specific number of bytes to the file
; IN:
;  buffer
;  number of bytes
; OUT:
;  (EAX == -1) -> failed
;

filewrite macro  _buffer, _BytesToWrite
        PUSH    0                        ; lpOverlapped
        PUSH    offset NumberOfBytesRW   ; lpNoBW
        PUSH    _BytesToWrite            ; lpNoBTW
        PUSH    offset _buffer           ; lpBuffer
        PUSH    [FileHandle]             ; hFile
        CALL    WriteFile
endm
