;
;
;                STNPEER.ASM - remover for Stone's PE-crypter
;                   (C) Copyright 1998 by ANAKiN [DaVinci]
;
;

.386p
locals
jumps
.model flat, stdcall

;
; imports
;

Extrn   ExitProcess     : PROC
Extrn   GetCommandLineA : PROC

;
; data
;

string macro name, what
   name  db what
 l&name equ $-name
endm

.data

 Logo      db "", 13, 10
           db "Stone's PE-ExeEncrypter v1.13 Remover                               26. Jan '98", 13, 10
           db "Copyright (c) 1998 by ANAKiN [DaVinci]                      All Rights Reserved", 13, 10
           db "Copy registered to: PUBLIC!", 13, 10
lLogo      equ $-Logo

 string    <Logo2>    <"", 13, 10, 13, 10>
 string    <usage>    <13, 10, "Usage:  STNPEER filename.ext", 13, 10>
 string    <msgok>    <"OK", 13, 10>
 string    <msgfail>  <"FAILED!", 13, 10>
 string    <msgv100>  <"OK, version 1.00", 13, 10>
 string    <msgv113>  <"OK, version 1.13", 13, 10>
 string    <msgopen>  <"   Opening file.                    ">
 string    <msgchkfm> <"   Checking for PE format.          ">
 string    <msgchkcr> <"   Checking for STNPEE signature.   ">
 string    <msganal>  <"   Analysing STNPEE loader.         ">
 string    <msgdecr>  <"   Decrypting sections.             ">
 string    <msgwrite> <"   Writing deprotected file.        ">
 string    <msgclose> <"   Closing file.                    ">

STNPEE_signature  db  055h, 057h, 056h, 052h, 051h, 053h, 0E8h, 000h
                  db  000h, 000h, 000h, 05Dh, 08Bh, 0D5h, 081h, 0EDh
signaturelen      equ $-STNPEE_signature

.data?

; Buffer for the MZ header
MZ_sig         dw  ?            ; MZ / ZM
MZ_notforus    db  58 dup (?)   ; not needed
MZ_pehead      dd  ?            ; seekvalue to MZ header
MZ_len         equ $-MZ_sig

; Buffer for the PE header
PE_sig         dd  ?            ; PE\0\0
PE_cpu         dw  ?            ; machine
PE_numsec      dw  ?            ; number of sections
PE_notforus1   db  12 dup (?)   ; not needed
PE_soh         dw  ?            ; size of optional header
PE_notforus2   dw  ?            ; not needed
PE_len         equ $-PE_sig

; Buffer for beginning of Optional Header
OP_sig         dw  ?            ; signature
OP_notforus1   db  14 dup (?)   ; not needed
OP_entrypoint  dd  ?            ; program entrypoint
OP_len         equ $-OP_sig

; Buffer for last section
SE_name        db  8 dup (?)    ; section name '.Stone'
SE_notforus1   dd  ?            ; not needed (virtsize)
SE_rva         dd  ?            ; VirtAddress
SE_size        dd  ?            ; PhysSize
SE_seek        dd  ?            ; Seekvalue to sectiondata
SE_notforus2   db  16 dup (?)   ; not needed
SE_len         equ $-SE_name

; Empty section
ES_buffer      db  SE_len dup (?)

keepoffareas   dd  ?            ; Start of Keep off area
keepoffareae   dd  ?            ; End of Keep off area
version        db  ?            ; version 1.0=100 1.13=113
filename       dd  ?            ; Address of filename
section1       dd  ?            ; Seekvalue to first sectionheader
sectionl       dd  ?            ; Seekvalue to last sectionheader
varptr         dd  ?            ; Address of variables
decreasekey    db  ?            ; SUB key for sections
nsecs          db  ?            ; number of encrypted sections
buffer         db  1000 dup (?) ; buffer for loader
sectionbuffer  db  2048*1024 dup (?) ; buffer for decryption

;
; functions
;

.code

include file.inc
include console.inc

CommandLineHandling:
        CALL    GetCommandLineA

        ;  Get length of CommandLine
        MOV     EDI, EAX     ; EDI=address of commandline
        MOV     ESI, EDI     ; ESI too
        XOR     ECX, ECX
        DEC     ECX
        XOR     EAX, EAX
        REPNE   SCASB        ; Search for end of commandline
        DEC     EDI
        SUB     EDI, ESI
        MOV     ECX, EDI

        ;  Get first parameter
        MOV     EDI, ESI
        MOV     AL, 20h      ; Search spaces
        REPNE   SCASB        ; get rid of program name
        REP     SCASB        ; get rid of spaces
        OR      ECX, ECX     ; ECX==0
        JE      helpscreen
        DEC     EDI

        CMP     byte ptr [EDI], '/'
        JE      helpscreen
        CMP     byte ptr [EDI], ','
        JE      helpscreen
        CMP     byte ptr [EDI], '-'
        JNE     CommandLineHandlingend

helpscreen:
        cwrites <usage>
        cwrites <Logo2>
        JMP     end_1

CommandLineHandlingend:
        MOV     filename, EDI
        RET

Chk_PE:
        ;  Read MZ header
        fileread <MZ_sig> <MZ_len>
        CMP     EAX, -1                 ; Error?
        JE      Chk_PEend               ; Then Exit

        ;  Checking for ZM / MZ signature
        XOR     EAX, EAX
        DEC     EAX
        CMP     MZ_sig, 'MZ'
        JE      Chk_PEisexe
        CMP     MZ_sig, 'ZM'
        JNE     Chk_PEend

Chk_PEisexe:
        ;  Seek to PE header
        filelseek <MZ_pehead>

        ;  Read PE header
        fileread <PE_sig> <PE_len>
        CMP     EAX, -1                   ; Error?
        JE      Chk_PEend                 ; Then Exit

        ;  Checking for PE\0\0 signature
        XOR     EAX, EAX
        DEC     EAX
        CMP     PE_sig, 00004550h
        JNE     Chk_PEend

        ;  Read Optional header
        fileread <OP_sig> <OP_len>
        CMP     EAX, -1                   ; Error?
        JE      Chk_PEend                 ; Then Exit

        ;  Calculate address of first section header
        MOV     EAX, MZ_pehead   ; EAX=MZ_pehead
        ADD     EAX, PE_len      ; EAX+=PE_len
        MOVZX   EBX, PE_soh      ; EBX=PE_soh
        ADD     EAX, EBX         ; EAX+=EBX
        MOV     section1, EAX

        ;  Calculate address of last section header
        MOV     EAX, SE_len      ; EAX=SE_len
        MOVZX   EBX, PE_numsec   ; EBX=PE_numsec
        DEC     EBX              ; EBX-=1
        MUL     EBX              ; EAX*=EBX
        ADD     EAX, section1    ; EAX+=section1
        MOV     sectionl, EAX

        ;  Ensure EAX=0
        XOR     EAX, EAX                ; OK!
Chk_PEend:
        RET

Chk_Sig:
        ;  Seek to last sectionheader
        filelseek <sectionl>

        ;  Read last sectionheader
        fileread  <SE_name> <SE_len>
        CMP     EAX, -1                  ; Error?
        JE      Chk_Sigend               ; Then Exit

        ;  Entrypoint==start of this section?
        XOR     EAX, EAX
        DEC     EAX                      ; EAX=-1
        MOV     EBX, SE_rva
        CMP     EBX, OP_entrypoint
        JNE     Chk_Sigend

        ;  Seek to section
        filelseek  <SE_seek>

        ;  Read section
        fileread   <buffer> <1000>
        CMP     EAX, -1                  ; Error?
        JE      Chk_Sigend               ; Then exit

        ;  Compare signatures
        XOR     EAX, EAX
        DEC     EAX
        MOV     ESI, offset buffer
        MOV     EDI, offset STNPEE_signature
        MOV     ECX, signaturelen
        REP     CMPSB
        JNE     Chk_Sigend

        ;  Ensure EAX=0
        XOR     EAX, EAX                 ; OK!
Chk_Sigend:
        RET

Ana_Loader:
        ;  Search decryption loop
        MOV     ECX, 900                 ; :)
        MOV     EDI, offset buffer
searchloop:
        MOV     AL, 80h
        REPNE   SCASB
        JE      loopmaybefound
        XOR     EAX, EAX
        DEC     EAX                      ; EAX=-1
        JMP     Ana_Loaderend
loopmaybefound:
        CMP     byte ptr [EDI], 2Bh
        JNE     searchloop
        CMP     word ptr [EDI+2], 0E243h      ; INC EBX ; LOOP
        JNE     searchloop

        MOV     AL, [EDI+1]
        MOV     decreasekey, AL

        ; 0FAh = v1.00
        CMP     byte ptr [EDI+4], 0FAh
        JZ      loopv100

        ; 0E8h = v1.13
        CMP     byte ptr [EDI+4], 0E8h
        JZ      loopv113

        ; unknown version
        XOR     EAX, EAX
        DEC     EAX                   ; EAX=-1
        JMP     Ana_Loaderend

loopv100:
        cwrites <msgv100>
        MOV     keepoffareas, 0       ; NO IAT handling
        MOV     keepoffareae, 0       ; in this version
        MOV     version, 100
        JMP     search_vars

loopv113:
        cwrites <msgv113>
        MOV     version, 113

search_vars:
        ;  Search variables
        MOV     ECX, 900                  ; :)
        MOV     EDI, offset buffer
searchvar:
        MOV     AL, 0E0h
        REPNE   SCASB
        JE      varmaybefound
        XOR     EAX, EAX
        DEC     EAX
        JMP     Ana_Loaderend
varmaybefound:
        CMP     word ptr [EDI-3], 0FF5Dh
        JNE     searchvar
        CMP     word ptr [EDI-5], 05F5Eh
        JNE     searchvar

;-----> for version 1.13 there are some special variables
        CMP     version, 113
        JNE     isversion100
        MOV     EAX, [EDI]         ; Get start of IAT
        MOV     keepoffareas, EAX
        MOV     EAX, [EDI+4]       ; Get end of IAT
        MOV     keepoffareae, EAX
        ADD     EDI, 9             ; Adjust varptr
isversion100:

;-----> Get old entrypoint
        MOV     EAX, [EDI+4]
        MOV     OP_entrypoint, EAX

;-----> Get number of encrypted sections
        MOV     AL, [EDI+8]
        MOV     nsecs, AL

;-----> Store position of variables
        ADD     EDI, 13
        MOV     varptr, EDI

;-----> Ensure EAX=0
        XOR     EAX, EAX          ; OK!
Ana_Loaderend:
        RET

Decrypt:
        MOVZX   ECX, PE_numsec    ; repeat for all stored sections
forallsections:

        ;  Calculate address of section header
        MOV     EAX, SE_len      ; EAX=SE_len
        MOV     EBX, ECX         ; EBX=ECX
        DEC     EBX              ; EBX-=1
        MUL     EBX              ; EAX*=EBX
        ADD     EAX, section1    ; EAX+=section1

        PUSHA
        ;  Seek to sectionheader
        filelseek <eax>

        ;  Read it
        fileread  <SE_name> <SE_len>
        CMP     EAX, -1
        POPA
        JE      Decrypt_end

        MOV     DL, nsecs       ; repeat for all encrypted sections
        MOV     ESI, varptr
getRVA:
        LODSD
        MOV     EDI, EAX
getSize:
        LODSD
        CMP     EDI, SE_rva
        JB      notthissection

        ;  Read section into buffer
        PUSHA
        filelseek <SE_seek>
        fileread  <sectionbuffer> <SE_size>
        CMP     EAX, -1
        POPA
        JE      Decrypt_end

        PUSH    ECX
        PUSH    EBP
        PUSH    EDX

        MOV     EBP, SE_rva
        MOV     ECX, EAX
        SUB     EDI, EBP

        ;  Decrypt the section
        MOV     AL, decreasekey
innerloop:
        LEA     EDX, [EDI+SE_rva]
        CMP     EDX, keepoffareas
        JB      dodecrypt
        CMP     EDX, keepoffareae
        JBE     keepoff
dodecrypt:
        SUB     [EDI+sectionbuffer], AL
keepoff:
        INC     EDI
        LOOP    innerloop

        POP     EDX
        POP     EBP
        POP     ECX

        ;  Write section back to disk
        PUSHA
        filelseek <SE_seek>
        filewrite <sectionbuffer> <SE_size>
        CMP     EAX, -1
        POPA
        JE      Decrypt_end

notthissection:
        DEC     DL
        JNZ     getRVA
exitthissection:

        LOOP    forallsections

        ;  Ensure EAX=0
        XOR     EAX, EAX                ; OK!
Decrypt_end:
        RET

WriteBack:
;-----> Remove last sectionheader
        DEC     PE_numsec               ; Decrease number of sections
        filelseek  <sectionl>           ; Seek to last sectionheader
        filewrite  <ES_buffer> <SE_len> ; Clear in header
        CMP     EAX, -1                 ; Error?
        JE      WriteBackend            ; Then Exit

;-----> Seek PE header
        filelseek <MZ_pehead>

;-----> WriteBack PE header
        filewrite <PE_sig> <PE_len>
        CMP     EAX, -1                 ; Error?
        JE      WriteBackend            ; Then Exit

;-----> WriteBack OP header
        filewrite <OP_sig> <OP_len>
        CMP     EAX, -1                 ; Error?
        JE      WriteBackend            ; Then Exit

;-----> Ensure EAX=0
        XOR     EAX, EAX                ; OK!
WriteBackend:
        RET

Main:
        cinit
        cwrites <Logo>

        CALL    CommandLineHandling

        cwrites <Logo2>

        cwrites  <msgopen>        ; ' Opening file.'
        fileopen <filename>
        CMP EAX, -1
        JE  failend_1
        cwrites <msgok>           ; 'OK'

        cwrites <msgchkfm>        ; ' Checking for PE format.'
        CALL    Chk_PE
        CMP     EAX, -1
        JE      failclose
        cwrites <msgok>           ; 'OK'

        cwrites <msgchkcr>        ; ' Checking for STNPEE signature.'
        CALL    Chk_Sig
        CMP     EAX, -1
        JE      failclose
        cwrites <msgok>           ; 'OK'

        cwrites <msganal>         ; ' Analysing STNPEE loader.'
        CALL    Ana_Loader
        CMP     EAX, -1
        JE      failclose

        cwrites <msgdecr>         ; ' Decrypting sections.'
        CALL    Decrypt
        CMP     EAX, -1
        JE      failclose
        cwrites <msgok>           ; 'OK'

        cwrites <msgwrite>        ; ' Writing deprotected file.'
        CALL    WriteBack
        CMP     EAX, -1
        JE      failclose
        cwrites <msgok>           ; 'OK'

closing:
        cwrites <msgclose>        ; ' Closing file.'
        fileclose
        CMP EAX, -1
        JE  failend_1
        cwrites <msgok>           ; 'OK'
        JMP end_1

failclose:
        cwrites <msgfail>         ; 'FAILED!'
        JMP     closing

failend_1:
        cwrites <msgfail>         ; 'FAILED!'

end_1:
        PUSH    0
        CALL    ExitProcess

end Main