Comment % This snippet will set an ExceptionFrame which will allow structured
	  exception handling in tasm-PROC's. It's particularly well-suited for
	  parameter verification layers - the purpose for which it was designed.
	  It's quite crude but very efficient.

	  Notice you should only use this in single threaded processes


	  You may use this snippet at your OWN risc. 

	  2nd&mi
	  Stone
	  email: stone@one.se
	  http://www.cracking.net


	%
SetExceptionFrame Macro 
	xor	edx,edx
	push	offset @@ErrHandler
	push	dword ptr fs:[edx]
	mov	[OldStack], esp
	mov	[OldEbp], ebp

	mov	fs:[edx], esp	
	jmp	@@Continiue

@@ErrHandler:			; This will execute in event of an error
;	int 3
	mov	esp, [OldStack]
	mov	ebp, [OldEbp]
	pop	edx
	mov	fs:[0],edx

	pop	eax		; adjust stack
	xor	eax,eax		; Return False
	ret

@@Continiue:
EndM

RestoreExceptionFrame Macro
	pop	edx
	mov	fs:[0],edx
	pop	edx		; adjust stack
EndM


.data
	OldStack	dd 0	; static data
	OldEbp		dd 0


