/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateConverter
implements ObjectConverter {
    public static final ConverterContext DATETIME_CONTEXT = new ConverterContext("DateTime");
    public static final ConverterContext TIME_CONTEXT = new ConverterContext("Time");
    public static final ConverterContext DATE_CONTEXT = new ConverterContext("Date");
    private DateFormat _shortFormat = SimpleDateFormat.getDateInstance(3);
    private DateFormat _mediumFormat = SimpleDateFormat.getDateInstance(2);
    private DateFormat _longFormat = SimpleDateFormat.getDateInstance(1);
    private DateFormat _defaultFormat = SimpleDateFormat.getDateInstance(2);
    private DateFormat _shortDatetimeFormat = SimpleDateFormat.getDateTimeInstance(3, 3);
    private DateFormat _mediumDatetimeFormat = SimpleDateFormat.getDateTimeInstance(2, 2);
    private DateFormat _longDatetimeFormat = SimpleDateFormat.getDateTimeInstance(1, 1);
    private DateFormat _defaultDatetimeFormat = SimpleDateFormat.getDateTimeInstance(2, 2);
    private DateFormat _shortTimeFormat = SimpleDateFormat.getTimeInstance(3);
    private DateFormat _mediumTimeFormat = SimpleDateFormat.getTimeInstance(2);
    private DateFormat _longTimeFormat = SimpleDateFormat.getTimeInstance(1);
    private DateFormat _defaultTimeFormat = SimpleDateFormat.getTimeInstance(2);

    public synchronized String toString(Object object, ConverterContext converterContext) {
        TimeZone timeZone;
        if (object == null) {
            return "";
        }
        if (object instanceof Calendar) {
            timeZone = ((Calendar)object).getTimeZone();
            object = ((Calendar)object).getTime();
        } else if (object instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            timeZone = calendar.getTimeZone();
        } else {
            timeZone = TimeZone.getDefault();
        }
        if (object instanceof Date || object instanceof Number) {
            if (converterContext != null && converterContext.getUserObject() instanceof DateFormat) {
                return ((DateFormat)converterContext.getUserObject()).format(object);
            }
            if (DATETIME_CONTEXT.equals(converterContext)) {
                this._defaultDatetimeFormat.setTimeZone(timeZone);
                return this._defaultDatetimeFormat.format(object);
            }
            if (TIME_CONTEXT.equals(converterContext)) {
                this._defaultTimeFormat.setTimeZone(timeZone);
                return this._defaultTimeFormat.format(object);
            }
            this._defaultFormat.setTimeZone(timeZone);
            return this._defaultFormat.format(object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    public synchronized Object fromString(String string, ConverterContext converterContext) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        try {
            Object object;
            Object object2 = object = converterContext != null ? converterContext.getUserObject() : null;
            if (object instanceof DateFormat) {
                return ((DateFormat)object).parse(string);
            }
            if (DATETIME_CONTEXT.equals(converterContext)) {
                return this._defaultDatetimeFormat.parse(string);
            }
            if (TIME_CONTEXT.equals(converterContext)) {
                return this._defaultTimeFormat.parse(string);
            }
            return this._defaultFormat.parse(string);
        }
        catch (ParseException parseException) {
            if (DATETIME_CONTEXT.equals(converterContext)) {
                try {
                    return this._shortDatetimeFormat.parse(string);
                }
                catch (ParseException parseException2) {
                    try {
                        return this._mediumDatetimeFormat.parse(string);
                    }
                    catch (ParseException parseException3) {
                        try {
                            return this._longDatetimeFormat.parse(string);
                        }
                        catch (ParseException parseException4) {
                            return string;
                        }
                    }
                }
            }
            if (TIME_CONTEXT.equals(converterContext)) {
                try {
                    return this._shortTimeFormat.parse(string);
                }
                catch (ParseException parseException5) {
                    try {
                        return this._mediumTimeFormat.parse(string);
                    }
                    catch (ParseException parseException6) {
                        try {
                            return this._longTimeFormat.parse(string);
                        }
                        catch (ParseException parseException7) {
                            return string;
                        }
                    }
                }
            }
            try {
                return this._shortFormat.parse(string);
            }
            catch (ParseException parseException8) {
                try {
                    return this._mediumFormat.parse(string);
                }
                catch (ParseException parseException9) {
                    try {
                        return this._longFormat.parse(string);
                    }
                    catch (ParseException parseException10) {
                        return string;
                    }
                }
            }
        }
    }

    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public DateFormat getDefaultFormat() {
        return this._defaultFormat;
    }

    public void setDefaultFormat(DateFormat dateFormat) {
        this._defaultFormat = dateFormat;
    }

    public DateFormat getDefaultTimeFormat() {
        return this._defaultTimeFormat;
    }

    public void setDefaultTimeFormat(DateFormat dateFormat) {
        this._defaultTimeFormat = dateFormat;
    }

    public DateFormat getDefaultDatetimeFormat() {
        return this._defaultDatetimeFormat;
    }

    public void setDefaultDatetimeFormat(DateFormat dateFormat) {
        this._defaultDatetimeFormat = dateFormat;
    }
}

