/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.marker;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.SyntaxStyle;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.editor.marker.MarkerEye;
import com.jidesoft.editor.marker.MarkerEyePainter;
import com.jidesoft.editor.marker.MarkerStripe;
import com.jidesoft.editor.marker.MarkerStripePainter;
import com.jidesoft.swing.JideBoxLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class MarkerArea
extends JPanel {
    private static Logger a = Logger.getLogger(MarkerArea.class.getName());
    public static final int MODE_FINE = 0;
    public static final int MODE_WARNING = 100;
    public static final int MODE_ERROR = 200;
    public static final Color DEFAULT_FINE_COLOR = Color.GREEN;
    public static final Color DEFAULT_WARNING_COLOR = Color.YELLOW;
    public static final Color DEFAULT_ERROR_COLOR = Color.RED;
    public static final Color DEFAULT_INSPECTING_COLOR = Color.YELLOW;
    private CodeEditor b;
    private MarkerEye c;
    private MarkerStripe d;
    private JPanel e;
    private MarkerEyePainter f;
    private MarkerStripePainter g;
    private int h;
    private int i;
    private boolean j;
    public static boolean k;

    public MarkerArea(CodeEditor codeEditor) {
        boolean bl = k;
        this.b = codeEditor;
        this.b.setMarkerArea(this);
        this.h = 0;
        this.i = 0;
        this.setLayout(new JideBoxLayout(this, 1));
        b_ b_2 = new b_();
        codeEditor.getDocument().addDocumentListener(b_2);
        codeEditor.getFoldingModel().addFoldingSpanListener(b_2);
        this.c = this.createMarkerEye(codeEditor);
        this.d = this.createMarkerStripe(codeEditor);
        this.add((Component)this.c, "fix");
        this.add((Component)this.d, "vary");
        this.e = new JPanel();
        this.e.setMinimumSize(new Dimension(0, 0));
        this.add((Component)this.e, "flexible");
        this.updateMarkerAreaHeight();
        if (CodeEditor.O) {
            k = !bl;
        }
    }

    protected MarkerStripe createMarkerStripe(CodeEditor codeEditor) {
        return new MarkerStripe(codeEditor, this);
    }

    protected MarkerEye createMarkerEye(CodeEditor codeEditor) {
        return new MarkerEye(codeEditor, this);
    }

    public MarkerStripe getMarkerStripe() {
        return this.d;
    }

    public MarkerEye getMarkerEye() {
        return this.c;
    }

    public MarkerEyePainter getEyePainter() {
        return this.f;
    }

    public void setEyePainter(MarkerEyePainter markerEyePainter) {
        this.f = markerEyePainter;
        this.c.setPainter(this.f);
    }

    public MarkerStripePainter getStripePainter() {
        return this.g;
    }

    public void setStripePainter(MarkerStripePainter markerStripePainter) {
        this.g = markerStripePainter;
        this.d.setPainter(this.g);
    }

    public CodeEditor getCodeEditor() {
        return this.b;
    }

    public void setCodeEditor(CodeEditor codeEditor) {
        this.b = codeEditor;
    }

    public boolean isInspecting() {
        return this.j;
    }

    public void setInspecting(boolean bl) {
        block9: {
            MarkerArea markerArea;
            block7: {
                block8: {
                    boolean bl2;
                    boolean bl3;
                    block4: {
                        block5: {
                            block6: {
                                bl3 = k;
                                bl2 = a.isLoggable(Level.FINE);
                                if (bl3) break block4;
                                if (!bl2) break block5;
                                if (!bl) break block6;
                                a.fine("Inspection started");
                                if (!bl3) break block5;
                            }
                            a.fine("Inspection finished");
                        }
                        this.j = bl;
                        markerArea = this;
                        if (bl3) break block7;
                        bl2 = markerArea.j;
                    }
                    if (!bl2) break block8;
                    this.i = 0;
                    a.fine("Set minimum mode " + this.i);
                    if (!bl3) break block9;
                }
                this.applyMinimumMode();
                this.invalidate();
                markerArea = this;
            }
            markerArea.repaint();
        }
    }

    public int getMode() {
        return this.h;
    }

    public void setMode(int n) {
        block3: {
            Logger logger;
            block2: {
                logger = a;
                if (k) break block2;
                if (!logger.isLoggable(Level.FINE)) break block3;
                logger = a;
            }
            logger.fine("Set mode " + n);
        }
        this.h = n;
        this.repaint();
    }

    public void applyMinimumMode() {
        this.setMode(this.i);
        this.i = 0;
    }

    public void requireMinimumMode(int n) {
        block8: {
            block6: {
                MarkerArea markerArea;
                boolean bl;
                block7: {
                    int n2;
                    block5: {
                        bl = k;
                        n2 = a.isLoggable(Level.FINE);
                        if (!bl) {
                            if (n2 != 0) {
                                a.fine("Requiring minimum mode " + n);
                            }
                            n2 = this.isInspecting();
                        }
                        if (bl) break block5;
                        if (n2 == 0) break block6;
                        markerArea = this;
                        if (bl) break block7;
                        n2 = markerArea.i;
                    }
                    if (n2 >= n) break block6;
                    this.i = n;
                    markerArea = this;
                }
                markerArea.setMode(n);
                a.fine("Required minimum mode " + n);
                if (!bl) break block8;
            }
            a.fine("Not required " + n);
        }
    }

    public int getVisualLineCount() {
        return Math.max(this.b.getVisualLineCount(), this.b.getVisibleLines());
    }

    public Color getColor(int n) {
        block12: {
            Color color;
            block13: {
                SyntaxStyle syntaxStyle;
                SyntaxStyle syntaxStyle2;
                boolean bl;
                block11: {
                    bl = k;
                    switch (n) {
                        case 1: {
                            Color color2;
                            Color color3 = color2 = this.b.getStyles().getStyle(12).getStripeColor();
                            if (!bl) {
                                if (color3 == null) {
                                    return DEFAULT_WARNING_COLOR;
                                }
                                color3 = color2;
                            }
                            return color3;
                        }
                        case 0: {
                            Color color4;
                            Color color5 = color4 = this.b.getStyles().getStyle(11).getStripeColor();
                            if (!bl) {
                                if (color5 == null) {
                                    return DEFAULT_ERROR_COLOR;
                                }
                                color5 = color4;
                            }
                            return color5;
                        }
                    }
                    syntaxStyle = syntaxStyle2 = this.b.getStyles().getStyle(14 + n);
                    if (bl) break block11;
                    if (syntaxStyle == null) break block12;
                    syntaxStyle = syntaxStyle2;
                }
                color = syntaxStyle.getStripeColor();
                if (bl) break block13;
                if (color == null) break block12;
                color = syntaxStyle2.getStripeColor();
            }
            return color;
        }
        return null;
    }

    public void updateMarkerAreaHeight() {
        MarkerArea markerArea;
        block17: {
            block18: {
                int n;
                boolean bl;
                block15: {
                    JScrollBar jScrollBar;
                    Component component;
                    block16: {
                        JScrollBar jScrollBar2;
                        block14: {
                            JScrollBar jScrollBar3;
                            block12: {
                                block13: {
                                    JScrollBar jScrollBar4;
                                    bl = k;
                                    n = 0;
                                    jScrollBar3 = jScrollBar4 = this.b.getHorizontalScrollBar();
                                    if (bl) break block12;
                                    if (jScrollBar3 == null) break block13;
                                    jScrollBar3 = jScrollBar4;
                                    if (bl) break block12;
                                    if (jScrollBar3.isVisible()) {
                                        n += jScrollBar4.getPreferredSize().height;
                                    }
                                }
                                jScrollBar3 = this.b.getVerticalScrollBar();
                            }
                            component = jScrollBar2 = jScrollBar3;
                            if (bl) break block14;
                            if (component == null) break block15;
                            component = jScrollBar2;
                        }
                        if (bl) break block16;
                        if (!component.isVisible()) break block15;
                        component = jScrollBar2.getComponentAt(1, jScrollBar2.getHeight() - 2);
                    }
                    if ((jScrollBar = component) != null) {
                        n += ((Component)jScrollBar).getPreferredSize().height;
                    }
                }
                markerArea = this;
                if (bl) break block17;
                if (markerArea.e == null) break block18;
                markerArea = this;
                if (bl) break block17;
                if (markerArea.c == null) break block18;
                markerArea = this;
                if (bl) break block17;
                if (markerArea.c.getPreferredSize() != null) {
                    this.e.setPreferredSize(new Dimension(this.c.getPreferredSize().width, n));
                }
            }
            this.revalidate();
            markerArea = this;
        }
        markerArea.repaint();
    }

    private class b_
    implements DocumentListener,
    FoldingSpanListener {
        private b_() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            try {
                String string = documentEvent.getDocument().getText(documentEvent.getOffset(), documentEvent.getLength());
                if (string.indexOf(10) != -1) {
                    MarkerArea.this.repaint();
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            MarkerArea.this.repaint();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
            if (!foldingSpanEvent.isAdjusting()) {
                MarkerArea.this.repaint();
            }
        }
    }
}

