/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.status;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.status.AbstractCodeEditorStatusBarItem;
import com.jidesoft.swing.JidePopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;

public class LineBreakStatusBarItem
extends AbstractCodeEditorStatusBarItem
implements PropertyChangeListener,
MouseListener {
    public LineBreakStatusBarItem() {
    }

    public LineBreakStatusBarItem(String string) {
        super(string);
    }

    public void initialize() {
        this.setHorizontalAlignment(0);
        this.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = AbstractCodeEditorStatusBarItem.a;
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        JMenuItem jMenuItem = jidePopupMenu.add(this._editor.getResourceString("LineBreak.fileFormat"));
        jMenuItem.setEnabled(false);
        jidePopupMenu.addSeparator();
        this.a(jidePopupMenu, 0);
        this.a(jidePopupMenu, 1);
        this.a(jidePopupMenu, 2);
        jidePopupMenu.show(this, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        if (CodeEditor.O) {
            AbstractCodeEditorStatusBarItem.a = !bl;
        }
    }

    private void a(JidePopupMenu jidePopupMenu, final int n) {
        JMenuItem jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(new AbstractAction(this.getLineBreakText(n)){

            public void actionPerformed(ActionEvent actionEvent) {
                LineBreakStatusBarItem.this.getCodeEditor().setLineBreakStyle(n);
            }
        }));
        int n2 = this.getCodeEditor().getLineBreakStyle();
        if (!AbstractCodeEditorStatusBarItem.a) {
            n2 = n2 == n ? 1 : 0;
        }
        jMenuItem.setSelected(n2 != 0);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateText((Integer)propertyChangeEvent.getNewValue());
    }

    public void registerListener(CodeEditor codeEditor) {
        block3: {
            CodeEditor codeEditor2;
            block2: {
                codeEditor2 = codeEditor;
                if (AbstractCodeEditorStatusBarItem.a) break block2;
                if (codeEditor2 == null) break block3;
                codeEditor2 = codeEditor;
            }
            codeEditor2.addPropertyChangeListener("lineBreakStyle", this);
            this.updateText(codeEditor.getLineBreakStyle());
        }
    }

    public void unregisterListener(CodeEditor codeEditor) {
        block3: {
            CodeEditor codeEditor2;
            block2: {
                codeEditor2 = codeEditor;
                if (AbstractCodeEditorStatusBarItem.a) break block2;
                if (codeEditor2 == null) break block3;
                codeEditor2 = codeEditor;
            }
            codeEditor2.removePropertyChangeListener("lineBreakStyle", this);
        }
    }

    public String getLineBreakText(int n) {
        switch (n) {
            case 0: {
                return this._editor.getResourceString("LineBreak.pc");
            }
            case 2: {
                return this._editor.getResourceString("LineBreak.mac");
            }
            case 1: {
                return this._editor.getResourceString("LineBreak.unix");
            }
        }
        return this._editor.getResourceString("LineBreak.mixed");
    }

    public String getLineBreakTooltip(int n) {
        switch (n) {
            case 0: {
                return this._editor.getResourceString("LineBreak.pc.tooltip");
            }
            case 2: {
                return this._editor.getResourceString("LineBreak.mac.tooltip");
            }
            case 1: {
                return this._editor.getResourceString("LineBreak.unix.tooltip");
            }
        }
        return this._editor.getResourceString("LineBreak.mixed.tooltip");
    }

    public void updateText(int n) {
        this.setText(this.getLineBreakText(n));
        this.setToolTipText(this.getLineBreakTooltip(n));
    }
}

