/*
 * Decompiled with CFR 0.152.
 */
package com.zynamics.binnavi.standardplugins.callresolver;

import BinNavi.API.debug.Debugger;
import BinNavi.API.disassembly.AddressSpace;
import BinNavi.API.disassembly.AddressSpaceListenerAdapter;
import BinNavi.API.disassembly.IAddressSpaceListener;
import BinNavi.API.disassembly.Module;
import BinNavi.API.disassembly.View;
import com.zynamics.binnavi.standardplugins.callresolver.ICallResolverTarget;
import com.zynamics.binnavi.standardplugins.callresolver.ICallResolverTargetListener;
import com.zynamics.binnavi.standardplugins.callresolver.IndirectCall;
import com.zynamics.binnavi.standardplugins.callresolver.IndirectCallFinder;
import java.util.ArrayList;
import java.util.List;

public final class AddressSpaceCallResolverTarget
implements ICallResolverTarget {
    private final AddressSpace addressSpace;
    private final List<ICallResolverTargetListener> listeners = new ArrayList<ICallResolverTargetListener>();
    private final InternalAddressSpaceListener internalAddressSpaceListener = new InternalAddressSpaceListener();

    public AddressSpaceCallResolverTarget(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
        addressSpace.addListener((IAddressSpaceListener)this.internalAddressSpaceListener);
    }

    @Override
    public void addListener(ICallResolverTargetListener iCallResolverTargetListener) {
        this.listeners.add(iCallResolverTargetListener);
    }

    @Override
    public View createView() {
        return this.addressSpace.getProject().createView("Dynamic Trace View", "");
    }

    @Override
    public Debugger getDebugger() {
        return this.addressSpace.getDebugger();
    }

    @Override
    public List<IndirectCall> getIndirectCalls() {
        ArrayList<IndirectCall> arrayList = new ArrayList<IndirectCall>();
        for (Module module : this.addressSpace.getModules()) {
            arrayList.addAll(IndirectCallFinder.find(module));
        }
        return arrayList;
    }

    @Override
    public List<Module> getModules() {
        return this.addressSpace.getModules();
    }

    @Override
    public void removeListener(ICallResolverTargetListener iCallResolverTargetListener) {
        this.listeners.remove(iCallResolverTargetListener);
    }

    private class InternalAddressSpaceListener
    extends AddressSpaceListenerAdapter {
        private InternalAddressSpaceListener() {
        }

        public void changedDebugger(AddressSpace addressSpace, Debugger debugger) {
            for (ICallResolverTargetListener iCallResolverTargetListener : AddressSpaceCallResolverTarget.this.listeners) {
                try {
                    iCallResolverTargetListener.changedDebugger(AddressSpaceCallResolverTarget.this, debugger);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

