/*
 * Decompiled with CFR 0.152.
 */
package com.zynamics.binnavi.standardplugins.callresolver;

import BinNavi.API.debug.BreakpointManager;
import BinNavi.API.debug.DebugException;
import BinNavi.API.debug.Debugger;
import BinNavi.API.debug.DebuggerListenerAdapter;
import BinNavi.API.debug.IDebuggerListener;
import BinNavi.API.debug.MemoryModule;
import BinNavi.API.debug.Register;
import BinNavi.API.debug.raw.RegisterValues;
import BinNavi.API.debug.raw.ThreadRegisterValues;
import BinNavi.API.disassembly.Address;
import BinNavi.API.disassembly.CouldntLoadDataException;
import BinNavi.API.disassembly.Function;
import BinNavi.API.disassembly.IModuleListener;
import BinNavi.API.disassembly.Module;
import BinNavi.API.disassembly.ModuleListenerAdapter;
import BinNavi.API.helpers.RemoteFileBrowserLoader;
import BinNavi.CUtilityFunctions;
import com.zynamics.binnavi.standardplugins.callresolver.ICallResolverTarget;
import com.zynamics.binnavi.standardplugins.callresolver.ICallResolverTargetListener;
import com.zynamics.binnavi.standardplugins.callresolver.IndirectCall;
import com.zynamics.binnavi.standardplugins.callresolver.IndirectCallResolver;
import com.zynamics.binnavi.standardplugins.callresolver.ResolvedFunction;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public abstract class CallResolver {
    private static final Integer HIT_THRESHOLD = 20;
    private final ICallResolverTarget target;
    private final Debugger debugger;
    private final IDebuggerListener debuggerListener = new InternalDebuggerListener();
    private final Map<BigInteger, Set<ResolvedFunction>> resolvedAddresses = new HashMap<BigInteger, Set<ResolvedFunction>>();
    private final Map<BigInteger, Integer> hitCounter = new HashMap<BigInteger, Integer>();
    private final Map<Long, BigInteger> lastHits = new HashMap<Long, BigInteger>();
    private final ICallResolverTargetListener internalTargetListener = new InternalTargetListener();
    private final Map<Module, Map<Address, Function>> resolvedFunctions = new HashMap<Module, Map<Address, Function>>();
    private final Set<IndirectCall> removedBreakpoints = new HashSet<IndirectCall>();
    private int step = 0;
    private List<IndirectCall> indirectCallAddresses = null;
    private final IModuleListener moduleKeeperListener = new ModuleListenerAdapter(){

        public boolean closingModule(Module module) {
            return false;
        }
    };
    private final Set<Module> modules = new HashSet<Module>();
    private final JFrame parent;

    public CallResolver(ICallResolverTarget iCallResolverTarget, JFrame jFrame) {
        assert (iCallResolverTarget != null);
        this.parent = jFrame;
        this.target = iCallResolverTarget;
        this.debugger = iCallResolverTarget.getDebugger();
        iCallResolverTarget.addListener(this.internalTargetListener);
    }

    private void countHit(long l, BigInteger bigInteger) {
        if (!this.hitCounter.containsKey(bigInteger)) {
            this.hitCounter.put(bigInteger, 0);
        }
        this.hitCounter.put(bigInteger, this.hitCounter.get(bigInteger) + 1);
        this.lastHits.put(l, bigInteger);
    }

    private void findIndirectCallAddresses() {
        this.indirectCallAddresses = this.target.getIndirectCalls();
        if (!this.indirectCallAddresses.isEmpty()) {
            ++this.step;
        }
        this.foundIndirectCallAddresses(this.indirectCallAddresses);
    }

    private BigInteger getProgramCounter(long l, RegisterValues registerValues) {
        for (ThreadRegisterValues threadRegisterValues : registerValues) {
            if (threadRegisterValues.getThreadId() != l) continue;
            for (Register register : threadRegisterValues) {
                if (!register.isProgramCounter()) continue;
                return register.getValue();
            }
        }
        assert (false) : "It is not possible to hit a breakpoint in a non-existing thread";
        return null;
    }

    private void loadTargetModules() {
        for (Module module : this.target.getModules()) {
            module.addListener(this.moduleKeeperListener);
            this.modules.add(module);
            if (module.isLoaded()) continue;
            try {
                module.load();
            }
            catch (CouldntLoadDataException couldntLoadDataException) {
                this.errorLoadingModule(module, couldntLoadDataException);
                return;
            }
        }
        ++this.step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCompleteSingleStep(long l, BigInteger bigInteger) {
        BigInteger bigInteger2 = this.lastHits.get(l);
        if (bigInteger2 == null) {
            return;
        }
        Map<BigInteger, Set<ResolvedFunction>> map = this.resolvedAddresses;
        synchronized (map) {
            IndirectCall indirectCall;
            if (!this.resolvedAddresses.containsKey(bigInteger2)) {
                this.resolvedAddresses.put(bigInteger2, new HashSet());
            }
            ResolvedFunction resolvedFunction = this.resolveFunction(new Address(bigInteger));
            if (this.resolvedAddresses.get(bigInteger2).add(resolvedFunction)) {
                this.hitCounter.put(bigInteger2, 0);
            }
            if (this.hitCounter.get(bigInteger2) >= HIT_THRESHOLD && (indirectCall = IndirectCallResolver.findIndirectCall(this.debugger, this.indirectCallAddresses, bigInteger2)) != null) {
                this.removeBreakpoint(indirectCall);
                this.removedBreakpoints.add(indirectCall);
                this.resolvedCall(bigInteger2, resolvedFunction);
            }
        }
    }

    private void removeBreakpoint(IndirectCall indirectCall) {
        Module module = indirectCall.getModule();
        Address address = indirectCall.getAddress();
        BreakpointManager breakpointManager = this.debugger.getBreakpointManager();
        if (breakpointManager.hasBreakpoint(module, address)) {
            this.debugger.getBreakpointManager().removeBreakpoint(indirectCall.getModule(), indirectCall.getAddress());
        }
    }

    private void removeBreakpoints() {
        for (IndirectCall indirectCall : this.indirectCallAddresses) {
            if (this.removedBreakpoints.contains(indirectCall)) continue;
            try {
                this.removeBreakpoint(indirectCall);
            }
            catch (Exception exception) {}
        }
    }

    private void resolveBreakpoints() {
        if (this.debugger.getProcess().getTargetInformation() == null) {
            this.errorNotAttached();
            this.step = 2;
            return;
        }
        try {
            this.debugger.resume();
        }
        catch (DebugException debugException) {
            this.errorResuming(debugException);
        }
        ++this.step;
    }

    private ResolvedFunction resolveFunction(Address address) {
        for (Module module : this.target.getModules()) {
            Map<Address, Function> map;
            Function function;
            if (!this.resolvedFunctions.containsKey(module)) {
                this.resolveFunctions(module);
                if (!this.resolvedFunctions.containsKey(module)) continue;
            }
            if ((function = (map = this.resolvedFunctions.get(module)).get(address)) == null) continue;
            return new ResolvedFunction(function);
        }
        for (Module module : this.target.getDebugger().getProcess().getModules()) {
            if (address.toLong() < module.getBaseAddress().toLong() || address.toLong() >= module.getBaseAddress().toLong() + module.getSize()) continue;
            return new ResolvedFunction((MemoryModule)module, address);
        }
        return new ResolvedFunction(address);
    }

    private void resolveFunctions(Module module) {
        if (!module.isLoaded()) {
            return;
        }
        HashMap<Address, Function> hashMap = new HashMap<Address, Function>();
        for (Function function : module.getFunctions()) {
            Address address = this.target.getDebugger().toImagebase(module, function.getAddress());
            hashMap.put(address, function);
        }
        this.resolvedFunctions.put(module, hashMap);
    }

    private void setBreakpoint(IndirectCall indirectCall) {
        Module module = indirectCall.getModule();
        Address address = indirectCall.getAddress();
        BreakpointManager breakpointManager = this.debugger.getBreakpointManager();
        if (!breakpointManager.hasBreakpoint(module, address)) {
            this.debugger.getBreakpointManager().setBreakpoint(indirectCall.getModule(), indirectCall.getAddress());
        }
    }

    private void setBreakpoints() {
        for (IndirectCall indirectCall : this.indirectCallAddresses) {
            this.setBreakpoint(indirectCall);
        }
        ++this.step;
    }

    private void startDebugger() {
        if (this.debugger == null) {
            this.errorNoDebugger();
            return;
        }
        this.debugger.addListener(this.debuggerListener);
        try {
            if (!this.debugger.isConnected()) {
                this.debugger.connect();
            }
            ++this.step;
        }
        catch (DebugException debugException) {
            this.debugger.removeListener(this.debuggerListener);
            this.errorConnectingDebugger(debugException);
        }
    }

    private void stopResolving() {
        for (Module module : this.modules) {
            module.removeListener(this.moduleKeeperListener);
        }
        this.modules.clear();
        if (this.debugger != null && this.debugger.isConnected()) {
            try {
                this.debugger.terminate();
            }
            catch (DebugException debugException) {
                debugException.printStackTrace();
            }
        }
        if (this.step == 3 || this.step == 4 || this.step == 5) {
            this.debugger.removeListener(this.debuggerListener);
            this.removeBreakpoints();
        }
        ++this.step;
    }

    protected abstract void debuggerChanged();

    protected abstract void debuggerClosed();

    protected abstract void errorConnectingDebugger(DebugException var1);

    protected abstract void errorLoadingModule(Module var1, CouldntLoadDataException var2);

    protected abstract void errorNoDebugger();

    protected abstract void errorNotAttached();

    protected abstract void errorResuming(DebugException var1);

    protected abstract void foundIndirectCallAddresses(List<IndirectCall> var1);

    protected abstract void resolvedCall(BigInteger var1, ResolvedFunction var2);

    public void dispose() {
        this.target.removeListener(this.internalTargetListener);
        this.stopResolving();
    }

    public int getCurrentStep() {
        return this.step;
    }

    public List<IndirectCall> getIndirectAddresses() {
        return new ArrayList<IndirectCall>(this.indirectCallAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<BigInteger, Set<ResolvedFunction>> getResolvedAddresses() {
        Map<BigInteger, Set<ResolvedFunction>> map = this.resolvedAddresses;
        synchronized (map) {
            return new HashMap<BigInteger, Set<ResolvedFunction>>(this.resolvedAddresses);
        }
    }

    public ICallResolverTarget getTarget() {
        return this.target;
    }

    public void next() {
        switch (this.step) {
            case 0: {
                this.loadTargetModules();
                break;
            }
            case 1: {
                this.findIndirectCallAddresses();
                break;
            }
            case 3: {
                this.startDebugger();
                break;
            }
            case 2: {
                this.setBreakpoints();
                break;
            }
            case 4: {
                this.resolveBreakpoints();
                break;
            }
            case 5: {
                this.stopResolving();
                break;
            }
            case 6: {
                this.reset();
            }
        }
    }

    public void reset() {
        if (this.step != 6) {
            this.stopResolving();
        }
        this.resolvedAddresses.clear();
        this.resolvedFunctions.clear();
        this.hitCounter.clear();
        this.removedBreakpoints.clear();
        this.lastHits.clear();
        this.indirectCallAddresses = null;
        this.step = 0;
    }

    private class InternalTargetListener
    implements ICallResolverTargetListener {
        private InternalTargetListener() {
        }

        @Override
        public void changedDebugger(ICallResolverTarget iCallResolverTarget, Debugger debugger) {
            CallResolver.this.reset();
            CallResolver.this.debuggerChanged();
        }
    }

    private class InternalDebuggerListener
    extends DebuggerListenerAdapter {
        private InternalDebuggerListener() {
        }

        public void debuggerClosed(int n) {
            CallResolver.this.step = 5;
            CallResolver.this.stopResolving();
            CallResolver.this.debuggerClosed();
        }

        public void receivedBreakpointHitReply(int n, int n2, long l, RegisterValues registerValues) {
            if (CallResolver.this.step != 5) {
                return;
            }
            BigInteger bigInteger = CallResolver.this.getProgramCounter(l, registerValues);
            CallResolver.this.countHit(l, bigInteger);
            try {
                CallResolver.this.target.getDebugger().singleStep();
            }
            catch (DebugException debugException) {
                debugException.printStackTrace();
            }
        }

        public void receivedRequestTargetReply(int n, int n2) {
            if (n2 == 0) {
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        RemoteFileBrowserLoader remoteFileBrowserLoader = new RemoteFileBrowserLoader(CallResolver.this.parent, CallResolver.this.debugger);
                        if (!remoteFileBrowserLoader.load()) {
                            try {
                                CallResolver.this.debugger.cancelTargetSelection();
                            }
                            catch (DebugException debugException) {
                                CUtilityFunctions.logException((Throwable)debugException);
                            }
                        }
                    }
                });
            }
        }

        public void receivedSingleStepReply(int n, int n2, long l, Address address, RegisterValues registerValues) {
            if (CallResolver.this.step != 5) {
                return;
            }
            BigInteger bigInteger = CallResolver.this.getProgramCounter(l, registerValues);
            CallResolver.this.processCompleteSingleStep(l, bigInteger);
            try {
                CallResolver.this.debugger.resume();
            }
            catch (DebugException debugException) {
                debugException.printStackTrace();
            }
        }
    }
}

