/*
 * Decompiled with CFR 0.152.
 */
package com.zynamics.binnavi.standardplugins.callresolver;

import BinNavi.API.debug.Debugger;
import BinNavi.API.disassembly.IModuleListener;
import BinNavi.API.disassembly.Module;
import BinNavi.API.disassembly.ModuleListenerAdapter;
import BinNavi.API.disassembly.View;
import com.zynamics.binnavi.standardplugins.callresolver.ICallResolverTarget;
import com.zynamics.binnavi.standardplugins.callresolver.ICallResolverTargetListener;
import com.zynamics.binnavi.standardplugins.callresolver.IndirectCall;
import com.zynamics.binnavi.standardplugins.callresolver.IndirectCallFinder;
import java.util.ArrayList;
import java.util.List;

public final class ModuleCallResolverTarget
implements ICallResolverTarget {
    private final Module module;
    private final List<ICallResolverTargetListener> listeners = new ArrayList<ICallResolverTargetListener>();
    private final InternalModuleListener internalModuleListener = new InternalModuleListener();

    public ModuleCallResolverTarget(Module module) {
        this.module = module;
        module.addListener((IModuleListener)this.internalModuleListener);
    }

    @Override
    public void addListener(ICallResolverTargetListener iCallResolverTargetListener) {
        this.listeners.add(iCallResolverTargetListener);
    }

    @Override
    public View createView() {
        return this.module.createView("Dynamic Trace View", "");
    }

    @Override
    public Debugger getDebugger() {
        return this.module.getDebugger();
    }

    @Override
    public List<IndirectCall> getIndirectCalls() {
        return IndirectCallFinder.find(this.module);
    }

    @Override
    public List<Module> getModules() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        arrayList.add(this.module);
        return arrayList;
    }

    @Override
    public void removeListener(ICallResolverTargetListener iCallResolverTargetListener) {
        this.listeners.remove(iCallResolverTargetListener);
    }

    private class InternalModuleListener
    extends ModuleListenerAdapter {
        private InternalModuleListener() {
        }

        public void changedDebugger(Module module, Debugger debugger) {
            for (ICallResolverTargetListener iCallResolverTargetListener : ModuleCallResolverTarget.this.listeners) {
                try {
                    iCallResolverTargetListener.changedDebugger(ModuleCallResolverTarget.this, debugger);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

