/*
 * Decompiled with CFR 0.152.
 */
package com.zynamics.binnavi.standardplugins.callresolver;

import BinNavi.API.disassembly.Address;
import BinNavi.API.disassembly.Function;
import com.zynamics.binnavi.standardplugins.callresolver.ResolvedFunction;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class OutputListGenerator {
    private static List<Map.Entry<BigInteger, Set<ResolvedFunction>>> sort(Set<Map.Entry<BigInteger, Set<ResolvedFunction>>> set) {
        ArrayList<Map.Entry<BigInteger, Set<ResolvedFunction>>> arrayList = new ArrayList<Map.Entry<BigInteger, Set<ResolvedFunction>>>(set);
        Collections.sort(arrayList, new Comparator<Map.Entry<BigInteger, Set<ResolvedFunction>>>(){

            @Override
            public int compare(Map.Entry<BigInteger, Set<ResolvedFunction>> entry, Map.Entry<BigInteger, Set<ResolvedFunction>> entry2) {
                return entry.getKey().compareTo(entry2.getKey());
            }
        });
        return arrayList;
    }

    public static String generate(Map<BigInteger, Set<ResolvedFunction>> map) {
        assert (map != null);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Resolved the following indirect calls:\n");
        for (Map.Entry<BigInteger, Set<ResolvedFunction>> entry : OutputListGenerator.sort(map.entrySet())) {
            BigInteger bigInteger = entry.getKey();
            Set<ResolvedFunction> set = entry.getValue();
            stringBuffer.append(String.format("%08X ->\n", bigInteger.longValue()));
            for (ResolvedFunction resolvedFunction : set) {
                String string;
                Address address;
                Function function;
                if (resolvedFunction.getFunction() != null) {
                    function = resolvedFunction.getFunction();
                    address = function.getAddress();
                    string = function.getModule().getName() + "!" + function.getName();
                    stringBuffer.append(String.format("  %08X (%s)\n", address.toLong(), string));
                    continue;
                }
                if (resolvedFunction.getMemoryModule() != null) {
                    function = resolvedFunction.getMemoryModule();
                    address = resolvedFunction.getAddress();
                    string = function.getName() + "!???";
                    stringBuffer.append(String.format("  %08X (%s)\n", address.toLong(), string));
                    continue;
                }
                function = resolvedFunction.getAddress();
                stringBuffer.append(String.format("  %s (%s)\n", function.toHexString().toUpperCase(), "???!???"));
            }
        }
        return stringBuffer.toString();
    }
}

