/*
 * Decompiled with CFR 0.152.
 */
package com.zynamics.binnavi.standardplugins.coverage;

import BinNavi.API.debug.BreakpointManager;
import BinNavi.API.debug.DebugException;
import BinNavi.API.debug.Debugger;
import BinNavi.API.debug.IProcessListener;
import BinNavi.API.debug.IThreadListener;
import BinNavi.API.debug.Process;
import BinNavi.API.debug.ProcessListenerAdapter;
import BinNavi.API.debug.Thread;
import BinNavi.API.debug.ThreadListenerAdapter;
import BinNavi.API.disassembly.Address;
import BinNavi.API.disassembly.CodeNode;
import BinNavi.API.disassembly.FunctionNode;
import BinNavi.API.disassembly.View2D;
import BinNavi.API.disassembly.ViewNode;
import BinNavi.API.helpers.IProgressThread;
import BinNavi.API.helpers.MessageBox;
import BinNavi.API.helpers.ProgressDialog;
import com.zynamics.binnavi.standardplugins.coverage.IVisualCoverageListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;

public final class VisualCoverage {
    private static final Color COLOR_FEW_HITS = new Color(186, 255, 170);
    private static final Color COLOR_SEVERAL_HITS = new Color(147, 213, 255);
    private static final Color COLOR_MANY_HITS = new Color(255, 168, 191);
    private static final Color COLOR_CURRENT_HIT = Color.YELLOW;
    private final JFrame parent;
    private final Debugger debugger;
    private final View2D view2d;
    private final IProcessListener processListener = new InternalProcessListener();
    private final IThreadListener threadListener = new InternalThreadListener();
    private final List<Address> myBreakpoints = new ArrayList<Address>();
    private final Map<Address, Integer> breakpointCounter = new HashMap<Address, Integer>();
    private final Map<Address, ViewNode> nodeMap = new HashMap<Address, ViewNode>();
    private Address previousNodeAddress = null;
    private final List<IVisualCoverageListener> listeners = new ArrayList<IVisualCoverageListener>();

    public VisualCoverage(JFrame jFrame, Debugger debugger, View2D view2D) {
        this.parent = jFrame;
        this.debugger = debugger;
        this.view2d = view2D;
        ProgressDialog.show((Window)jFrame, (String)"Initializing graph and breakpoints ...", (IProgressThread)new StartupThread());
        debugger.getProcess().addListener(this.processListener);
        if (debugger.isConnected()) {
            this.setupListeners();
        }
    }

    private void finish() {
        this.updatePreviousNode();
        for (IVisualCoverageListener iVisualCoverageListener : new ArrayList<IVisualCoverageListener>(this.listeners)) {
            iVisualCoverageListener.finishedCoverage();
        }
    }

    private Address getAddress(ViewNode viewNode) {
        if (viewNode instanceof CodeNode) {
            return ((CodeNode)viewNode).getAddress();
        }
        if (viewNode instanceof FunctionNode) {
            return ((FunctionNode)viewNode).getFunction().getAddress();
        }
        throw new IllegalStateException("Error: Invalid node passed to getAddress");
    }

    private void removeListeners() {
        Process process = this.debugger.getProcess();
        process.removeListener(this.processListener);
        for (Thread thread : process.getThreads()) {
            try {
                thread.removeListener(this.threadListener);
            }
            catch (Exception exception) {}
        }
    }

    private void removeRemainingBreakpoints() {
        ProgressDialog.show((Window)this.parent, (String)"Removing remaining breakpoints ...", (IProgressThread)new CleanupThread());
    }

    private void setBreakpoint(Address address) {
        BreakpointManager breakpointManager = this.debugger.getBreakpointManager();
        if (!breakpointManager.hasBreakpoint(null, address)) {
            breakpointManager.setBreakpoint(null, address);
        }
    }

    private void setupListeners() {
        Process process = this.debugger.getProcess();
        for (Thread thread : process.getThreads()) {
            thread.addListener(this.threadListener);
        }
    }

    private void updatePreviousNode() {
        if (this.previousNodeAddress == null || !this.myBreakpoints.contains(this.previousNodeAddress)) {
            return;
        }
        ViewNode viewNode = this.nodeMap.get(this.previousNodeAddress);
        int n = this.breakpointCounter.get(this.previousNodeAddress);
        if (n < 5) {
            viewNode.setColor(COLOR_FEW_HITS);
        } else if (n < 10) {
            viewNode.setColor(COLOR_SEVERAL_HITS);
        } else {
            viewNode.setColor(COLOR_MANY_HITS);
            BreakpointManager breakpointManager = this.debugger.getBreakpointManager();
            if (breakpointManager.hasBreakpoint(null, this.previousNodeAddress)) {
                breakpointManager.removeBreakpoint(null, this.previousNodeAddress);
                this.myBreakpoints.remove(this.previousNodeAddress);
            }
        }
        try {
            java.lang.Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void addListener(IVisualCoverageListener iVisualCoverageListener) {
        this.listeners.add(iVisualCoverageListener);
    }

    public void dispose() {
        this.updatePreviousNode();
        this.removeRemainingBreakpoints();
        this.removeListeners();
    }

    public void removeListener(IVisualCoverageListener iVisualCoverageListener) {
        this.listeners.remove(iVisualCoverageListener);
    }

    private class StartupThread
    implements IProgressThread {
        private StartupThread() {
        }

        public boolean close() {
            return false;
        }

        public void run() {
            for (ViewNode viewNode : VisualCoverage.this.view2d.getView().getGraph()) {
                if (!(viewNode instanceof CodeNode) && !(viewNode instanceof FunctionNode)) continue;
                viewNode.setColor(Color.WHITE);
                Address address = VisualCoverage.this.getAddress(viewNode);
                VisualCoverage.this.setBreakpoint(address);
                VisualCoverage.this.myBreakpoints.add(address);
                VisualCoverage.this.breakpointCounter.put(address, 0);
                VisualCoverage.this.nodeMap.put(address, viewNode);
            }
        }
    }

    private class InternalThreadListener
    extends ThreadListenerAdapter {
        private InternalThreadListener() {
        }

        public void changedProgramCounter(Thread thread) {
            Address address = thread.getCurrentAddress();
            if (VisualCoverage.this.myBreakpoints.contains(address)) {
                VisualCoverage.this.breakpointCounter.put(address, (Integer)VisualCoverage.this.breakpointCounter.get(address) + 1);
                ViewNode viewNode = (ViewNode)VisualCoverage.this.nodeMap.get(address);
                viewNode.setColor(COLOR_CURRENT_HIT);
                VisualCoverage.this.updatePreviousNode();
                VisualCoverage.this.previousNodeAddress = address;
                if (VisualCoverage.this.myBreakpoints.isEmpty()) {
                    VisualCoverage.this.removeListeners();
                    VisualCoverage.this.finish();
                }
                try {
                    VisualCoverage.this.debugger.resume();
                }
                catch (DebugException debugException) {
                    MessageBox.showError((Component)VisualCoverage.this.parent, (String)"Could not resume the target process");
                }
            } else if (VisualCoverage.this.debugger.getBreakpointManager().hasBreakpoint(null, address)) {
                // empty if block
            }
        }
    }

    private class InternalProcessListener
    extends ProcessListenerAdapter {
        private InternalProcessListener() {
        }

        public void addedThread(Process process, Thread thread) {
            thread.addListener(VisualCoverage.this.threadListener);
        }

        public void attached(Process process) {
            VisualCoverage.this.setupListeners();
        }

        public void detached(Process process) {
            VisualCoverage.this.removeRemainingBreakpoints();
            VisualCoverage.this.removeListeners();
            VisualCoverage.this.finish();
        }

        public void removedThread(Process process, Thread thread) {
            thread.removeListener(VisualCoverage.this.threadListener);
        }
    }

    private class CleanupThread
    implements IProgressThread {
        private CleanupThread() {
        }

        public boolean close() {
            return false;
        }

        public void run() {
            BreakpointManager breakpointManager = VisualCoverage.this.debugger.getBreakpointManager();
            for (Address address : VisualCoverage.this.myBreakpoints) {
                if (!breakpointManager.hasBreakpoint(null, address)) continue;
                breakpointManager.removeBreakpoint(null, address);
            }
        }
    }
}

