/*
 * Decompiled with CFR 0.152.
 */
package com.zynamics.binnavi.standardplugins.criterium;

import BinNavi.API.disassembly.IGraphNode;
import BinNavi.API.disassembly.View2D;
import BinNavi.API.disassembly.ViewNode;
import BinNavi.API.helpers.GraphAlgorithms;
import BinNavi.API.plugins.ICriteriaSelectionPlugin;
import BinNavi.API.plugins.PluginInterface;
import javax.swing.JPanel;

public class LoopSelectionCriteriumPlugin
implements ICriteriaSelectionPlugin {
    public ICriteriaSelectionPlugin.ICriterium getCriterium(View2D view2D) {
        return new LoopCriterium();
    }

    public String getCriteriumDescription() {
        return "Select Nodes in loops";
    }

    public String getDescription() {
        return "Extends the Select by Criteria dialog to offer the option to select all nodes that are inside loops.";
    }

    public long getGuid() {
        return 423749054235790534L;
    }

    public String getName() {
        return "Loop Selection Plugin";
    }

    public void init(PluginInterface pluginInterface) {
    }

    public void unload() {
    }

    private static class LoopCriterium
    implements ICriteriaSelectionPlugin.ICriterium {
        private final JPanel m_panel = new JPanel();

        private LoopCriterium() {
        }

        public String getCriteriumDescription() {
            return "Select Nodes in loops";
        }

        public JPanel getCriteriumPanel() {
            return this.m_panel;
        }

        public ICriteriaSelectionPlugin.IFixedCriterium getFixedCriterium() {
            return new EmptyFixedCriterium();
        }

        public String getFormulaString() {
            return "in loop";
        }

        public boolean matches(ViewNode viewNode) {
            return GraphAlgorithms.getSuccessors((IGraphNode)viewNode).contains(viewNode);
        }
    }

    private static class EmptyFixedCriterium
    implements ICriteriaSelectionPlugin.IFixedCriterium {
        private EmptyFixedCriterium() {
        }

        public boolean matches(ViewNode viewNode) {
            return GraphAlgorithms.getSuccessors((IGraphNode)viewNode).contains(viewNode);
        }
    }
}

