/*
 * Decompiled with CFR 0.152.
 */
package com.zynamics.binnavi.standardplugins.pathfinder;

import BinNavi.API.disassembly.BasicBlock;
import BinNavi.API.disassembly.BlockEdge;
import BinNavi.API.disassembly.Callgraph;
import BinNavi.API.disassembly.CodeNode;
import BinNavi.API.disassembly.CouldntLoadDataException;
import BinNavi.API.disassembly.CouldntSaveDataException;
import BinNavi.API.disassembly.EdgeType;
import BinNavi.API.disassembly.FlowGraph;
import BinNavi.API.disassembly.Function;
import BinNavi.API.disassembly.FunctionBlock;
import BinNavi.API.disassembly.FunctionNode;
import BinNavi.API.disassembly.FunctionType;
import BinNavi.API.disassembly.IGraphNode;
import BinNavi.API.disassembly.Instruction;
import BinNavi.API.disassembly.Module;
import BinNavi.API.disassembly.Operand;
import BinNavi.API.disassembly.OperandExpression;
import BinNavi.API.disassembly.PartialLoadException;
import BinNavi.API.disassembly.Reference;
import BinNavi.API.disassembly.ReferenceType;
import BinNavi.API.disassembly.View;
import BinNavi.API.disassembly.ViewEdge;
import BinNavi.API.disassembly.ViewNode;
import BinNavi.API.helpers.GraphAlgorithms;
import BinNavi.API.helpers.Logger;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class PathFinder {
    private static final Color DEFAULT_BLOCK_COLOR = new Color(-68902);
    private static final Color DEFAULT_INLINING_EDGE_COLOR = new Color(-3360768);
    private static final Color DEFAULT_TRUE_JUMP_COLOR = new Color(-16736256);
    private static final Color DEFAULT_FALSE_JUMP_COLOR = new Color(-6291456);

    private static boolean callsFunction(Instruction instruction, Function function) {
        for (Operand operand : instruction.getOperands()) {
            OperandExpression operandExpression = operand.getRootNode();
            if (!PathFinder.hasFunctionCallReference(operandExpression, function)) continue;
            return true;
        }
        return false;
    }

    private static NodePair connectFunctions(View view, ViewNode viewNode, ViewNode viewNode2, Collection<FunctionBlock> collection, Map<Function, ViewNode> map, Map<Function, ViewNode> map2, Map<ViewNode, Function> map3) {
        boolean bl;
        ViewNode viewNode3 = viewNode;
        ViewNode viewNode4 = viewNode2;
        HashSet<Object> hashSet = new HashSet<Object>();
        block0: do {
            bl = false;
            for (ViewNode viewNode5 : view.getGraph().getNodes()) {
                if (hashSet.contains(viewNode5) || !(viewNode5 instanceof CodeNode)) continue;
                CodeNode codeNode = (CodeNode)viewNode5;
                for (Instruction instruction : codeNode.getInstructions()) {
                    for (FunctionBlock functionBlock : collection) {
                        Object object;
                        Function function;
                        Function function2 = functionBlock.getFunction();
                        if (!PathFinder.callsFunction(instruction, function2)) continue;
                        NodePair nodePair = PathFinder.splitBlock(view, map3.get(codeNode), codeNode, instruction);
                        if (viewNode3 == codeNode) {
                            viewNode3 = nodePair.getFirst();
                        }
                        if (viewNode4 == codeNode) {
                            viewNode4 = nodePair.getFirst();
                        }
                        for (FunctionBlock functionBlock2 : collection) {
                            function = functionBlock2.getFunction();
                            if (map.get(function) == codeNode) {
                                map.put(function, nodePair.getFirst());
                            }
                            if (map2.get(function) != codeNode) continue;
                            map2.put(function, nodePair.getSecond());
                        }
                        if (map3.containsKey(codeNode)) {
                            object = map3.get(codeNode);
                            map3.remove(codeNode);
                            map3.put(nodePair.getFirst(), (Function)object);
                        }
                        hashSet.add(nodePair.getFirst());
                        if (nodePair.getSecond() == null) {
                            for (FunctionBlock functionBlock2 : viewNode5.getOutgoingEdges()) {
                                function = view.createEdge(map2.get(function2), functionBlock2.getTarget(), EdgeType.LeaveInlinedFunction);
                                function.setColor(DEFAULT_INLINING_EDGE_COLOR);
                                view.deleteEdge((ViewEdge)functionBlock2);
                            }
                            object = view.createEdge(nodePair.getFirst(), map.get(function2), EdgeType.EnterInlinedFunction);
                            object.setColor(DEFAULT_INLINING_EDGE_COLOR);
                            hashSet.add(codeNode);
                        } else {
                            FunctionBlock functionBlock2;
                            object = view.createEdge(nodePair.getFirst(), map.get(function2), EdgeType.EnterInlinedFunction);
                            object.setColor(DEFAULT_INLINING_EDGE_COLOR);
                            functionBlock2 = view.createEdge(map2.get(function2), nodePair.getSecond(), EdgeType.LeaveInlinedFunction);
                            functionBlock2.setColor(DEFAULT_INLINING_EDGE_COLOR);
                        }
                        bl = true;
                        continue block0;
                    }
                }
                hashSet.add(codeNode);
            }
        } while (bl);
        return new NodePair(viewNode3, viewNode4);
    }

    private static void createInitialBlocks(View view, Collection<FunctionBlock> collection, Map<BasicBlock, ViewNode> map, Map<ViewNode, Function> map2) throws CouldntLoadDataException {
        for (FunctionBlock functionBlock : collection) {
            Function function = functionBlock.getFunction();
            if (function.getType() == FunctionType.Import) {
                FunctionNode functionNode = view.createFunctionNode(function);
                map2.put((ViewNode)functionNode, function);
                continue;
            }
            function.load();
            for (BasicBlock basicBlock : function.getGraph().getNodes()) {
                CodeNode codeNode = view.createCodeNode(function, basicBlock.getInstructions());
                codeNode.setColor(DEFAULT_BLOCK_COLOR);
                map.put(basicBlock, (ViewNode)codeNode);
                map2.put((ViewNode)codeNode, function);
            }
        }
    }

    private static void createInitialEdges(View view, Collection<FunctionBlock> collection, Map<BasicBlock, ViewNode> map) {
        for (FunctionBlock functionBlock : collection) {
            Function function = functionBlock.getFunction();
            for (BlockEdge blockEdge : function.getGraph().getEdges()) {
                ViewEdge viewEdge = view.createEdge(map.get(blockEdge.getSource()), map.get(blockEdge.getTarget()), blockEdge.getType());
                viewEdge.setColor(PathFinder.getEdgeColor(blockEdge));
            }
        }
    }

    private static void deleteNodesNotOnPath(View view, ViewNode viewNode, ViewNode viewNode2) {
        Set set = GraphAlgorithms.getSuccessors((IGraphNode)viewNode);
        Set set2 = GraphAlgorithms.getPredecessors((IGraphNode)viewNode2);
        HashSet<ViewNode> hashSet = new HashSet<ViewNode>(set);
        hashSet.retainAll(set2);
        hashSet.add(viewNode);
        hashSet.add(viewNode2);
        for (ViewNode viewNode3 : view.getGraph().getNodes()) {
            if (hashSet.contains(viewNode3)) continue;
            view.deleteNode(viewNode3);
        }
    }

    private static FunctionBlock findBlock(Callgraph callgraph, Function function) {
        for (FunctionBlock functionBlock : callgraph) {
            if (function != functionBlock.getFunction()) continue;
            return functionBlock;
        }
        throw new IllegalStateException("Error: Callgraph node of unknown function");
    }

    private static void findEntryExitNodes(Collection<FunctionBlock> collection, Map<BasicBlock, ViewNode> map, Map<ViewNode, Function> map2, Map<Function, ViewNode> map3, Map<Function, ViewNode> map4) {
        Function function;
        for (FunctionBlock object : collection) {
            function = object.getFunction();
            if (function.getType() == FunctionType.Import) continue;
            map3.put(function, map.get(PathFinder.findEntryNode(function.getGraph())));
            map4.put(function, map.get(PathFinder.findExitNode(function.getGraph())));
        }
        for (Map.Entry entry : map2.entrySet()) {
            function = (Function)entry.getValue();
            if (function.getType() != FunctionType.Import) continue;
            ViewNode viewNode = (ViewNode)entry.getKey();
            map3.put(function, viewNode);
            map4.put(function, viewNode);
        }
    }

    private static BasicBlock findEntryNode(FlowGraph flowGraph) {
        BasicBlock basicBlock = null;
        for (BasicBlock basicBlock2 : flowGraph) {
            if (basicBlock2.getParents().size() == 0) {
                return basicBlock2;
            }
            if (basicBlock != null && basicBlock2.getAddress().toLong() >= basicBlock.getAddress().toLong()) continue;
            basicBlock = basicBlock2;
        }
        return basicBlock;
    }

    private static BasicBlock findExitNode(FlowGraph flowGraph) {
        BasicBlock basicBlock = null;
        for (BasicBlock basicBlock2 : flowGraph) {
            if (basicBlock2.getChildren().size() == 0) {
                return basicBlock2;
            }
            if (basicBlock != null && basicBlock2.getAddress().toLong() <= basicBlock.getAddress().toLong()) continue;
            basicBlock = basicBlock2;
        }
        return basicBlock;
    }

    private static LinkedHashSet<FunctionBlock> findPassedFunctions(Callgraph callgraph, Function function, Function function2) {
        FunctionBlock functionBlock = PathFinder.findBlock(callgraph, function);
        FunctionBlock functionBlock2 = PathFinder.findBlock(callgraph, function2);
        Logger.info((String)"Source block: %s\n", (Object[])new Object[]{functionBlock.getFunction().getName()});
        Logger.info((String)"Target block: %s\n", (Object[])new Object[]{functionBlock2.getFunction().getName()});
        Set set = GraphAlgorithms.getSuccessors((IGraphNode)functionBlock);
        Set set2 = GraphAlgorithms.getPredecessors((IGraphNode)functionBlock2);
        LinkedHashSet<FunctionBlock> linkedHashSet = new LinkedHashSet<FunctionBlock>(set);
        linkedHashSet.retainAll(set2);
        linkedHashSet.add(functionBlock);
        linkedHashSet.add(functionBlock2);
        return linkedHashSet;
    }

    private static Color getEdgeColor(BlockEdge blockEdge) {
        switch (blockEdge.getType()) {
            case JumpConditionalTrue: {
                return DEFAULT_TRUE_JUMP_COLOR;
            }
            case JumpConditionalFalse: {
                return DEFAULT_FALSE_JUMP_COLOR;
            }
        }
        return Color.BLACK;
    }

    private static boolean hasFunctionCallReference(OperandExpression operandExpression, Function function) {
        List list = operandExpression.getReferences();
        for (Reference reference : list) {
            if (reference == null || !ReferenceType.isCodeReference((ReferenceType)reference.getType()) || !function.getAddress().equals((Object)reference.getTarget())) continue;
            return true;
        }
        for (Reference reference : operandExpression.getChildren()) {
            if (!PathFinder.hasFunctionCallReference((OperandExpression)reference, function)) continue;
            return true;
        }
        return false;
    }

    private static NodePair splitBlock(View view, Function function, CodeNode codeNode, Instruction instruction) {
        ViewEdge viewEdge;
        Instruction instruction22;
        boolean bl = true;
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        ArrayList<Instruction> arrayList2 = new ArrayList<Instruction>();
        for (Instruction instruction22 : codeNode.getInstructions()) {
            if (bl) {
                arrayList.add(instruction22);
            } else {
                arrayList2.add(instruction22);
            }
            if (instruction22 != instruction) continue;
            bl = false;
        }
        if (arrayList2.isEmpty()) {
            return new NodePair((ViewNode)codeNode, null);
        }
        CodeNode codeNode2 = view.createCodeNode(function, arrayList);
        instruction22 = view.createCodeNode(function, arrayList2);
        codeNode2.setColor(codeNode.getColor());
        instruction22.setColor(DEFAULT_BLOCK_COLOR);
        for (ViewEdge viewEdge2 : codeNode.getIncomingEdges()) {
            viewEdge = view.createEdge(viewEdge2.getSource(), (ViewNode)codeNode2, viewEdge2.getType());
            viewEdge.setColor(viewEdge2.getColor());
        }
        for (ViewEdge viewEdge2 : codeNode.getOutgoingEdges()) {
            viewEdge = view.createEdge((ViewNode)instruction22, viewEdge2.getTarget(), viewEdge2.getType());
            viewEdge.setColor(viewEdge2.getColor());
        }
        view.deleteNode((ViewNode)codeNode);
        return new NodePair((ViewNode)codeNode2, (ViewNode)instruction22);
    }

    public static View createPath(Module module, BasicBlock basicBlock, BasicBlock basicBlock2, Function function, Function function2) throws CouldntLoadDataException, PartialLoadException {
        if (module == null) {
            throw new IllegalArgumentException("Error: Module argument can't be null");
        }
        if (!module.isLoaded()) {
            throw new IllegalArgumentException("Error: Module is not loaded");
        }
        if (basicBlock == null && function == null) {
            throw new IllegalArgumentException("Error: No valid start given");
        }
        if (basicBlock2 == null && function2 == null) {
            throw new IllegalArgumentException("Error: No valid target given");
        }
        if (function != null && !function.isLoaded()) {
            throw new IllegalArgumentException("Error: Start function is not loaded");
        }
        if (function2 != null && !function2.isLoaded()) {
            throw new IllegalArgumentException("Error: Target function is not loaded");
        }
        Function function3 = function != null ? function : basicBlock.getParentFunction();
        Function function4 = function2 != null ? function2 : basicBlock2.getParentFunction();
        FlowGraph flowGraph = function3.getGraph();
        FlowGraph flowGraph2 = function4.getGraph();
        if (flowGraph.nodeCount() == 0) {
            throw new IllegalArgumentException("Error: Functions with zero nodes can not be used for pathfinding");
        }
        BasicBlock basicBlock3 = basicBlock != null ? basicBlock : PathFinder.findEntryNode(flowGraph);
        BasicBlock basicBlock4 = basicBlock2 != null ? basicBlock2 : PathFinder.findEntryNode(flowGraph2);
        LinkedHashSet<FunctionBlock> linkedHashSet = PathFinder.findPassedFunctions(module.getCallgraph(), function3, function4);
        String string = basicBlock4 != null ? basicBlock4.getAddress().toHexString() : function4.getAddress().toHexString();
        View view = module.createView("New Pathfinder View", String.format("%s -> %s", basicBlock3.getAddress().toHexString(), string));
        view.load();
        HashMap<BasicBlock, ViewNode> hashMap = new HashMap<BasicBlock, ViewNode>();
        HashMap<Function, ViewNode> hashMap2 = new HashMap<Function, ViewNode>();
        HashMap<Function, ViewNode> hashMap3 = new HashMap<Function, ViewNode>();
        HashMap<ViewNode, Function> hashMap4 = new HashMap<ViewNode, Function>();
        PathFinder.createInitialBlocks(view, linkedHashSet, hashMap, hashMap4);
        PathFinder.createInitialEdges(view, linkedHashSet, hashMap);
        PathFinder.findEntryExitNodes(linkedHashSet, hashMap, hashMap4, hashMap2, hashMap3);
        ViewNode viewNode = (ViewNode)hashMap.get(basicBlock3);
        ViewNode viewNode2 = basicBlock4 == null ? (ViewNode)hashMap2.get(function4) : (ViewNode)hashMap.get(basicBlock4);
        viewNode.setColor(Color.GREEN);
        viewNode2.setColor(Color.YELLOW);
        NodePair nodePair = PathFinder.connectFunctions(view, viewNode, viewNode2, linkedHashSet, hashMap2, hashMap3, hashMap4);
        viewNode = nodePair.getFirst();
        viewNode2 = nodePair.getSecond();
        for (ViewEdge viewEdge : viewNode2.getOutgoingEdges()) {
            view.deleteEdge(viewEdge);
        }
        PathFinder.deleteNodesNotOnPath(view, viewNode, viewNode2);
        if (viewNode.getOutgoingEdges().isEmpty()) {
            return null;
        }
        try {
            view.save();
        }
        catch (CouldntSaveDataException couldntSaveDataException) {
            couldntSaveDataException.printStackTrace();
        }
        return view;
    }

    private static class NodePair {
        private final ViewNode m_first;
        private final ViewNode m_second;

        public NodePair(ViewNode viewNode, ViewNode viewNode2) {
            this.m_first = viewNode;
            this.m_second = viewNode2;
        }

        public ViewNode getFirst() {
            return this.m_first;
        }

        public ViewNode getSecond() {
            return this.m_second;
        }
    }
}

