/*
 * Decompiled with CFR 0.152.
 */
package com.zynamics.binnavi.standardplugins.pathfinder;

import BinNavi.API.disassembly.BasicBlock;
import BinNavi.API.disassembly.CouldntLoadDataException;
import BinNavi.API.disassembly.Function;
import BinNavi.API.disassembly.IModuleListener;
import BinNavi.API.disassembly.Module;
import BinNavi.API.disassembly.ModuleListenerAdapter;
import BinNavi.API.disassembly.View;
import BinNavi.API.helpers.IProgressThread;
import BinNavi.API.helpers.Logger;
import BinNavi.API.helpers.MessageBox;
import BinNavi.API.helpers.ProgressDialog;
import BinNavi.API.plugins.IModuleMenuPlugin;
import BinNavi.API.plugins.PluginInterface;
import com.zynamics.binnavi.standardplugins.pathfinder.PathFinder;
import com.zynamics.binnavi.standardplugins.pathfinder.PathfindingDialog;
import com.zynamics.binnavi.standardplugins.utils.GuiHelper;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public final class PathfinderPlugin
implements IModuleMenuPlugin {
    private PluginInterface m_pluginInterface;

    private void showPathfindingDialog(Module module) {
        assert (module.isLoaded()) : "Internal Error: Target module is not loaded";
        PathfindingDialog pathfindingDialog = new PathfindingDialog(this.m_pluginInterface.getMainWindow().getFrame(), module);
        GuiHelper.centerChildToParent(this.m_pluginInterface.getMainWindow().getFrame(), pathfindingDialog, true);
        pathfindingDialog.setVisible(true);
        if (pathfindingDialog.wasCancelled()) {
            return;
        }
        BasicBlock basicBlock = pathfindingDialog.getStartBlock();
        BasicBlock basicBlock2 = pathfindingDialog.getEndBlock();
        Function function = pathfindingDialog.getStartFunction();
        Function function2 = pathfindingDialog.getEndFunction();
        final CreationThread creationThread = new CreationThread(module, basicBlock, basicBlock2, function, function2);
        ProgressDialog.show((Window)this.m_pluginInterface.getMainWindow().getFrame(), (String)"Creating path ...", (IProgressThread)creationThread);
        if (!creationThread.threwException() && creationThread.getCreatedView() == null) {
            MessageBox.showInformation((Component)this.m_pluginInterface.getMainWindow().getFrame(), (String)"There is no path between the two selected blocks");
        } else {
            new Thread(){

                @Override
                public void run() {
                    PluginInterface.instance().showInNewWindow(creationThread.getCreatedView());
                }
            }.start();
        }
    }

    public List<JComponent> extendModuleMenu(List<Module> list) {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        if (list.size() == 1) {
            Module module = list.get(0);
            arrayList.add(new JMenuItem(new PathfindingAction(module)));
        }
        return arrayList;
    }

    public String getDescription() {
        return "Finds paths between basic blocks of an executable";
    }

    public long getGuid() {
        return 4523525670943L;
    }

    public String getName() {
        return "Pathfinding Plugin";
    }

    public void init(PluginInterface pluginInterface) {
        this.m_pluginInterface = pluginInterface;
    }

    public void unload() {
    }

    private class PathfindingAction
    extends AbstractAction {
        private static final long serialVersionUID = 6818235709619366218L;
        private final Module m_module;
        private final ActionUpdater m_updater;

        public PathfindingAction(Module module) {
            super("Pathfinder");
            this.m_updater = new ActionUpdater(this);
            this.m_module = module;
            this.setEnabled(module.isLoaded());
            this.m_module.addListener((IModuleListener)this.m_updater);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PathfinderPlugin.this.showPathfindingDialog(this.m_module);
        }
    }

    private class CreationThread
    implements IProgressThread {
        private final Module module;
        private final BasicBlock sourceBlock;
        private final BasicBlock targetBlock;
        private final Function firstFunction;
        private final Function secondFunction;
        private View view;
        private boolean threwException = true;

        public CreationThread(Module module, BasicBlock basicBlock, BasicBlock basicBlock2, Function function, Function function2) {
            this.module = module;
            this.sourceBlock = basicBlock;
            this.targetBlock = basicBlock2;
            this.firstFunction = function;
            this.secondFunction = function2;
        }

        public boolean close() {
            return false;
        }

        public View getCreatedView() {
            return this.view;
        }

        public void run() {
            try {
                this.view = PathFinder.createPath(this.module, this.sourceBlock, this.targetBlock, this.firstFunction, this.secondFunction);
                this.threwException = false;
            }
            catch (CouldntLoadDataException couldntLoadDataException) {
                Logger.logException((Exception)((Object)couldntLoadDataException));
                MessageBox.showException((Component)PathfinderPlugin.this.m_pluginInterface.getMainWindow().getFrame(), (Exception)((Object)couldntLoadDataException), (String)"Could not create path");
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
                MessageBox.showException((Component)PathfinderPlugin.this.m_pluginInterface.getMainWindow().getFrame(), (Exception)exception, (String)"Could not create path");
            }
        }

        public boolean threwException() {
            return this.threwException;
        }
    }

    private static class ActionUpdater
    extends ModuleListenerAdapter {
        private final AbstractAction m_action;

        public ActionUpdater(AbstractAction abstractAction) {
            this.m_action = abstractAction;
        }

        public void loadedModule(Module module) {
            this.m_action.setEnabled(true);
        }
    }
}

