/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Arrays;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class MultiOperandInstr
extends Instr {
    private boolean constArgs = false;
    private IRubyObject[] preparedArgs = null;

    public MultiOperandInstr(Operation opType, Variable result) {
        super(opType, result);
    }

    public String toString() {
        return super.toString() + Arrays.toString(this.getOperands());
    }

    public Operand[] cloneOperandsForInlining(InlinerInfo ii) {
        Operand[] oldArgs = this.getOperands();
        Operand[] newArgs = new Operand[oldArgs.length];
        for (int i2 = 0; i2 < oldArgs.length; ++i2) {
            newArgs[i2] = oldArgs[i2].cloneForInlining(ii);
        }
        return newArgs;
    }

    protected IRubyObject[] prepareArguments(Operand[] args2, InterpreterContext interp) {
        int i2;
        if (this.preparedArgs == null) {
            this.preparedArgs = new IRubyObject[args2.length];
            this.constArgs = true;
            for (i2 = 0; i2 < args2.length; ++i2) {
                if (!args2[i2].isConstant()) {
                    this.constArgs = false;
                    break;
                }
                this.preparedArgs[i2] = (IRubyObject)args2[i2].retrieve(interp);
            }
        }
        if (!this.constArgs) {
            for (i2 = 0; i2 < args2.length; ++i2) {
                this.preparedArgs[i2] = (IRubyObject)args2[i2].retrieve(interp);
            }
        }
        return this.preparedArgs;
    }
}

