/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.FreedMemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::MemoryPointer"}, parent="FFI::Pointer")
public final class MemoryPointer
extends Pointer {
    public static RubyClass createMemoryPointerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("MemoryPointer", module.fastGetClass("Pointer"), MemoryPointerAllocator.INSTANCE);
        result.defineAnnotatedMethods(MemoryPointer.class);
        result.defineAnnotatedConstants(MemoryPointer.class);
        return result;
    }

    private MemoryPointer(Ruby runtime2, IRubyObject klass) {
        super(runtime2, (RubyClass)klass);
    }

    private MemoryPointer(Ruby runtime2, IRubyObject klass, DirectMemoryIO io2, long total2, int typeSize) {
        super(runtime2, (RubyClass)klass, io2, total2, typeSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IRubyObject init(ThreadContext context, IRubyObject rbTypeSize, int count2, int align, boolean clear2, Block block) {
        this.typeSize = MemoryPointer.calculateTypeSize(context, rbTypeSize);
        this.size = this.typeSize * count2;
        if (this.size < 0L) {
            throw context.getRuntime().newArgumentError(String.format("Negative size (%d objects of %d size)", count2, this.typeSize));
        }
        this.setMemoryIO(Factory.getInstance().allocateDirectMemory(context.getRuntime(), this.size > 0L ? (int)this.size : 1, align, clear2));
        if (this.getMemoryIO() == null) {
            Ruby runtime2 = context.getRuntime();
            throw new RaiseException(runtime2, runtime2.getNoMemoryError(), String.format("Failed to allocate %d objects of %d bytes", this.typeSize, count2), true);
        }
        if (block.isGiven()) {
            IRubyObject iRubyObject;
            try {
                iRubyObject = block.yield(context, this);
                Object var9_9 = null;
                ((AllocatedDirectMemoryIO)this.getMemoryIO()).free();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                ((AllocatedDirectMemoryIO)this.getMemoryIO()).free();
                this.setMemoryIO(new FreedMemoryIO(context.getRuntime()));
                throw throwable;
            }
            this.setMemoryIO(new FreedMemoryIO(context.getRuntime()));
            return iRubyObject;
        }
        return this;
    }

    static final MemoryPointer allocate(Ruby runtime2, int typeSize, int count2, boolean clear2) {
        int total2 = typeSize * count2;
        AllocatedDirectMemoryIO io2 = Factory.getInstance().allocateDirectMemory(runtime2, total2 > 0 ? total2 : 1, clear2);
        if (io2 == null) {
            throw new RaiseException(runtime2, runtime2.getNoMemoryError(), String.format("Failed to allocate %d objects of %d bytes", typeSize, count2), true);
        }
        return new MemoryPointer(runtime2, (IRubyObject)runtime2.fastGetModule("FFI").fastGetClass("MemoryPointer"), (DirectMemoryIO)io2, (long)total2, typeSize);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, Block block) {
        return sizeArg instanceof RubyFixnum ? this.init(context, RubyFixnum.one(context.getRuntime()), RubyFixnum.fix2int(sizeArg), 1, true, block) : this.init(context, sizeArg, 1, 1, true, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, IRubyObject count2, Block block) {
        return this.init(context, sizeArg, RubyNumeric.fix2int(count2), 1, true, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, IRubyObject count2, IRubyObject clear2, Block block) {
        return this.init(context, sizeArg, RubyNumeric.fix2int(count2), 1, clear2.isTrue(), block);
    }

    public final String toString() {
        return String.format("MemoryPointer[address=%#x, size=%d]", this.getAddress(), this.size);
    }

    @JRubyMethod(name={"free"})
    public final IRubyObject free(ThreadContext context) {
        ((AllocatedDirectMemoryIO)this.getMemoryIO()).free();
        this.setMemoryIO(new FreedMemoryIO(context.getRuntime()));
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"autorelease="}, required=1)
    public final IRubyObject autorelease(ThreadContext context, IRubyObject release) {
        ((AllocatedDirectMemoryIO)this.getMemoryIO()).setAutoRelease(release.isTrue());
        return context.getRuntime().getNil();
    }

    private static final class MemoryPointerAllocator
    implements ObjectAllocator {
        static final ObjectAllocator INSTANCE = new MemoryPointerAllocator();

        private MemoryPointerAllocator() {
        }

        public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
            return new MemoryPointer(runtime2, (IRubyObject)klazz);
        }
    }
}

