/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.util.Iterator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.profile.AbstractProfilePrinter;
import org.jruby.runtime.profile.IProfileData;
import org.jruby.runtime.profile.Invocation;

public class ProfileData
implements IProfileData {
    private Invocation currentInvocation;
    private Invocation topInvocation;
    private int[] methodRecursion;
    private ThreadContext threadContext;

    public ProfileData(ThreadContext tc) {
        this.topInvocation = this.currentInvocation = new Invocation(0);
        this.methodRecursion = new int[1000];
        this.threadContext = tc;
    }

    public int profileEnter(int calledMethod) {
        Invocation parentInvocation = this.currentInvocation;
        Invocation childInvocation = parentInvocation.childInvocationFor(calledMethod);
        childInvocation.incrementCount();
        this.currentInvocation = childInvocation;
        return parentInvocation.getMethodSerialNumber();
    }

    public int profileExit(int callingMethod, long startTime) {
        long now = System.nanoTime();
        long duration = now - startTime;
        int oldSerial = this.currentInvocation.getMethodSerialNumber();
        this.currentInvocation.addDuration(duration);
        if (this.currentInvocation == this.topInvocation) {
            Invocation newTopInvocation = new Invocation(0);
            Invocation newCurrentInvocation = this.currentInvocation.copyWithNewSerialAndParent(callingMethod, newTopInvocation);
            newTopInvocation.addChild(newCurrentInvocation);
            newCurrentInvocation.incrementCount();
            this.topInvocation = newTopInvocation;
            this.currentInvocation = newCurrentInvocation;
            return oldSerial;
        }
        if (this.currentInvocation.getParent() == this.topInvocation && callingMethod != 0) {
            Invocation newTopInvocation = new Invocation(0);
            Invocation newCurrentInvocation = newTopInvocation.childInvocationFor(callingMethod);
            Invocation newChildInvocation = this.currentInvocation.copyWithNewSerialAndParent(this.currentInvocation.getMethodSerialNumber(), newCurrentInvocation);
            newCurrentInvocation.addChild(newChildInvocation);
            newCurrentInvocation.incrementCount();
            this.topInvocation = newTopInvocation;
            this.currentInvocation = newCurrentInvocation;
            return oldSerial;
        }
        this.currentInvocation = this.currentInvocation.getParent();
        return oldSerial;
    }

    public void clear() {
        this.methodRecursion = new int[1000];
        this.topInvocation = this.currentInvocation = new Invocation(0);
    }

    public void decRecursionFor(int serial) {
        this.ensureRecursionSize(serial);
        int[] mr = this.methodRecursion;
        mr[serial] = mr[serial] - 1;
    }

    public int incRecursionFor(int serial) {
        int inc;
        this.ensureRecursionSize(serial);
        int[] mr = this.methodRecursion;
        mr[serial] = inc = mr[serial] + 1;
        return inc;
    }

    private void ensureRecursionSize(int index2) {
        int[] mr = this.methodRecursion;
        int length2 = mr.length;
        if (length2 <= index2) {
            int[] newRecursion = new int[(int)((double)index2 * 1.5 + 1.0)];
            System.arraycopy(mr, 0, newRecursion, 0, length2);
            this.methodRecursion = newRecursion;
        }
    }

    private void setRecursiveDepths() {
        int topSerial = this.topInvocation.getMethodSerialNumber();
        int depth = this.incRecursionFor(topSerial);
        this.topInvocation.setRecursiveDepth(depth);
        this.setRecursiveDepths1(this.topInvocation);
    }

    private void setRecursiveDepths1(Invocation inv) {
        for (Invocation child : inv.getChildren().values()) {
            int childSerial = child.getMethodSerialNumber();
            int depth = this.incRecursionFor(childSerial);
            child.setRecursiveDepth(depth);
            this.setRecursiveDepths1(child);
            this.decRecursionFor(childSerial);
        }
    }

    public long totalTime() {
        return this.topInvocation.childTime();
    }

    public Invocation getTopInvocation() {
        return this.topInvocation;
    }

    public Invocation getResults() {
        this.setRecursiveDepths();
        if (this.topInvocation.getChildren().size() != 1) {
            return this.addDuration(this.topInvocation);
        }
        if (this.topInvocation.getChildren().size() == 1) {
            Invocation singleTopChild = null;
            Iterator<Invocation> i$ = this.topInvocation.getChildren().values().iterator();
            while (i$.hasNext()) {
                Invocation inv;
                singleTopChild = inv = i$.next();
            }
            String singleTopChildName = AbstractProfilePrinter.getMethodName(singleTopChild.getMethodSerialNumber());
            if (singleTopChildName.equals("JRuby::Profiler.profile")) {
                Object profiledCodeInvocation = null;
                for (Invocation inv : singleTopChild.getChildren().values()) {
                    if (!AbstractProfilePrinter.getMethodName(inv.getMethodSerialNumber()).equals("JRuby::Profiler.profiled_code")) continue;
                    return this.addDuration(inv.copyWithNewSerialAndParent(0, null));
                }
            }
        }
        return this.addDuration(this.topInvocation);
    }

    public Invocation addDuration(Invocation inv) {
        inv.setDuration(inv.childTime());
        return inv;
    }

    public Invocation getCurrentInvocation() {
        return this.currentInvocation;
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }
}

