/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jruby.RubyEncoding;
import org.jruby.RubyFile;
import org.jruby.ext.posix.JavaSecuredFile;
import org.jruby.platform.Platform;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dir {
    public static final boolean DOSISH = Platform.IS_WINDOWS;
    public static final boolean CASEFOLD_FILESYSTEM = DOSISH;
    public static final int FNM_NOESCAPE = 1;
    public static final int FNM_PATHNAME = 2;
    public static final int FNM_DOTMATCH = 4;
    public static final int FNM_CASEFOLD = 8;
    public static final int FNM_SYSCASE = CASEFOLD_FILESYSTEM ? 8 : 0;
    public static final int FNM_NOMATCH = 1;
    public static final int FNM_ERROR = 2;
    public static final byte[] EMPTY = new byte[0];
    public static final byte[] SLASH = new byte[]{47};
    public static final byte[] STAR = new byte[]{42};
    public static final byte[] DOUBLE_STAR = new byte[]{42, 42};
    public static final GlobFunc push_pattern = new GlobFunc(){

        public int call(byte[] ptr, int p2, int len, Object ary) {
            ((List)ary).add(new ByteList(ptr, p2, len));
            return 0;
        }
    };
    public static final GlobFunc glob_caller = new GlobFunc(){

        public int call(byte[] ptr, int p2, int len, Object ary) {
            GlobArgs args2 = (GlobArgs)ary;
            args2.c = p2;
            return args2.func.call(ptr, args2.c, len, args2.v);
        }
    };

    private static boolean isdirsep(byte c) {
        return DOSISH ? c == 92 || c == 47 : c == 47;
    }

    private static int rb_path_next(byte[] _s, int s2, int send2) {
        while (s2 < send2 && !Dir.isdirsep(_s[s2])) {
            ++s2;
        }
        return s2;
    }

    private static int fnmatch_helper(byte[] bytes2, int pstart, int pend, byte[] string2, int sstart, int send2, int flags) {
        boolean nocase;
        int s2 = sstart;
        int pat = pstart;
        boolean escape = (flags & 1) == 0;
        boolean pathname = (flags & 2) != 0;
        boolean period = (flags & 4) == 0;
        boolean bl = nocase = (flags & 8) != 0;
        block6: while (pat < pend) {
            char c = bytes2[pat++];
            switch (c) {
                case '?': {
                    if (s2 >= send2 || pathname && Dir.isdirsep(string2[s2]) || period && string2[s2] == 46 && (s2 == 0 || pathname && Dir.isdirsep(string2[s2 - 1]))) {
                        return 1;
                    }
                    ++s2;
                    continue block6;
                }
                case '*': {
                    while (pat < pend && (c = bytes2[pat++]) == '*') {
                    }
                    if (s2 < send2 && period && string2[s2] == 46 && (s2 == 0 || pathname && Dir.isdirsep(string2[s2 - 1]))) {
                        return 1;
                    }
                    if (pat > pend || pat == pend && c == '*') {
                        if (pathname && Dir.rb_path_next(string2, s2, send2) < send2) {
                            return 1;
                        }
                        return 0;
                    }
                    if (pathname && Dir.isdirsep((byte)c)) {
                        if ((s2 = Dir.rb_path_next(string2, s2, send2)) < send2) {
                            ++s2;
                            continue block6;
                        }
                        return 1;
                    }
                    char test2 = (char)((escape && c == '\\' && pat < pend ? bytes2[pat] : c) & 0xFF);
                    test2 = Character.toLowerCase(test2);
                    --pat;
                    while (s2 < send2) {
                        if ((c == '?' || c == '[' || Character.toLowerCase((char)string2[s2]) == test2) && Dir.fnmatch(bytes2, pat, pend, string2, s2, send2, flags | 4) == 0) {
                            return 0;
                        }
                        if (pathname && Dir.isdirsep(string2[s2])) break;
                        ++s2;
                    }
                    return 1;
                }
                case '[': {
                    if (s2 >= send2 || pathname && Dir.isdirsep(string2[s2]) || period && string2[s2] == 46 && (s2 == 0 || pathname && Dir.isdirsep(string2[s2 - 1]))) {
                        return 1;
                    }
                    if ((pat = Dir.range(bytes2, pat, pend, (char)(string2[s2] & 0xFF), flags)) == -1) {
                        return 1;
                    }
                    ++s2;
                    continue block6;
                }
                case '\\': {
                    if (!escape) break;
                    c = pat >= pend ? (char)'\\' : bytes2[pat++];
                }
            }
            if (s2 >= send2) {
                return 1;
            }
            if (!(DOSISH && pathname && Dir.isdirsep((byte)c) && Dir.isdirsep(string2[s2]) || !(nocase ? Character.toLowerCase(c) != Character.toLowerCase((char)string2[s2]) : c != (char)string2[s2]))) {
                return 1;
            }
            ++s2;
        }
        return s2 >= send2 ? 0 : 1;
    }

    public static int fnmatch(byte[] bytes2, int pstart, int pend, byte[] string2, int sstart, int send2, int flags) {
        boolean period = (flags & 4) == 0;
        boolean pathname = (flags & 2) != 0;
        int pat_pos = pstart;
        int str_pos = sstart;
        int ptmp = -1;
        int stmp = -1;
        if (pathname) {
            while (true) {
                int strSlashIdx;
                int patSlashIdx;
                if (Dir.isDoubleStarAndSlash(bytes2, pat_pos)) {
                    while (Dir.isDoubleStarAndSlash(bytes2, pat_pos += 3)) {
                    }
                    ptmp = pat_pos;
                    stmp = str_pos;
                }
                if (Dir.fnmatch_helper(bytes2, pat_pos, patSlashIdx = Dir.nextSlashIndex(bytes2, pat_pos, pend), string2, str_pos, strSlashIdx = Dir.nextSlashIndex(string2, str_pos, send2), flags) == 0) {
                    if (patSlashIdx < pend && strSlashIdx < send2) {
                        pat_pos = ++patSlashIdx;
                        str_pos = ++strSlashIdx;
                        continue;
                    }
                    if (patSlashIdx == pend && strSlashIdx == send2) {
                        return 0;
                    }
                }
                if (ptmp == -1 || stmp == -1 || period && string2[stmp] == 46 || (stmp = Dir.nextSlashIndex(string2, stmp, send2)) >= send2) break;
                pat_pos = ptmp;
                str_pos = ++stmp;
            }
            return 1;
        }
        return Dir.fnmatch_helper(bytes2, pstart, pend, string2, sstart, send2, flags);
    }

    private static boolean isDoubleStarAndSlash(byte[] bytes2, int pos2) {
        if (bytes2.length - pos2 <= 2) {
            return false;
        }
        return bytes2[pos2] == 42 && bytes2[pos2 + 1] == 42 && bytes2[pos2 + 2] == 47;
    }

    private static int nextSlashIndex(byte[] bytes2, int start2, int end2) {
        int idx;
        for (idx = start2; idx < end2 && idx < bytes2.length && bytes2[idx] != 47; ++idx) {
        }
        return idx;
    }

    public static int range(byte[] _pat, int pat, int pend, char test2, int flags) {
        boolean not;
        boolean ok = false;
        boolean nocase = (flags & 8) != 0;
        boolean escape = (flags & 1) == 0;
        boolean bl = not = _pat[pat] == 33 || _pat[pat] == 94;
        if (not) {
            ++pat;
        }
        if (nocase) {
            test2 = Character.toLowerCase(test2);
        }
        while (_pat[pat] != 93) {
            char cend;
            if (escape && _pat[pat] == 92) {
                ++pat;
            }
            if (pat >= pend) {
                return -1;
            }
            char cstart = cend = (char)(_pat[pat++] & 0xFF);
            if (_pat[pat] == 45 && _pat[pat + 1] != 93) {
                if (escape && _pat[++pat] == 92) {
                    ++pat;
                }
                if (pat >= pend) {
                    return -1;
                }
                cend = (char)(_pat[pat++] & 0xFF);
            }
            if (nocase) {
                if (Character.toLowerCase(cstart) > test2 || test2 > Character.toLowerCase(cend)) continue;
                ok = true;
                continue;
            }
            if (cstart > test2 || test2 > cend) continue;
            ok = true;
        }
        return ok == not ? -1 : pat + 1;
    }

    public static List<ByteList> push_glob(String cwd, ByteList globByteList, int flags) {
        ArrayList<ByteList> result = new ArrayList<ByteList>();
        if (globByteList.length() > 0) {
            Dir.push_braces(cwd, result, new GlobPattern(globByteList, flags));
        }
        return result;
    }

    private static int push_braces(String cwd, List<ByteList> result, GlobPattern pattern) {
        pattern.reset();
        int lbrace = pattern.indexOf((byte)123);
        int rbrace = pattern.findClosingIndexOf(lbrace);
        if (lbrace == -1 || rbrace == -1) {
            return Dir.push_globs(cwd, result, pattern);
        }
        ByteList buf = new ByteList(20);
        int i2 = lbrace;
        while (pattern.bytes[i2] != 125) {
            int middleRegionIndex;
            for (i2 = middleRegionIndex = i2 + 1; i2 < pattern.end && pattern.bytes[i2] != 125 && pattern.bytes[i2] != 44; ++i2) {
                if (pattern.bytes[i2] != 123) continue;
                i2 = pattern.findClosingIndexOf(i2);
            }
            buf.length(0);
            buf.append(pattern.bytes, pattern.begin, lbrace - pattern.begin);
            buf.append(pattern.bytes, middleRegionIndex, i2 - middleRegionIndex);
            buf.append(pattern.bytes, rbrace + 1, pattern.end - (rbrace + 1));
            int status2 = Dir.push_braces(cwd, result, new GlobPattern(buf.getUnsafeBytes(), buf.getBegin(), buf.getRealSize(), pattern.flags));
            if (status2 == 0) continue;
            return status2;
        }
        return 0;
    }

    private static int push_globs(String cwd, List<ByteList> ary, GlobPattern pattern) {
        pattern.flags |= FNM_SYSCASE;
        return Dir.glob_helper(cwd, pattern.bytes, pattern.begin, pattern.end, -1, pattern.flags, glob_caller, new GlobArgs(push_pattern, ary));
    }

    private static boolean has_magic(byte[] bytes2, int begin2, int end2, int flags) {
        boolean escape = (flags & 1) == 0;
        boolean nocase = (flags & 8) != 0;
        int open2 = 0;
        block6: for (int i2 = begin2; i2 < end2; ++i2) {
            switch (bytes2[i2]) {
                case 42: 
                case 63: {
                    return true;
                }
                case 91: {
                    ++open2;
                    continue block6;
                }
                case 93: {
                    if (open2 <= 0) continue block6;
                    return true;
                }
                case 92: {
                    if (!escape || i2 != end2) continue block6;
                    return false;
                }
                default: {
                    if (FNM_SYSCASE != 0 || !nocase || !Character.isLetter((char)(bytes2[i2] & 0xFF))) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    private static int remove_backslashes(byte[] bytes2, int index2, int len) {
        int t = index2;
        while (index2 < len && (bytes2[index2] != 92 || ++index2 != len)) {
            bytes2[t] = bytes2[index2];
            ++index2;
            ++t;
        }
        return t;
    }

    private static int strchr(byte[] bytes2, int begin2, int end2, byte ch) {
        for (int i2 = begin2; i2 < end2; ++i2) {
            if (bytes2[i2] != ch) continue;
            return i2;
        }
        return -1;
    }

    private static byte[] extract_path(byte[] bytes2, int begin2, int end2) {
        int len = end2 - begin2;
        if (!(len <= 1 || bytes2[end2 - 1] != 47 || DOSISH && len >= 2 && bytes2[end2 - 2] == 58)) {
            --len;
        }
        byte[] alloc2 = new byte[len];
        System.arraycopy(bytes2, begin2, alloc2, 0, len);
        return alloc2;
    }

    private static byte[] extract_elem(byte[] bytes2, int begin2, int end2) {
        int elementEnd = Dir.strchr(bytes2, begin2, end2, (byte)47);
        if (elementEnd == -1) {
            elementEnd = end2;
        }
        return Dir.extract_path(bytes2, begin2, elementEnd);
    }

    private static boolean BASE(byte[] base) {
        int length2 = base.length;
        return DOSISH ? !(length2 <= 0 || Dir.isdirsep(base[0]) && length2 < 2 || length2 > 2 && base[1] == 58 && Dir.isdirsep(base[2]) && length2 < 4) : length2 > 0 && (!Dir.isdirsep(base[0]) || length2 >= 2);
    }

    private static boolean isJarFilePath(byte[] bytes2, int begin2, int end2) {
        return end2 > 6 && bytes2[begin2] == 102 && bytes2[begin2 + 1] == 105 && bytes2[begin2 + 2] == 108 && bytes2[begin2 + 3] == 101 && bytes2[begin2 + 4] == 58;
    }

    private static boolean isAbsolutePath(byte[] path2, int begin2, int length2) {
        return path2[begin2] == 47 || DOSISH && begin2 + 2 < length2 && path2[begin2 + 1] == 58 && Dir.isdirsep(path2[begin2 + 2]);
    }

    private static String[] files(File directory) {
        String[] files = directory.list();
        if (files != null) {
            String[] filesPlusDotFiles = new String[files.length + 2];
            System.arraycopy(files, 0, filesPlusDotFiles, 2, files.length);
            filesPlusDotFiles[0] = ".";
            filesPlusDotFiles[1] = "..";
            return filesPlusDotFiles;
        }
        return new String[0];
    }

    private static int addToResultIfExists(String cwd, byte[] bytes2, int begin2, int end2, int flags, GlobFunc func, GlobArgs arg2) {
        JavaSecuredFile file2;
        String fileName = Dir.newStringFromUTF8(bytes2, begin2, end2 - begin2);
        JavaSecuredFile javaSecuredFile = file2 = cwd != null ? new JavaSecuredFile(cwd, fileName) : new JavaSecuredFile(fileName);
        if (file2.exists()) {
            if ((flags & 8) != 0) {
                try {
                    String realName = file2.getCanonicalFile().getName();
                    int newEnd = fileName.lastIndexOf(47);
                    if (newEnd != -1) {
                        realName = fileName.substring(0, newEnd + 1) + realName;
                    }
                    bytes2 = realName.getBytes();
                    begin2 = 0;
                    end2 = bytes2.length;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return func.call(bytes2, begin2, end2 - begin2, arg2);
        }
        return 0;
    }

    private static ZipEntry getZipEntryFor(byte[] bytes2, int begin2, int end2) {
        int ix = end2;
        for (int i2 = 0; i2 < end2; ++i2) {
            if (bytes2[begin2 + i2] != 33) continue;
            ix = i2;
            break;
        }
        JavaSecuredFile file2 = new JavaSecuredFile(Dir.newStringFromUTF8(bytes2, begin2 + 5, ix - 5));
        try {
            String jar = Dir.newStringFromUTF8(bytes2, begin2 + ix + 1, end2 - (ix + 1));
            JarFile jf = new JarFile(file2);
            if (jar.startsWith("/")) {
                jar = jar.substring(1);
            }
            return RubyFile.getDirOrFileEntry(jf, jar);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int glob_helper(String cwd, byte[] bytes2, int begin2, int end2, int sub3, int flags, GlobFunc func, GlobArgs arg2) {
        int p2;
        int status2 = 0;
        byte[] newpath = null;
        int n = p2 = sub3 != -1 ? sub3 : begin2;
        if (!Dir.has_magic(bytes2, p2, end2, flags)) {
            if (DOSISH || (flags & 1) == 0) {
                newpath = new byte[end2];
                System.arraycopy(bytes2, 0, newpath, 0, end2);
                if (sub3 != -1) {
                    p2 = sub3 - begin2;
                    end2 = Dir.remove_backslashes(newpath, p2, end2);
                    sub3 = p2;
                } else {
                    end2 = Dir.remove_backslashes(newpath, 0, end2);
                    bytes2 = newpath;
                }
            }
            if (Dir.isAbsolutePath(bytes2, begin2, end2)) {
                status2 = Dir.addToResultIfExists(null, bytes2, begin2, end2, flags, func, arg2);
            } else if (Dir.isJarFilePath(bytes2, begin2, end2)) {
                if (Dir.getZipEntryFor(bytes2, begin2, end2) != null) {
                    status2 = func.call(bytes2, begin2, end2, arg2);
                }
            } else if (end2 - begin2 > 0) {
                status2 = Dir.addToResultIfExists(cwd, bytes2, begin2, end2, flags, func, arg2);
            }
            return status2;
        }
        ByteList buf = new ByteList(20);
        ArrayList<DirGlobber> link2 = new ArrayList<DirGlobber>();
        while (p2 != -1 && status2 == 0) {
            int m;
            block45: {
                JavaSecuredFile st;
                block44: {
                    int i2;
                    JarFile jf;
                    String jar;
                    boolean recursive;
                    byte[] magic;
                    byte[] base;
                    block46: {
                        byte[] byArray;
                        if (bytes2[p2] == 47) {
                            ++p2;
                        }
                        if (!Dir.has_magic(bytes2, p2, (m = Dir.strchr(bytes2, p2, end2, (byte)47)) == -1 ? end2 : m, flags)) break block45;
                        base = Dir.extract_path(bytes2, begin2, p2);
                        if (begin2 == p2) {
                            byte[] byArray2 = new byte[1];
                            byArray = byArray2;
                            byArray2[0] = 46;
                        } else {
                            byArray = base;
                        }
                        byte[] dir = byArray;
                        magic = Dir.extract_elem(bytes2, p2, end2);
                        recursive = false;
                        jar = null;
                        jf = null;
                        if (Dir.isAbsolutePath(dir, 0, dir.length)) {
                            st = new JavaSecuredFile(Dir.newStringFromUTF8(dir));
                        } else if (Dir.isJarFilePath(dir, 0, dir.length)) {
                            int ix = dir.length;
                            for (i2 = 0; i2 < dir.length; ++i2) {
                                if (dir[i2] != 33) continue;
                                ix = i2;
                                break;
                            }
                            st = new JavaSecuredFile(Dir.newStringFromUTF8(dir, 5, ix - 5));
                            if (ix < dir.length) {
                                jar = Dir.newStringFromUTF8(dir, ix + 1, dir.length - (ix + 1));
                                try {
                                    jf = new JarFile(st);
                                    if (jar.startsWith("/")) {
                                        jar = jar.substring(1);
                                    }
                                    if (jf.getEntry(jar + "/") != null) {
                                        jar = jar + "/";
                                    }
                                }
                                catch (Exception e) {
                                    jar = null;
                                    jf = null;
                                }
                            }
                        } else {
                            st = new JavaSecuredFile(cwd, Dir.newStringFromUTF8(dir));
                        }
                        if ((jf == null || !"".equals(jar) && (jf.getJarEntry(jar) == null || !jf.getJarEntry(jar).isDirectory())) && !((File)st).isDirectory()) break;
                        if (m == -1 || !Arrays.equals(magic, DOUBLE_STAR)) break block46;
                        int n2 = base.length;
                        recursive = true;
                        buf.length(0);
                        buf.append(base);
                        buf.append(bytes2, base.length > 0 ? m : m + 1, end2 - (base.length > 0 ? m : m + 1));
                        if (jf != null) {
                            buf = Dir.fixBytesForJarInUTF8(buf.getUnsafeBytes(), buf.getBegin(), buf.getRealSize());
                        }
                        if ((status2 = Dir.glob_helper(cwd, buf.getUnsafeBytes(), buf.getBegin(), buf.getRealSize(), n2, flags, func, arg2)) != 0) break block44;
                    }
                    if (jar == null) {
                        String[] dirp = Dir.files(st);
                        for (i2 = 0; i2 < dirp.length; ++i2) {
                            byte[] bs;
                            if (recursive) {
                                bs = Dir.getBytesInUTF8(dirp[i2]);
                                if (Dir.fnmatch(STAR, 0, 1, bs, 0, bs.length, flags) != 0) continue;
                                buf.length(0);
                                buf.append(base);
                                buf.append(Dir.BASE(base) ? SLASH : EMPTY);
                                buf.append(Dir.getBytesInUTF8(dirp[i2]));
                                st = Dir.isAbsolutePath(buf.getUnsafeBytes(), buf.getBegin(), buf.getRealSize()) ? new JavaSecuredFile(Dir.newStringFromUTF8(buf.getUnsafeBytes(), buf.getBegin(), buf.getRealSize())) : new JavaSecuredFile(cwd, Dir.newStringFromUTF8(buf.getUnsafeBytes(), buf.getBegin(), buf.getRealSize()));
                                if (!((File)st).isDirectory() || ".".equals(dirp[i2]) || "..".equals(dirp[i2])) continue;
                                int t = buf.getRealSize();
                                buf.append(SLASH);
                                buf.append(DOUBLE_STAR);
                                buf.append(bytes2, m, end2 - m);
                                status2 = Dir.glob_helper(cwd, buf.getUnsafeBytes(), buf.getBegin(), buf.getRealSize(), t, flags, func, arg2);
                                if (status2 == 0) continue;
                                break;
                            }
                            bs = Dir.getBytesInUTF8(dirp[i2]);
                            if (Dir.fnmatch(magic, 0, magic.length, bs, 0, bs.length, flags) != 0) continue;
                            buf.length(0);
                            buf.append(base);
                            buf.append(Dir.BASE(base) ? SLASH : EMPTY);
                            buf.append(Dir.getBytesInUTF8(dirp[i2]));
                            if (m == -1) {
                                status2 = func.call(buf.getUnsafeBytes(), 0, buf.getRealSize(), arg2);
                                if (status2 == 0) continue;
                                break;
                            }
                            link2.add(new DirGlobber(buf, null));
                            buf = new ByteList(20);
                        }
                    } else {
                        try {
                            ArrayList<JarEntry> dirp = new ArrayList<JarEntry>();
                            Enumeration<JarEntry> eje = jf.entries();
                            while (eje.hasMoreElements()) {
                                JarEntry je = eje.nextElement();
                                String name2 = je.getName();
                                int ix = name2.indexOf(47, jar.length());
                                if (ix != -1 && ix != name2.length() - 1 || !"/".equals(jar) && (!name2.startsWith(jar) || name2.length() <= jar.length())) continue;
                                dirp.add(je);
                            }
                            for (JarEntry je : dirp) {
                                String basename2 = new File(je.getName()).getName();
                                byte[] bs = Dir.getBytesInUTF8(basename2);
                                byte[] absoluteName = Dir.getBytesInUTF8(je.getName());
                                int len = bs.length;
                                int absoluteLen = absoluteName.length;
                                if (je.isDirectory()) {
                                    --len;
                                    --absoluteLen;
                                }
                                if (recursive) {
                                    if (Dir.fnmatch(STAR, 0, 1, bs, 0, len, flags) != 0) continue;
                                    buf.length(0);
                                    buf.append(base, 0, base.length - jar.length());
                                    buf.append(Dir.BASE(base) ? SLASH : EMPTY);
                                    buf.append(absoluteName, 0, absoluteLen);
                                    if (!je.isDirectory()) continue;
                                    int t = buf.getRealSize();
                                    buf.append(SLASH);
                                    buf.append(DOUBLE_STAR);
                                    buf.append(bytes2, m, end2 - m);
                                    status2 = Dir.glob_helper(cwd, (buf = Dir.fixBytesForJarInUTF8(buf.getUnsafeBytes(), buf.getBegin(), buf.getRealSize())).getUnsafeBytes(), buf.getBegin(), buf.getRealSize(), t, flags, func, arg2);
                                    if (status2 == 0) continue;
                                }
                                if (Dir.fnmatch(magic, 0, magic.length, bs, 0, len, flags) != 0) continue;
                                buf.length(0);
                                buf.append(base, 0, base.length - jar.length());
                                buf.append(Dir.BASE(base) ? SLASH : EMPTY);
                                buf.append(absoluteName, 0, absoluteLen);
                                buf = Dir.fixBytesForJarInUTF8(buf.getUnsafeBytes(), 0, buf.getRealSize());
                                if (m == -1) {
                                    status2 = func.call(buf.getUnsafeBytes(), 0, buf.getRealSize(), arg2);
                                    if (status2 == 0) continue;
                                }
                                link2.add(new DirGlobber(buf, je));
                                buf = new ByteList(20);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (link2.size() > 0) {
                    for (DirGlobber globber : link2) {
                        ByteList b = globber.link;
                        if (status2 != 0 || !((File)(st = Dir.isAbsolutePath(b.getUnsafeBytes(), b.begin(), b.getRealSize()) ? new JavaSecuredFile(Dir.newStringFromUTF8(b.getUnsafeBytes(), 0, b.getRealSize())) : new JavaSecuredFile(cwd, Dir.newStringFromUTF8(b.getUnsafeBytes(), 0, b.getRealSize())))).isDirectory() && (globber.jarEntry == null || !globber.jarEntry.isDirectory())) continue;
                        int len = b.getRealSize();
                        buf.length(0);
                        buf.append(b);
                        buf.append(bytes2, m, end2 - m);
                        if (globber.jarEntry != null) {
                            buf = Dir.fixBytesForJarInUTF8(buf.getUnsafeBytes(), 0, buf.getRealSize());
                        }
                        status2 = Dir.glob_helper(cwd, buf.getUnsafeBytes(), 0, buf.getRealSize(), len, flags, func, arg2);
                    }
                    break;
                }
            }
            p2 = m;
        }
        return status2;
    }

    private static ByteList fixBytesForJarInUTF8(byte[] buf, int offset2, int len) {
        String path2 = Dir.newStringFromUTF8(buf, offset2, len);
        path2 = path2.replace(".jar/", ".jar!");
        return new ByteList(path2.getBytes());
    }

    private static byte[] getBytesInUTF8(String s2) {
        return RubyEncoding.encodeUTF8(s2);
    }

    private static String newStringFromUTF8(byte[] buf, int offset2, int len) {
        return RubyEncoding.decodeUTF8(buf, offset2, len);
    }

    private static String newStringFromUTF8(byte[] buf) {
        return RubyEncoding.decodeUTF8(buf);
    }

    private static final class DirGlobber {
        public final ByteList link;
        public final JarEntry jarEntry;

        public DirGlobber(ByteList link2, JarEntry jarEntry) {
            this.link = link2;
            this.jarEntry = jarEntry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GlobArgs {
        GlobFunc func;
        int c = -1;
        List<ByteList> v;

        public GlobArgs(GlobFunc func, List<ByteList> arg2) {
            this.func = func;
            this.v = arg2;
        }
    }

    public static interface GlobFunc {
        public int call(byte[] var1, int var2, int var3, Object var4);
    }

    private static class GlobPattern {
        final byte[] bytes;
        final int begin;
        final int end;
        int flags;
        int index;

        public GlobPattern(ByteList bytelist, int flags) {
            this(bytelist.getUnsafeBytes(), bytelist.getBegin(), bytelist.getBegin() + bytelist.getRealSize(), flags);
        }

        public GlobPattern(byte[] bytes2, int index2, int end2, int flags) {
            this.bytes = bytes2;
            this.index = index2;
            this.begin = index2;
            this.end = end2;
            this.flags = flags;
        }

        public int findClosingIndexOf(int leftTokenIndex) {
            byte rightToken;
            if (leftTokenIndex == -1 || leftTokenIndex > this.end) {
                return -1;
            }
            byte leftToken = this.bytes[leftTokenIndex];
            switch (leftToken) {
                case 123: {
                    rightToken = 125;
                    break;
                }
                case 91: {
                    rightToken = 93;
                    break;
                }
                default: {
                    return -1;
                }
            }
            int nest = 1;
            this.index = leftTokenIndex + 1;
            while (this.hasNext()) {
                byte c = this.next();
                if (c == leftToken) {
                    ++nest;
                    continue;
                }
                if (c != rightToken || --nest != 0) continue;
                return this.index();
            }
            return -1;
        }

        public boolean hasNext() {
            return this.index < this.end;
        }

        public void reset() {
            this.index = this.begin;
        }

        public void setIndex(int value2) {
            this.index = value2;
        }

        public int index() {
            return this.index - 1;
        }

        public int indexOf(byte c) {
            while (this.hasNext()) {
                if (this.next() != c) continue;
                return this.index();
            }
            return -1;
        }

        public byte next() {
            return this.bytes[this.index++];
        }
    }
}

