/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder;

import BinNavi.API.disassembly.Address;
import BinNavi.API.disassembly.BasicBlock;
import BinNavi.API.disassembly.CouldntLoadDataException;
import BinNavi.API.disassembly.Function;
import BinNavi.API.disassembly.Instruction;
import BinNavi.API.disassembly.Module;
import BinNavi.API.disassembly.ModuleHelpers;
import BinNavi.API.helpers.IProgressThread;
import BinNavi.API.helpers.MessageBox;
import BinNavi.API.helpers.ProgressDialog;
import binnavi.plugins.gadgetfinder.CreationThread;
import binnavi.plugins.gadgetfinder.algorithms.GadgetLocator;
import binnavi.plugins.gadgetfinder.algorithms.OperandTreeMinimizer;
import binnavi.plugins.gadgetfinder.algorithms.PathOperandTreeMerger;
import binnavi.plugins.gadgetfinder.algorithms.helpers.OperandTreeMapCollector;
import binnavi.plugins.gadgetfinder.algorithms.helpers.PathCollector;
import binnavi.plugins.gadgetfinder.database.DatabaseHelper;
import binnavi.plugins.gadgetfinder.datastructures.enums.GadgetType;
import binnavi.plugins.gadgetfinder.datastructures.helpers.AddressOperandTreeMapHelper;
import binnavi.plugins.gadgetfinder.datastructures.helpers.GadgetTypeOperandTreeMapHelper;
import binnavi.plugins.gadgetfinder.datastructures.helpers.OperandTreeMapHelper;
import binnavi.plugins.gadgetfinder.datastructures.list.PathOperandTreeMapList;
import binnavi.plugins.gadgetfinder.datastructures.maps.AddressBlocksPathMap;
import binnavi.plugins.gadgetfinder.datastructures.maps.AddressOperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.maps.GadgetTypeOperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.maps.OperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.maps.PathOperandTreeMap;
import binnavi.plugins.gadgetfinder.gui.GadgetfindingDialog;
import binnavi.plugins.gadgetfinder.gui.GuiHelper;
import binnavi.plugins.gadgetfinder.helper.GadgetLogger;
import binnavi.plugins.gadgetfinder.helper.SerializationHelper;
import binnavi.plugins.gadgetfinder.helper.Triple;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JFrame;

public class GadgetFinder {
    public static void findGadgets(Module module) throws FileNotFoundException {
        try {
            System.setOut(new PrintStream(new BufferedOutputStream(new FileOutputStream("gadget.log"))));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            GadgetLogger.setup(module.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        GadgetLogger.writeLog(GadgetType.EMPTY, "testing the logging");
        String moduleName = module.getName();
        String moduleID = DatabaseHelper.getModuleID(module);
        System.out.println("[i] MODULE ID: " + moduleID + " MODULE NAME: " + moduleName);
        String architecture = DatabaseHelper.getArchitecture(module, moduleID);
        System.out.println("[i] timer starting");
        long time_prev = System.currentTimeMillis();
        PathOperandTreeMapList pathOperandTreeMapList = SerializationHelper.restorePathOperandTreeMapListFromDisk(module);
        if (pathOperandTreeMapList != null) {
            System.out.println("[i] using restored information from disk as base for analysis. ");
        } else {
            System.out.println("[i] extracting information from database as base for analysis. ");
            LinkedHashSet<Long> addressHashSet = null;
            if (architecture.equalsIgnoreCase("ARM-32")) {
                addressHashSet = DatabaseHelper.getPCChangingAddressesARM(module, moduleID);
            } else if (architecture.equalsIgnoreCase("MIPS-32")) {
                addressHashSet = DatabaseHelper.getPCChangingAddressesMIPS(module, moduleID);
            } else if (architecture.equalsIgnoreCase("PowerPC-32")) {
                addressHashSet = DatabaseHelper.getPCChangingAddressesPPC(module, moduleID);
            } else {
                System.out.println("[E] found no suitable function to get free-branch instructions.");
                return;
            }
            System.out.println("[i] initial sql querry took " + (System.currentTimeMillis() - time_prev) + "ms");
            pathOperandTreeMapList = new PathOperandTreeMapList();
            long count = 0L;
            for (Long address : addressHashSet) {
                System.out.println("COUNT" + count);
                System.out.println("[i] ADDRESS IN SEARCH: " + Long.toHexString(address));
                List<Long> functionID = DatabaseHelper.getFunctionID(module, moduleID, address);
                for (Long l : functionID) {
                    System.out.println("[i] FUNCTION IN SEARCH: " + Long.toHexString(l));
                    if (l.equals(new Long(0L))) continue;
                    Function function = ModuleHelpers.getFunction((Module)module, (Address)new Address(l.longValue()));
                    try {
                        function.load();
                    }
                    catch (CouldntLoadDataException e1) {
                        System.out.println("[!] function load failed ");
                        e1.printStackTrace();
                        continue;
                    }
                    System.out.println("[i] FUNCTION IS LOADED");
                    pathOperandTreeMapList.add(GadgetFinder.generateOperandTreesAndMergeInSingleFunction(function, address, addressHashSet));
                    function.close();
                    count += (long)pathOperandTreeMapList.get(pathOperandTreeMapList.size() - 1).size();
                    System.out.flush();
                }
            }
            System.out.println("[i] paths found usefull for gadgets : " + count);
        }
        GadgetTypeOperandTreeMap gadgetTypeOperandTreeMap = GadgetLocator.locateGadgets(pathOperandTreeMapList);
        System.out.println("[i] " + gadgetTypeOperandTreeMap.size() + " gadgets found in library");
        GadgetType[] gadgetTypeArray = GadgetType.values();
        int n = gadgetTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GadgetType gadgetType = gadgetTypeArray[n2];
            System.out.println("[i] gadget type: " + (Object)((Object)gadgetType) + " has " + gadgetTypeOperandTreeMap.getNumberOfGadgetsForSpecificType(gadgetType) + " candidates ");
            for (Triple<GadgetType, String, Address> gadgetTriple : gadgetTypeOperandTreeMap.keySet()) {
                if (!gadgetTriple.first().equals((Object)gadgetType)) continue;
                GadgetLogger.writeLog(gadgetType, "[i] gadget type: " + (Object)((Object)gadgetType) + " @ " + gadgetTriple.third() + "\n");
                System.out.println("[i] gadget type: " + (Object)((Object)gadgetType) + " @ " + gadgetTriple.third());
                GadgetLogger.writeLog(gadgetType, "[i] Type: " + (Object)((Object)gadgetTriple.first()) + " Address: " + gadgetTriple.second() + " String: " + gadgetTriple.third() + "\n");
                OperandTreeMap currentGadgetOperandTreeMap = gadgetTypeOperandTreeMap.get(gadgetTriple);
                GadgetLogger.writeLog(gadgetType, OperandTreeMapHelper.printExpression(currentGadgetOperandTreeMap));
                GadgetLogger.writeLog(gadgetType, GadgetTypeOperandTreeMapHelper.calculateGadgetPreAndPostCondition(currentGadgetOperandTreeMap));
            }
            HashMap<String, Triple<GadgetType, String, Address>> leastComplexGadget = gadgetTypeOperandTreeMap.getLeastComplexGadgetForSpecificGadgetType(gadgetType);
            for (String string : leastComplexGadget.keySet()) {
                System.out.println("[GADGET BEGIN]==============================");
                OperandTreeMapHelper.printExpression(gadgetTypeOperandTreeMap.get(leastComplexGadget.get(string)));
                System.out.println("[i] least complex gadget for type : " + (Object)((Object)leastComplexGadget.get(string).first()) + "\n" + "[i] operation operands : " + leastComplexGadget.get(string).second() + "\n" + "[i] is located at address " + leastComplexGadget.get(string).third());
                GadgetTypeOperandTreeMapHelper.calculateGadgetPreAndPostCondition(gadgetTypeOperandTreeMap.get(leastComplexGadget.get(string)));
                System.out.println("[GADGET END]================================\n");
            }
            ++n2;
        }
        System.out.println("[i] complete analyis run took " + (System.currentTimeMillis() - time_prev) + "ms");
        System.out.flush();
    }

    public static PathOperandTreeMap generateOperandTreesAndMergeInSingleFunction(Function function, Long address, LinkedHashSet<Long> addressHashSet) {
        int pathLengthMaximum = 11;
        int treeSizeMaximum = 200;
        PathOperandTreeMap pathToOperandTreeMap = new PathOperandTreeMap();
        for (BasicBlock block : function.getGraph().getNodes()) {
            for (Instruction instruction : block.getInstructions()) {
                if (instruction.getAddress().toLong() != address.longValue()) continue;
                AddressOperandTreeMap addressToForests = OperandTreeMapCollector.extractOperandTrees(block, instruction, 11);
                AddressBlocksPathMap addressToPath = PathCollector.extractPath(block, instruction, addressHashSet, 11);
                if (AddressOperandTreeMapHelper.checkTreeSize(addressToForests, 200)) {
                    PathOperandTreeMerger.mergePathOperandTrees(addressToPath, addressToForests, pathToOperandTreeMap);
                }
                OperandTreeMinimizer.minimize(pathToOperandTreeMap);
            }
        }
        return pathToOperandTreeMap;
    }

    public static void showDialog(JFrame mainWindow, Module module) {
        assert (module.isLoaded()) : "Internal Error: Target module is not loaded";
        GadgetfindingDialog dlg = new GadgetfindingDialog(mainWindow, module);
        GuiHelper.centerChildToParent(mainWindow, dlg, true);
        dlg.setVisible(true);
        if (dlg.wasCancelled()) {
            return;
        }
        CreationThread creationThread = new CreationThread(module);
        Exception e = ProgressDialog.show((Window)mainWindow, (String)"Searching for function epilogs ...", (IProgressThread)creationThread);
        if (e != null) {
            e.printStackTrace();
            MessageBox.showException(null, (Exception)e, (String)"Got Exception");
        }
    }
}

