/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.algorithms;

import BinNavi.API.reil.OperandType;
import binnavi.plugins.gadgetfinder.datastructures.ComparableReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.maps.OperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.node.Interfaces.Position;
import binnavi.plugins.gadgetfinder.datastructures.tree.LinkedBinaryTree;
import binnavi.plugins.gadgetfinder.helper.InvalidPositionException;
import java.util.ArrayList;

public class ExpressionTreeUpdater {
    private static void removeNodeAndAttachAtParent(LinkedBinaryTree<ComparableReilOperand> currentExpressionTree, LinkedBinaryTree<ComparableReilOperand> pathExpressionTree, Position<ComparableReilOperand> parent, Position<ComparableReilOperand> operand) {
        if (currentExpressionTree.left(parent) == operand) {
            currentExpressionTree.remove(operand);
            currentExpressionTree.attachLeft(parent, pathExpressionTree);
        } else {
            currentExpressionTree.remove(operand);
            currentExpressionTree.attachRight(parent, pathExpressionTree);
        }
    }

    private static void replaceMatchedOperandWithPathExpressionTree(Position<ComparableReilOperand> comparableReilOperandPosition, LinkedBinaryTree<ComparableReilOperand> currentExpressionTree, LinkedBinaryTree<ComparableReilOperand> pathExpressionTree) {
        Position<ComparableReilOperand> comparableReilOperandPositionParent;
        Position<ComparableReilOperand> position = comparableReilOperandPositionParent = currentExpressionTree.hasParent(comparableReilOperandPosition) ? currentExpressionTree.parent(comparableReilOperandPosition) : null;
        if (currentExpressionTree.isExternal(comparableReilOperandPosition) && comparableReilOperandPositionParent != null) {
            ExpressionTreeUpdater.removeNodeAndAttachAtParent(currentExpressionTree, pathExpressionTree, comparableReilOperandPositionParent, comparableReilOperandPosition);
        } else if (currentExpressionTree.isExternal(comparableReilOperandPosition) && comparableReilOperandPositionParent == null) {
            currentExpressionTree = pathExpressionTree;
        } else {
            throw new InvalidPositionException("Register which is internal can not be merged");
        }
    }

    private static void traverseFoundOperandPositions(LinkedBinaryTree<ComparableReilOperand> currentExpressionTree, OperandTreeMap currentPathOperandTreeMap, ComparableReilOperand registerOperand) {
        ArrayList<Position<ComparableReilOperand>> comparableReilOperandPositions = currentExpressionTree.find(registerOperand);
        LinkedBinaryTree<ComparableReilOperand> pathExpressionTree = currentPathOperandTreeMap.getTree(registerOperand);
        for (Position<ComparableReilOperand> position : comparableReilOperandPositions) {
            ExpressionTreeUpdater.replaceMatchedOperandWithPathExpressionTree(position, currentExpressionTree, pathExpressionTree);
        }
    }

    public static void updateExpressionTree(LinkedBinaryTree<ComparableReilOperand> currentExpressionTree, OperandTreeMap currentPathOperandTreeMap, ComparableReilOperand operandTreeKey) {
        ArrayList<ComparableReilOperand> elementsInTreeToBeUpdated = new ArrayList<ComparableReilOperand>();
        for (Position<ComparableReilOperand> position : currentExpressionTree.positions()) {
            if (position.element().getType() != OperandType.REGISTER || !currentPathOperandTreeMap.keySet().contains(position.element()) || elementsInTreeToBeUpdated.contains(position.element())) continue;
            elementsInTreeToBeUpdated.add(position.element());
        }
        for (ComparableReilOperand currentUpdateElement : elementsInTreeToBeUpdated) {
            ExpressionTreeUpdater.traverseFoundOperandPositions(currentExpressionTree, currentPathOperandTreeMap, currentUpdateElement);
        }
        currentPathOperandTreeMap.storeTree(operandTreeKey, currentExpressionTree);
    }
}

