/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.algorithms;

import BinNavi.API.disassembly.Address;
import BinNavi.API.reil.OperandSize;
import BinNavi.API.reil.ReilOperand;
import binnavi.plugins.gadgetfinder.algorithms.helpers.GadgetLocatorHelper;
import binnavi.plugins.gadgetfinder.datastructures.ComparableReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.enums.GadgetType;
import binnavi.plugins.gadgetfinder.datastructures.helpers.ComparableReilOperandHelper;
import binnavi.plugins.gadgetfinder.datastructures.list.PathOperandTreeMapList;
import binnavi.plugins.gadgetfinder.datastructures.maps.GadgetTypeOperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.maps.OperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.maps.PathOperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.node.Interfaces.Position;
import binnavi.plugins.gadgetfinder.datastructures.tree.LinkedBinaryTree;
import binnavi.plugins.gadgetfinder.helper.Pair;
import binnavi.plugins.gadgetfinder.helper.Triple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GadgetLocator {
    private static Pair<ComparableReilOperand, ComparableReilOperand> locateCompareGadget(OperandTreeMap operandTreeMap) {
        LinkedBinaryTree<ComparableReilOperand> pcTree = operandTreeMap.getTree(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "PC")));
        if (pcTree.contains(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "SP")))) {
            for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
                Position<ComparableReilOperand> leftNode;
                ComparableReilOperand leftSide;
                LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
                Position<ComparableReilOperand> rootNode;
                if (!ComparableReilOperandHelper.isNativeRegister(operandTreeMapKey) || (rootNode = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey), "bisz")) == null || (leftSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(leftNode = treeToBeCheckedForMatch.left(rootNode)))) == null) continue;
                return new Pair<ComparableReilOperand, ComparableReilOperand>(operandTreeMapKey, leftSide);
            }
        }
        return null;
    }

    private static Pair<ComparableReilOperand, ComparableReilOperand> locateConditionalBranchGadget(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNodePosition;
            if (!operandTreeMapKey.getValue().startsWith("PC_CONDITIONAL_") || !operandTreeMap.containsTree(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "PC"))) || (rootNodePosition = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey), "add")) == null) continue;
            Position<ComparableReilOperand> leftNodePosition = GadgetLocatorHelper.checkExactLeftOfNodeValue(treeToBeCheckedForMatch, rootNodePosition, "mul");
            Position<ComparableReilOperand> rightNodePosition = GadgetLocatorHelper.checkExactRightOfNodeValue(treeToBeCheckedForMatch, rootNodePosition, "mul");
            if (leftNodePosition == null || rightNodePosition == null) continue;
            Position<ComparableReilOperand> leftLeftNodePosition = GadgetLocatorHelper.checkExactLeftOfNodeValue(treeToBeCheckedForMatch, leftNodePosition, "bisz");
            Position<ComparableReilOperand> leftRightNodePosition = GadgetLocatorHelper.checkExactRightOfNodeValue(treeToBeCheckedForMatch, leftNodePosition, "and");
            Position<ComparableReilOperand> rightRightNodePosition = GadgetLocatorHelper.checkExactRightOfNodeValue(treeToBeCheckedForMatch, rightNodePosition, "PC");
            if (leftLeftNodePosition == null || leftRightNodePosition == null || rightRightNodePosition == null) continue;
            Position<ComparableReilOperand> leftRightLeftNodePosition1 = GadgetLocatorHelper.checkIsLeftRegister(treeToBeCheckedForMatch, leftRightNodePosition);
            if (leftRightLeftNodePosition1 != null && !leftRightLeftNodePosition1.element().getValue().equalsIgnoreCase("LR")) {
                return new Pair<ComparableReilOperand, ComparableReilOperand>(operandTreeMapKey, operandTreeMapKey);
            }
            Position<ComparableReilOperand> leftRightLeftNodePosition2 = GadgetLocatorHelper.checkExactLeftOfNodeValue(treeToBeCheckedForMatch, leftRightNodePosition, "ldm");
            if (leftRightLeftNodePosition2 == null) continue;
            return new Pair<ComparableReilOperand, ComparableReilOperand>(operandTreeMapKey, operandTreeMapKey);
        }
        return null;
    }

    private static Pair<ComparableReilOperand, ComparableReilOperand> locateFunctionCallGadget(OperandTreeMap operandTreeMap) {
        ComparableReilOperand R0 = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "R0"));
        ComparableReilOperand R1 = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "R1"));
        ComparableReilOperand R2 = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "R2"));
        ComparableReilOperand R3 = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "R3"));
        ComparableReilOperand LR = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "LR"));
        ComparableReilOperand PC = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "PC"));
        if (operandTreeMap.containsTree(R0) && operandTreeMap.containsTree(R1) && operandTreeMap.containsTree(R2) && operandTreeMap.containsTree(R3)) {
            LinkedBinaryTree<ComparableReilOperand> lrTree;
            Position<ComparableReilOperand> LRTreeRootNode;
            LinkedBinaryTree<ComparableReilOperand> r3Tree;
            Position<ComparableReilOperand> r3TreeRootNode;
            LinkedBinaryTree<ComparableReilOperand> r2Tree;
            Position<ComparableReilOperand> r2TreeRootNode;
            LinkedBinaryTree<ComparableReilOperand> r1Tree;
            Position<ComparableReilOperand> r1TreeRootNode;
            LinkedBinaryTree<ComparableReilOperand> r0Tree = operandTreeMap.getTree(R0);
            Position<ComparableReilOperand> r0TreeRootNode = GadgetLocatorHelper.checkIsRootRegister(r0Tree);
            if (r0TreeRootNode == null) {
                r0TreeRootNode = GadgetLocatorHelper.checkExactRootNodeValue(r0Tree, "ldm");
            }
            if ((r1TreeRootNode = GadgetLocatorHelper.checkIsRootRegister(r1Tree = operandTreeMap.getTree(R1))) == null) {
                r1TreeRootNode = GadgetLocatorHelper.checkExactRootNodeValue(r0Tree, "ldm");
            }
            if ((r2TreeRootNode = GadgetLocatorHelper.checkIsRootRegister(r2Tree = operandTreeMap.getTree(R2))) == null) {
                r2TreeRootNode = GadgetLocatorHelper.checkExactRootNodeValue(r0Tree, "ldm");
            }
            if ((r3TreeRootNode = GadgetLocatorHelper.checkIsRootRegister(r3Tree = operandTreeMap.getTree(R3))) == null) {
                r3TreeRootNode = GadgetLocatorHelper.checkExactRootNodeValue(r0Tree, "ldm");
            }
            if ((LRTreeRootNode = GadgetLocatorHelper.checkIsRootRegister(lrTree = operandTreeMap.getTree(LR))) == null) {
                LRTreeRootNode = GadgetLocatorHelper.checkIsRootInteger(lrTree);
            }
            if (r0TreeRootNode != null && r1TreeRootNode != null && r2TreeRootNode != null && r3TreeRootNode != null && LRTreeRootNode != null) {
                Position<ComparableReilOperand> pcTreeLeft;
                LinkedBinaryTree<ComparableReilOperand> pcTree = operandTreeMap.getTree(PC);
                Position<ComparableReilOperand> pcTreeRoot = GadgetLocatorHelper.checkExactRootNodeValue(pcTree, "and");
                Position<ComparableReilOperand> position = pcTreeLeft = pcTreeRoot == null ? null : GadgetLocatorHelper.checkIsLeftRegister(pcTree, pcTreeRoot);
                if (pcTreeRoot != null && pcTreeLeft != null) {
                    ComparableReilOperand functionArguments = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "R0 = " + r0TreeRootNode.element().getValue() + ", R1 = " + r1TreeRootNode.element().getValue() + ", R2 = " + r2TreeRootNode.element().getValue() + ", R3 = " + r3TreeRootNode.element().getValue()));
                    return new Pair<ComparableReilOperand, ComparableReilOperand>(pcTreeLeft.element(), functionArguments);
                }
            }
        }
        return null;
    }

    private static GadgetTypeOperandTreeMap locateGadgetsInSinglePath(OperandTreeMap operandTreeMap, Pair<Long, List<Long>> pathOperandTreeMapKey, GadgetTypeOperandTreeMap gadgetTypeOperandTreeMap) {
        Address currentAddress = new Address(pathOperandTreeMapKey.first().longValue());
        if (GadgetLocatorHelper.checkIfPCisFunctionOfRegister(operandTreeMap) && !GadgetLocatorHelper.checkIfFunctionHasCondition(operandTreeMap)) {
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> registerDivisionTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> registerMultiplicationTriple;
            Pair<ComparableReilOperand, ComparableReilOperand> stackPointerSetPair;
            Pair<ComparableReilOperand, ComparableReilOperand> functionCallPair;
            Pair<ComparableReilOperand, ComparableReilOperand> conditionalBranchPair;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> registerRightShiftRegisterTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> registerLeftShiftRegisterTriple;
            Pair<ComparableReilOperand, ComparableReilOperand> memoryDereferenceSetToRegisterPair;
            Pair<ComparableReilOperand, ComparableReilOperand> memoryDereferenceSetToMemoryPair;
            Pair<ComparableReilOperand, ComparableReilOperand> memorySetToMemoryDereferencePair;
            Pair<ComparableReilOperand, ComparableReilOperand> registerSetToMemoryDereferencePair;
            Pair<ComparableReilOperand, ComparableReilOperand> compareGadgetPair;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> memoryXorTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> memoryOrTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> memoryAndTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> memorySubtractionTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> memoryDecrementTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> memoryIncrementTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> memoryAdditionTriple;
            Pair<ComparableReilOperand, ComparableReilOperand> memorySetToRegisterPair;
            Pair<ComparableReilOperand, ComparableReilOperand> memorySetToMemoryPair;
            Pair<ComparableReilOperand, ComparableReilOperand> registerToMemoryPair;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> registerNotTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> registerXorTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> registerOrTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> registerAndTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> registerDecrementTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> registerIncrementTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> registerSubstractionTriple;
            Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> registerAdditionTriple;
            ArrayList<Pair<ComparableReilOperand, ComparableReilOperand>> registersSetToRegisters;
            Pair<ComparableReilOperand, ComparableReilOperand> registerSetToRegister;
            Pair<ComparableReilOperand, ComparableReilOperand> registerSetToConstant;
            ComparableReilOperand registerSetToZero = GadgetLocator.locateRegisterSetToZeroGadget(operandTreeMap);
            if (registerSetToZero != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_SET_TO_ZERO, registerSetToZero + " = 0", currentAddress), operandTreeMap);
            }
            if ((registerSetToConstant = GadgetLocator.locateRegisterSetToConstant(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_SET_TO_CONSTANT, registerSetToConstant.first() + " = " + registerSetToConstant.second(), currentAddress), operandTreeMap);
            }
            if ((registerSetToRegister = GadgetLocator.locateRegisterSetToRegisterGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_SET_TO_REGISTER, registerSetToRegister.first() + " = " + registerSetToRegister.second(), currentAddress), operandTreeMap);
            }
            if ((registersSetToRegisters = GadgetLocator.locateRegistersSetToRegistersGadget(operandTreeMap)) != null) {
                String multiReg = "";
                for (Pair<ComparableReilOperand, ComparableReilOperand> pair : registersSetToRegisters) {
                    multiReg = String.valueOf(multiReg) + pair.first() + " = " + pair.second() + " ";
                }
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTERS_SET_TO_REGISTERS, multiReg, currentAddress), operandTreeMap);
            }
            if ((registerAdditionTriple = GadgetLocator.locateRegisterAdditionGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_ADDITION, registerAdditionTriple.first() + " = " + registerAdditionTriple.second() + " + " + registerAdditionTriple.third(), currentAddress), operandTreeMap);
            }
            if ((registerSubstractionTriple = GadgetLocator.locateRegisterSubstractionGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_SUBTRACTION, registerSubstractionTriple.first() + " = " + registerSubstractionTriple.second() + " - " + registerSubstractionTriple.third(), currentAddress), operandTreeMap);
            }
            if ((registerIncrementTriple = GadgetLocator.locateRegisterIncrementGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_INCREMENT, registerIncrementTriple.first() + " = " + registerIncrementTriple.second() + " + " + registerIncrementTriple.third(), currentAddress), operandTreeMap);
            }
            if ((registerDecrementTriple = GadgetLocator.locateRegisterDecrementGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_DECREMENT, registerDecrementTriple.first() + " = " + registerDecrementTriple.second() + " - " + registerDecrementTriple.third(), currentAddress), operandTreeMap);
            }
            if ((registerAndTriple = GadgetLocator.locateRegisterAndGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_AND, registerAndTriple.first() + " = " + registerAndTriple.second() + " & " + registerAndTriple.third(), currentAddress), operandTreeMap);
            }
            if ((registerOrTriple = GadgetLocator.locateRegisterOrGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_OR, registerOrTriple.first() + " = " + registerOrTriple.second() + " | " + registerOrTriple.third(), currentAddress), operandTreeMap);
            }
            if ((registerXorTriple = GadgetLocator.locateRegisterXorGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_XOR, registerXorTriple.first() + " = " + registerXorTriple.second() + " ^ " + registerXorTriple.third(), currentAddress), operandTreeMap);
            }
            if ((registerNotTriple = GadgetLocator.locateRegisterNotGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_NOT, registerNotTriple.first() + " = " + registerNotTriple.second() + " ~ " + registerNotTriple.third(), currentAddress), operandTreeMap);
            }
            if ((registerToMemoryPair = GadgetLocator.locateRegisterSetToMemoryGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_SET_TO_MEMORY, registerToMemoryPair.first() + " = " + registerToMemoryPair.second(), currentAddress), operandTreeMap);
            }
            if ((memorySetToMemoryPair = GadgetLocator.locateMemorySetToMemoryGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.MEMORY_SET_TO_MEMORY, memorySetToMemoryPair.first() + " = " + memorySetToMemoryPair.second(), currentAddress), operandTreeMap);
            }
            if ((memorySetToRegisterPair = GadgetLocator.locateMemorySetToRegisterGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.MEMORY_SET_TO_REGISTER, memorySetToRegisterPair.first() + " = " + memorySetToRegisterPair.second(), currentAddress), operandTreeMap);
            }
            if ((memoryAdditionTriple = GadgetLocator.locateMemoryAdditionGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.MEMORY_ADDITION, memoryAdditionTriple.first() + " = " + memoryAdditionTriple.second() + " + " + memoryAdditionTriple.third(), currentAddress), operandTreeMap);
            }
            if ((memoryIncrementTriple = GadgetLocator.locateMemoryIncrementGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.MEMORY_INCREMENT, memoryIncrementTriple.first() + " = " + memoryIncrementTriple.second() + " + " + memoryIncrementTriple.third(), currentAddress), operandTreeMap);
            }
            if ((memoryDecrementTriple = GadgetLocator.locateMemoryDecrementGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.MEMORY_DECREMENT, memoryDecrementTriple.first() + " = " + memoryDecrementTriple.second() + " - " + memoryDecrementTriple.third(), currentAddress), operandTreeMap);
            }
            if ((memorySubtractionTriple = GadgetLocator.locateMemorySubtractionGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.MEMORY_SUBTRACTION, memorySubtractionTriple.first() + " = " + memorySubtractionTriple.second() + " - " + memorySubtractionTriple.third(), currentAddress), operandTreeMap);
            }
            if ((memoryAndTriple = GadgetLocator.locateMemoryAndGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.MEMORY_AND, memoryAndTriple.first() + " = " + memoryAndTriple.second() + " & " + memoryAndTriple.third(), currentAddress), operandTreeMap);
            }
            if ((memoryOrTriple = GadgetLocator.locateMemoryOrGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.MEMORY_OR, memoryOrTriple.first() + " = " + memoryOrTriple.second() + " | " + memoryOrTriple.third(), currentAddress), operandTreeMap);
            }
            if ((memoryXorTriple = GadgetLocator.locateMemoryXorGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.MEMORY_XOR, memoryXorTriple.first() + " = " + memoryXorTriple.second() + " ^ " + memoryXorTriple.third(), currentAddress), operandTreeMap);
            }
            if ((compareGadgetPair = GadgetLocator.locateCompareGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.COMPARE, compareGadgetPair.first() + " = " + compareGadgetPair.second(), currentAddress), operandTreeMap);
            }
            if ((registerSetToMemoryDereferencePair = GadgetLocator.locateRegisterSetToMemoryDereferenceGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_SET_TO_MEMORY_DEREFERENCE, registerSetToMemoryDereferencePair.first() + " = " + registerSetToMemoryDereferencePair.second(), currentAddress), operandTreeMap);
            }
            if ((memorySetToMemoryDereferencePair = GadgetLocator.locateMemorySetToMemoryDereferenceGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.MEMORY_SET_TO_MEMORY_DEREFERENCE, memorySetToMemoryDereferencePair.first() + " = " + memorySetToMemoryDereferencePair.second(), currentAddress), operandTreeMap);
            }
            if ((memoryDereferenceSetToMemoryPair = GadgetLocator.locateMemoryDereferenceSetToMemoryGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.MEMORY_DEREFERENCE_SET_TO_MEMORY, memoryDereferenceSetToMemoryPair.first() + " = " + memoryDereferenceSetToMemoryPair.second(), currentAddress), operandTreeMap);
            }
            if ((memoryDereferenceSetToRegisterPair = GadgetLocator.locateMemoryDereferenceSetToRegisterGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.MEMORY_DEREFERENCE_SET_TO_REGISTER, memoryDereferenceSetToRegisterPair.first() + " = " + memoryDereferenceSetToRegisterPair.second(), currentAddress), operandTreeMap);
            }
            if ((registerLeftShiftRegisterTriple = GadgetLocator.locateRegisterLeftShiftRegisterGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_LEFT_SHIFT_REGISTER, registerLeftShiftRegisterTriple.first() + " = " + registerLeftShiftRegisterTriple.second() + " << " + registerLeftShiftRegisterTriple.third(), currentAddress), operandTreeMap);
            }
            if ((registerRightShiftRegisterTriple = GadgetLocator.locateRegisterRightShiftRegisterGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_RIGHT_SHIFT_REGISTER, registerRightShiftRegisterTriple.first() + " = " + registerRightShiftRegisterTriple.second() + " >> " + registerRightShiftRegisterTriple.third(), currentAddress), operandTreeMap);
            }
            if ((conditionalBranchPair = GadgetLocator.locateConditionalBranchGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.CONDITIONAL_BRANCH, conditionalBranchPair.first().toString(), currentAddress), operandTreeMap);
            }
            if ((functionCallPair = GadgetLocator.locateFunctionCallGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.FUNCTION_CALL, "Call : " + functionCallPair.first() + " " + functionCallPair.second(), currentAddress), operandTreeMap);
            }
            if ((stackPointerSetPair = GadgetLocator.locateStackPointerSetFromMemory(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.STACK_POINTER_MANIPULATION, String.valueOf(stackPointerSetPair.first().toString()) + " = " + stackPointerSetPair.second().toString(), currentAddress), operandTreeMap);
            }
            if ((registerMultiplicationTriple = GadgetLocator.locateRegisterMultiplicationGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_AND, registerMultiplicationTriple.first() + " = " + registerMultiplicationTriple.second() + " & " + registerMultiplicationTriple.third(), currentAddress), operandTreeMap);
            }
            if ((registerDivisionTriple = GadgetLocator.locateRegisterDivisionGadget(operandTreeMap)) != null) {
                gadgetTypeOperandTreeMap.put(new Triple<GadgetType, String, Address>(GadgetType.REGISTER_AND, registerDivisionTriple.first() + " = " + registerDivisionTriple.second() + " & " + registerDivisionTriple.third(), currentAddress), operandTreeMap);
            }
        }
        return gadgetTypeOperandTreeMap;
    }

    private static GadgetTypeOperandTreeMap locateGadgetsInSinglePathOperandTreeMap(PathOperandTreeMap pathOperandTreeMap, GadgetTypeOperandTreeMap gadgetTypeOperandTreeMap) {
        for (Pair<Long, List<Long>> pathOperandTreeMapKey : pathOperandTreeMap.keySet()) {
            OperandTreeMap operandTreeMap = pathOperandTreeMap.get(pathOperandTreeMapKey);
            GadgetLocator.locateGadgetsInSinglePath(operandTreeMap, pathOperandTreeMapKey, gadgetTypeOperandTreeMap);
        }
        return gadgetTypeOperandTreeMap;
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateMemoryAdditionGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateMemoryOperationGadget(operandTreeMap, "add", null);
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateMemoryAndGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateMemoryOperationGadget(operandTreeMap, "and", null);
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateMemoryDecrementGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateMemoryOperationGadget(operandTreeMap, "sub", "1");
    }

    private static Pair<ComparableReilOperand, ComparableReilOperand> locateMemoryDereferenceSetToMemoryGadget(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNode;
            if (!operandTreeMapKey.getValue().startsWith("MEM") || (rootNode = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey), "stm")) == null) continue;
            Position<ComparableReilOperand> sourcePosition = GadgetLocatorHelper.checkExactLeftOfNodeValue(treeToBeCheckedForMatch, rootNode, "ldm");
            Position<ComparableReilOperand> targetPosition = GadgetLocatorHelper.checkExactRightOfNodeValue(treeToBeCheckedForMatch, rootNode, "ldm");
            if (sourcePosition == null || targetPosition == null) continue;
            ComparableReilOperand sourceSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(sourcePosition)));
            ComparableReilOperand targetSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(targetPosition)));
            if (sourceSide == null || targetSide == null) continue;
            sourceSide.setValue("mem[" + sourceSide.getValue() + "]");
            targetSide.setValue("mem[" + targetSide.getValue() + "]");
            return new Pair<ComparableReilOperand, ComparableReilOperand>(targetSide, sourceSide);
        }
        return null;
    }

    private static Pair<ComparableReilOperand, ComparableReilOperand> locateMemoryDereferenceSetToRegisterGadget(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            Position<ComparableReilOperand> targetPosition;
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNode;
            if (!operandTreeMapKey.getValue().startsWith("MEM") || (rootNode = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey), "stm")) == null || (targetPosition = GadgetLocatorHelper.checkExactRightOfNodeValue(treeToBeCheckedForMatch, rootNode, "ldm")) == null) continue;
            ComparableReilOperand sourceSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(rootNode)));
            ComparableReilOperand targetSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(targetPosition)));
            if (sourceSide == null || targetSide == null) continue;
            targetSide.setValue("mem[" + targetSide.getValue() + "]");
            return new Pair<ComparableReilOperand, ComparableReilOperand>(targetSide, sourceSide);
        }
        return null;
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateMemoryIncrementGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateMemoryOperationGadget(operandTreeMap, "add", "1");
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateMemoryOperationGadget(OperandTreeMap operandTreeMap, String operation, String optionalRightSourceOperand) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            Position<ComparableReilOperand> sourceOperationNode;
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNode;
            if (!operandTreeMapKey.getValue().startsWith("MEM") || (rootNode = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey), "stm")) == null || (sourceOperationNode = GadgetLocatorHelper.checkExactLeftOfNodeValue(treeToBeCheckedForMatch, rootNode, operation)) == null) continue;
            Position<ComparableReilOperand> leftOfSourceOperationNode = treeToBeCheckedForMatch.left(sourceOperationNode);
            Position<ComparableReilOperand> rightOfSourceOperationNode = treeToBeCheckedForMatch.right(sourceOperationNode);
            ComparableReilOperand leftSourceSide = null;
            ComparableReilOperand rightSourceSide = null;
            ComparableReilOperand targetSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.right(rootNode)));
            if (targetSide != null) {
                targetSide.setValue("mem[" + targetSide.getValue() + "]");
            }
            if (leftOfSourceOperationNode.element().getValue().equalsIgnoreCase("ldm")) {
                leftSourceSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(leftOfSourceOperationNode)));
                if (leftSourceSide != null) {
                    leftSourceSide.setValue("mem[" + leftSourceSide.getValue() + "]");
                }
            } else if (ComparableReilOperandHelper.isNativeRegister(leftOfSourceOperationNode.element())) {
                leftSourceSide = leftOfSourceOperationNode.element();
            }
            if (optionalRightSourceOperand != null) {
                Position<ComparableReilOperand> rightSideNode = GadgetLocatorHelper.checkExactRightOfNodeValue(treeToBeCheckedForMatch, sourceOperationNode, optionalRightSourceOperand);
                if (rightSideNode != null) {
                    rightSourceSide = rightSideNode.element();
                }
            } else if (rightOfSourceOperationNode.element().getValue().equalsIgnoreCase("ldm")) {
                rightSourceSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(rightOfSourceOperationNode));
                if (rightSourceSide != null) {
                    rightSourceSide.setValue("mem[" + leftSourceSide.getValue() + "]");
                }
            } else if (ComparableReilOperandHelper.isNativeRegister(rightOfSourceOperationNode.element())) {
                rightSourceSide = rightOfSourceOperationNode.element();
            }
            if (leftSourceSide == null || rightSourceSide == null || targetSide == null) continue;
            return new Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand>(targetSide, leftSourceSide, rightSourceSide);
        }
        return null;
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateMemoryOrGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateMemoryOperationGadget(operandTreeMap, "or", null);
    }

    private static Pair<ComparableReilOperand, ComparableReilOperand> locateMemorySetToMemoryDereferenceGadget(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            Position<ComparableReilOperand> leftLeftNode;
            Position<ComparableReilOperand> leftNode;
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNode;
            if (!operandTreeMapKey.getValue().startsWith("MEM") || (rootNode = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey), "stm")) == null || (leftNode = GadgetLocatorHelper.checkExactLeftOfNodeValue(treeToBeCheckedForMatch, rootNode, "ldm")) == null || (leftLeftNode = GadgetLocatorHelper.checkExactLeftOfNodeValue(treeToBeCheckedForMatch, leftNode, "ldm")) == null) continue;
            ComparableReilOperand sourceSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(leftLeftNode)));
            ComparableReilOperand targetSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.right(rootNode)));
            if (sourceSide == null || targetSide == null) continue;
            targetSide.setValue("mem[" + targetSide.getValue() + "]");
            sourceSide.setValue("mem[mem[" + sourceSide.getValue() + "]]");
            return new Pair<ComparableReilOperand, ComparableReilOperand>(targetSide, sourceSide);
        }
        return null;
    }

    private static Pair<ComparableReilOperand, ComparableReilOperand> locateMemorySetToMemoryGadget(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            Position<ComparableReilOperand> leftNode;
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNode;
            if (!operandTreeMapKey.getValue().startsWith("MEM") || (rootNode = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey), "stm")) == null || (leftNode = GadgetLocatorHelper.checkExactLeftOfNodeValue(treeToBeCheckedForMatch, rootNode, "ldm")) == null) continue;
            ComparableReilOperand sourceSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(leftNode)));
            ComparableReilOperand targetSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.right(rootNode)));
            if (sourceSide == null || targetSide == null) continue;
            targetSide.setValue("mem[" + targetSide.getValue() + "]");
            sourceSide.setValue("mem[" + sourceSide.getValue() + "]");
            return new Pair<ComparableReilOperand, ComparableReilOperand>(targetSide, sourceSide);
        }
        return null;
    }

    private static Pair<ComparableReilOperand, ComparableReilOperand> locateMemorySetToRegisterGadget(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNode;
            if (!operandTreeMapKey.getValue().startsWith("MEM") || (rootNode = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey), "stm")) == null) continue;
            ComparableReilOperand sourceSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(rootNode)));
            ComparableReilOperand targetSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.right(rootNode)));
            if (sourceSide == null || targetSide == null) continue;
            targetSide.setValue("mem[" + targetSide.getValue() + "]");
            return new Pair<ComparableReilOperand, ComparableReilOperand>(targetSide, sourceSide);
        }
        return null;
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateMemorySubtractionGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateMemoryOperationGadget(operandTreeMap, "sub", null);
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateMemoryXorGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateMemoryOperationGadget(operandTreeMap, "xor", null);
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateRegisterAdditionGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateRegisterOperationGadget(operandTreeMap, "add", null, null);
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateRegisterAndGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateRegisterOperationGadget(operandTreeMap, "and", null, null);
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateRegisterDecrementGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateRegisterOperationGadget(operandTreeMap, "sub", "1", null);
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateRegisterDivisionGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateRegisterOperationGadget(operandTreeMap, "div", null, null);
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateRegisterIncrementGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateRegisterOperationGadget(operandTreeMap, "add", "1", null);
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateRegisterLeftShiftRegisterGadget(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            Position<ComparableReilOperand> rightNodePosition;
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNodePosition;
            if (!ComparableReilOperandHelper.isNativeRegister(operandTreeMapKey) || (rootNodePosition = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey), "bsh")) == null || (rightNodePosition = GadgetLocatorHelper.checkExactRightOfNodeValue(treeToBeCheckedForMatch, rootNodePosition, "and")) == null) continue;
            Position<ComparableReilOperand> shifterAndMaskPosition = GadgetLocatorHelper.checkExactRightOfNodeValue(treeToBeCheckedForMatch, rightNodePosition, "255");
            ComparableReilOperand shifterOperand = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(rightNodePosition)));
            ComparableReilOperand shiftedOperand = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(rootNodePosition)));
            if (shifterAndMaskPosition == null || shifterOperand == null || shiftedOperand == null) continue;
            return new Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand>(operandTreeMapKey, shiftedOperand, shifterOperand);
        }
        return null;
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateRegisterMultiplicationGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateRegisterOperationGadget(operandTreeMap, "mul", null, null);
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateRegisterNotGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateRegisterOperationGadget(operandTreeMap, "xor", "4294967295", null);
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateRegisterOperationGadget(OperandTreeMap operandTreeMap, String operation, String optionalRightOperand, String optionalLeftOperand) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNode;
            if (!ComparableReilOperandHelper.isNativeRegister(operandTreeMapKey) || (rootNode = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey), operation)) == null) continue;
            Position<ComparableReilOperand> leftNode = treeToBeCheckedForMatch.hasLeft(rootNode) ? treeToBeCheckedForMatch.left(rootNode) : null;
            Position<ComparableReilOperand> rightNode = treeToBeCheckedForMatch.hasRight(rootNode) ? treeToBeCheckedForMatch.right(rootNode) : null;
            ComparableReilOperand leftSide = null;
            ComparableReilOperand rightSide = null;
            if (leftNode != null) {
                if (optionalLeftOperand != null) {
                    Position<ComparableReilOperand> leftOperandPosition = GadgetLocatorHelper.checkExactLeftOfNodeValue(treeToBeCheckedForMatch, rootNode, optionalLeftOperand);
                    if (leftOperandPosition != null) {
                        leftSide = leftOperandPosition.element();
                    }
                } else if (leftNode.element().getValue().equalsIgnoreCase("ldm")) {
                    leftSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(leftNode)));
                    if (leftSide != null) {
                        leftSide.setValue("mem[" + leftSide.getValue() + "]");
                    }
                } else if (ComparableReilOperandHelper.isNativeRegister(leftNode.element())) {
                    leftSide = leftNode.element();
                }
            }
            if (rightNode != null) {
                if (optionalRightOperand != null) {
                    Position<ComparableReilOperand> rightSidePosition = GadgetLocatorHelper.checkExactRightOfNodeValue(treeToBeCheckedForMatch, rootNode, optionalRightOperand);
                    if (rightSidePosition != null) {
                        rightSide = rightSidePosition.element();
                    }
                } else if (rightNode.element().getValue().equalsIgnoreCase("ldm")) {
                    rightSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(rightNode)));
                    if (rightSide != null) {
                        rightSide.setValue("mem[" + rightSide.getValue() + "]");
                    }
                } else if (ComparableReilOperandHelper.isNativeRegister(rightNode.element())) {
                    rightSide = rightNode.element();
                }
            }
            if (rightSide != null && leftSide != null) {
                return new Triple<ComparableReilOperand, Object, Object>(operandTreeMapKey, leftSide, rightSide);
            }
            if (leftSide == null || !rootNode.element().getValue().equalsIgnoreCase("bisz") && !rootNode.element().getValue().equalsIgnoreCase("ldm")) continue;
            return new Triple<ComparableReilOperand, ComparableReilOperand, Object>(operandTreeMapKey, leftSide, null);
        }
        return null;
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateRegisterOrGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateRegisterOperationGadget(operandTreeMap, "or", null, null);
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateRegisterRightShiftRegisterGadget(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            Position<ComparableReilOperand> rightNodePosition;
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNodePosition;
            if (!ComparableReilOperandHelper.isNativeRegister(operandTreeMapKey) || (rootNodePosition = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey), "bsh")) == null || (rightNodePosition = GadgetLocatorHelper.checkExactRightOfNodeValue(treeToBeCheckedForMatch, rootNodePosition, "sub")) == null) continue;
            Position<ComparableReilOperand> zeroNodePosition = GadgetLocatorHelper.checkExactLeftOfNodeValue(treeToBeCheckedForMatch, rightNodePosition, "0");
            Position<ComparableReilOperand> rightRightNodePosition = GadgetLocatorHelper.checkExactRightOfNodeValue(treeToBeCheckedForMatch, rightNodePosition, "and");
            if (rightRightNodePosition == null || zeroNodePosition == null) continue;
            Position<ComparableReilOperand> shifterAndMaskPosition = GadgetLocatorHelper.checkExactRightOfNodeValue(treeToBeCheckedForMatch, rightRightNodePosition, "255");
            ComparableReilOperand shifterOperand = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(rightRightNodePosition)));
            ComparableReilOperand shiftedOperand = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(rootNodePosition)));
            if (shifterAndMaskPosition == null || shifterOperand == null || shiftedOperand == null) continue;
            return new Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand>(operandTreeMapKey, shiftedOperand, shifterOperand);
        }
        return null;
    }

    private static Pair<ComparableReilOperand, ComparableReilOperand> locateRegisterSetToConstant(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            if (!ComparableReilOperandHelper.isNativeRegister(operandTreeMapKey)) continue;
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey);
            Position<ComparableReilOperand> rootNode = GadgetLocatorHelper.checkIsRootInteger(treeToBeCheckedForMatch);
            Position<ComparableReilOperand> rootNode2 = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch, "0");
            if (rootNode == null || rootNode2 != null) continue;
            return new Pair<ComparableReilOperand, ComparableReilOperand>(operandTreeMapKey, rootNode.element());
        }
        return null;
    }

    private static Pair<ComparableReilOperand, ComparableReilOperand> locateRegisterSetToMemoryDereferenceGadget(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            ComparableReilOperand leftSide;
            Position<ComparableReilOperand> leftNode;
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNode;
            if (!ComparableReilOperandHelper.isNativeRegister(operandTreeMapKey) || (rootNode = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey), "ldm")) == null || (leftNode = GadgetLocatorHelper.checkExactLeftOfNodeValue(treeToBeCheckedForMatch, rootNode, "ldm")) == null || (leftSide = GadgetLocator.locateValidOperands(treeToBeCheckedForMatch.buildSubtree(treeToBeCheckedForMatch.left(leftNode)))) == null) continue;
            leftSide.setValue("mem[mem[" + leftSide.getValue() + "]]");
            return new Pair<ComparableReilOperand, ComparableReilOperand>(operandTreeMapKey, leftSide);
        }
        return null;
    }

    private static Pair<ComparableReilOperand, ComparableReilOperand> locateRegisterSetToMemoryGadget(OperandTreeMap operandTreeMap) {
        LinkedBinaryTree<ComparableReilOperand> pcTree = operandTreeMap.getTree(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "PC")));
        if (pcTree.contains(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "SP")))) {
            for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
                ComparableReilOperand leftSide;
                LinkedBinaryTree<ComparableReilOperand> currentLinkedBinaryTree;
                Position<ComparableReilOperand> rootNode;
                if (!ComparableReilOperandHelper.isNativeRegister(operandTreeMapKey) || !operandTreeMapKey.getSize().equals((Object)OperandSize.OPERAND_SIZE_DWORD) || !(rootNode = (currentLinkedBinaryTree = operandTreeMap.getTree(operandTreeMapKey)).root()).element().getValue().equalsIgnoreCase("ldm") || currentLinkedBinaryTree.contains(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "SP"))) || (leftSide = GadgetLocator.locateValidOperands(currentLinkedBinaryTree.buildSubtree(currentLinkedBinaryTree.left(rootNode)))) == null) continue;
                leftSide.setValue("mem[" + leftSide.getValue() + "]");
                return new Pair<ComparableReilOperand, ComparableReilOperand>(operandTreeMapKey, leftSide);
            }
        }
        return null;
    }

    private static Pair<ComparableReilOperand, ComparableReilOperand> locateRegisterSetToRegisterGadget(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNode;
            if (!ComparableReilOperandHelper.isNativeRegister(operandTreeMapKey) || (rootNode = GadgetLocatorHelper.checkIsRootRegister(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey))) == null) continue;
            return new Pair<ComparableReilOperand, ComparableReilOperand>(operandTreeMapKey, rootNode.element());
        }
        return null;
    }

    private static ComparableReilOperand locateRegisterSetToZeroGadget(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNode;
            if (!ComparableReilOperandHelper.isNativeRegister(operandTreeMapKey) || (rootNode = GadgetLocatorHelper.checkExactRootNodeValue(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey), "0")) == null) continue;
            return operandTreeMapKey;
        }
        return null;
    }

    private static ArrayList<Pair<ComparableReilOperand, ComparableReilOperand>> locateRegistersSetToRegistersGadget(OperandTreeMap operandTreeMap) {
        ArrayList<Pair<ComparableReilOperand, ComparableReilOperand>> registersToRegistersArrayList = new ArrayList<Pair<ComparableReilOperand, ComparableReilOperand>>();
        for (ComparableReilOperand operandTreeMapKey : operandTreeMap.keySet()) {
            LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch;
            Position<ComparableReilOperand> rootNode;
            if (!ComparableReilOperandHelper.isNativeRegister(operandTreeMapKey) || (rootNode = GadgetLocatorHelper.checkIsRootRegister(treeToBeCheckedForMatch = operandTreeMap.getTree(operandTreeMapKey))) == null) continue;
            registersToRegistersArrayList.add(new Pair<ComparableReilOperand, ComparableReilOperand>(operandTreeMapKey, rootNode.element()));
        }
        if (registersToRegistersArrayList.size() <= 1) {
            return null;
        }
        return registersToRegistersArrayList;
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateRegisterSubstractionGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateRegisterOperationGadget(operandTreeMap, "sub", null, null);
    }

    private static Triple<ComparableReilOperand, ComparableReilOperand, ComparableReilOperand> locateRegisterXorGadget(OperandTreeMap operandTreeMap) {
        return GadgetLocator.locateRegisterOperationGadget(operandTreeMap, "xor", null, null);
    }

    private static Pair<ComparableReilOperand, ComparableReilOperand> locateStackPointerSetFromMemory(OperandTreeMap operandTreeMap) {
        ComparableReilOperand spOperand = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "SP"));
        LinkedBinaryTree<ComparableReilOperand> spTree = operandTreeMap.getTree(spOperand);
        if (!spTree.isEmpty()) {
            ComparableReilOperand leftSide;
            Position<ComparableReilOperand> rootNode = spTree.root();
            if (rootNode.element().getValue().equalsIgnoreCase("ldm") && !spTree.contains(spOperand) && (leftSide = GadgetLocator.locateValidOperands(spTree.buildSubtree(spTree.left(rootNode)))) != null) {
                leftSide.setValue("mem[" + leftSide.getValue() + "]");
                return new Pair<ComparableReilOperand, ComparableReilOperand>(spOperand, leftSide);
            }
            if (!rootNode.element().getValue().equalsIgnoreCase("ldm") && !spTree.contains(spOperand) && (leftSide = GadgetLocator.locateValidOperands(spTree.buildSubtree(spTree.left(rootNode)))) != null) {
                return new Pair<ComparableReilOperand, ComparableReilOperand>(spOperand, leftSide);
            }
            if (rootNode.element().getValue().equalsIgnoreCase("ldm")) {
                ComparableReilOperand offsetNode = spTree.left(rootNode).element();
                String offsetRootValue = offsetNode.getValue();
                LinkedBinaryTree<ComparableReilOperand> possibleOffsetTree = spTree.buildSubtree(spTree.left(rootNode));
                if ((offsetRootValue.equalsIgnoreCase("add") || offsetRootValue.equalsIgnoreCase("sub")) && possibleOffsetTree.size == 3) {
                    Position<ComparableReilOperand> leftNode = GadgetLocatorHelper.checkIsLeftRegister(possibleOffsetTree, possibleOffsetTree.root());
                    Position<ComparableReilOperand> rightNode = GadgetLocatorHelper.checkIsRightRegister(possibleOffsetTree, possibleOffsetTree.root());
                    if (leftNode != null && rightNode != null) {
                        OperandSize leftNodeOperandSize = offsetNode.getSize();
                        return new Pair<ComparableReilOperand, ComparableReilOperand>(spOperand, new ComparableReilOperand(new ReilOperand(leftNodeOperandSize, String.valueOf(offsetNode.getValue()) + " " + offsetRootValue + " " + rightNode.element().getValue())));
                    }
                }
            }
        }
        return null;
    }

    private static ComparableReilOperand locateValidOperands(LinkedBinaryTree<ComparableReilOperand> possibleOffsetTree) {
        ComparableReilOperand rootNode = possibleOffsetTree.root().element();
        String offsetRootValue = rootNode.getValue();
        if ((offsetRootValue.equalsIgnoreCase("add") || offsetRootValue.equalsIgnoreCase("sub")) && possibleOffsetTree.size == 3) {
            Position<ComparableReilOperand> leftNode = GadgetLocatorHelper.checkIsLeftRegister(possibleOffsetTree, possibleOffsetTree.root());
            Position<ComparableReilOperand> rightNode = possibleOffsetTree.right(possibleOffsetTree.root());
            if (leftNode != null && rightNode != null) {
                OperandSize leftNodeOperandSize = leftNode.element().getSize();
                return new ComparableReilOperand(new ReilOperand(leftNodeOperandSize, String.valueOf(leftNode.element().getValue()) + " " + offsetRootValue + " " + rightNode.element().getValue()));
            }
        } else if (ComparableReilOperandHelper.isNativeRegister(possibleOffsetTree.root().element())) {
            return new ComparableReilOperand(new ReilOperand(possibleOffsetTree.root().element().getSize(), possibleOffsetTree.root().element().getValue()));
        }
        return null;
    }

    public static GadgetTypeOperandTreeMap locateGadgets(PathOperandTreeMapList pathOperandTreeMapList) {
        GadgetTypeOperandTreeMap gadgetTypeOperandTreeMap = new GadgetTypeOperandTreeMap();
        Iterator<PathOperandTreeMap> pathOperandTreeMapIterator = pathOperandTreeMapList.iterator();
        while (pathOperandTreeMapIterator.hasNext()) {
            GadgetLocator.locateGadgetsInSinglePathOperandTreeMap(pathOperandTreeMapIterator.next(), gadgetTypeOperandTreeMap);
        }
        return gadgetTypeOperandTreeMap;
    }
}

