/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.algorithms.helpers;

import BinNavi.API.disassembly.BasicBlock;
import BinNavi.API.disassembly.Instruction;
import binnavi.plugins.gadgetfinder.algorithms.helpers.ReverseTreeWalkerCallback;
import binnavi.plugins.gadgetfinder.helper.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class BasicBlockReverseWalker {
    public static void walkReverse(BasicBlock startBlock, Instruction startInstruction, int depth, ReverseTreeWalkerCallback operation) {
        Stack stack = new Stack();
        ArrayList<BasicBlock> initialList = new ArrayList<BasicBlock>();
        initialList.add(startBlock);
        stack.push(new Pair(initialList, depth));
        while (!stack.isEmpty()) {
            Pair currentPair = (Pair)stack.pop();
            List currentPath = (List)currentPair.first();
            BasicBlock currentBlock = (BasicBlock)currentPath.get(currentPath.size() - 1);
            int currentDepth = (Integer)currentPair.second();
            List instructions = currentBlock.getInstructions();
            int index = -1;
            for (Instruction instruction : instructions) {
                ++index;
                if (instruction == startInstruction && currentPath.size() == 1) break;
            }
            boolean continueProcessing = true;
            int i = index;
            while (i >= 0 && currentDepth != 0) {
                if (!(continueProcessing &= operation.call(currentPath, currentBlock, (Instruction)instructions.get(i)))) break;
                --currentDepth;
                --i;
            }
            if (!continueProcessing || currentDepth == 0) continue;
            for (BasicBlock parent : currentBlock.getParents()) {
                ArrayList<BasicBlock> newPath = new ArrayList<BasicBlock>(currentPath);
                newPath.add(parent);
                stack.push(new Pair(newPath, currentDepth));
            }
        }
    }
}

