/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.algorithms.helpers;

import BinNavi.API.reil.OperandSize;
import BinNavi.API.reil.OperandType;
import BinNavi.API.reil.ReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.ComparableReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.helpers.ComparableReilOperandHelper;
import binnavi.plugins.gadgetfinder.datastructures.maps.OperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.node.Interfaces.Position;
import binnavi.plugins.gadgetfinder.datastructures.tree.LinkedBinaryTree;
import java.util.Set;

public class GadgetLocatorHelper {
    public static Position<ComparableReilOperand> checkExactLeftOfNodeValue(LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch, Position<ComparableReilOperand> parentNode, String toBeMatched) {
        Position<ComparableReilOperand> leftNode;
        String leftValue;
        if (treeToBeCheckedForMatch.hasLeft(parentNode) && (leftValue = (leftNode = treeToBeCheckedForMatch.left(parentNode)).element().getElement().getValue()).equalsIgnoreCase(toBeMatched)) {
            return leftNode;
        }
        return null;
    }

    public static Position<ComparableReilOperand> checkExactRightOfNodeValue(LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch, Position<ComparableReilOperand> parentNode, String toBeMatched) {
        Position<ComparableReilOperand> rightNode;
        String rightValue;
        if (treeToBeCheckedForMatch.hasRight(parentNode) && (rightValue = (rightNode = treeToBeCheckedForMatch.right(parentNode)).element().getElement().getValue()).equalsIgnoreCase(toBeMatched)) {
            return rightNode;
        }
        return null;
    }

    public static Position<ComparableReilOperand> checkExactRootNodeValue(LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch, String toBeMatched) {
        Position<ComparableReilOperand> rootNode = treeToBeCheckedForMatch.root();
        String rootValue = rootNode.element().getElement().getValue();
        if (rootValue.equalsIgnoreCase(toBeMatched)) {
            return rootNode;
        }
        return null;
    }

    public static boolean checkIfFunctionHasCondition(OperandTreeMap operandTreeMap) {
        Set<ComparableReilOperand> operandTreeMapKeys = operandTreeMap.keySet();
        for (ComparableReilOperand operandTreeMapKey : operandTreeMapKeys) {
            if (!operandTreeMapKey.getValue().startsWith("COND")) continue;
            return true;
        }
        return false;
    }

    public static boolean checkIfPCisFunctionOfRegister(OperandTreeMap operandTreeMap) {
        ComparableReilOperand pcTree = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "PC"));
        LinkedBinaryTree<ComparableReilOperand> controlFlowTree = operandTreeMap.getTree(pcTree);
        for (Position<ComparableReilOperand> controlFlowTreePosition : controlFlowTree.positions()) {
            if (!controlFlowTree.isExternal(controlFlowTreePosition)) continue;
            OperandType controlFlowTreePositionType = controlFlowTreePosition.element().getElement().getType();
            String controlFlowTreePositionValue = controlFlowTreePosition.element().getElement().getValue();
            if (!controlFlowTreePositionType.equals((Object)OperandType.REGISTER) || controlFlowTreePositionValue.equalsIgnoreCase("R14")) continue;
            return true;
        }
        return false;
    }

    public static Position<ComparableReilOperand> checkIsLeftRegister(LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch, Position<ComparableReilOperand> parentNode) {
        Position<ComparableReilOperand> leftNode;
        if (treeToBeCheckedForMatch.hasLeft(parentNode) && ComparableReilOperandHelper.isNativeRegister((leftNode = treeToBeCheckedForMatch.left(parentNode)).element())) {
            return leftNode;
        }
        return null;
    }

    public static Position<ComparableReilOperand> checkIsRightRegister(LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch, Position<ComparableReilOperand> parentNode) {
        if (treeToBeCheckedForMatch.hasRight(parentNode)) {
            Position<ComparableReilOperand> rightNode = treeToBeCheckedForMatch.right(parentNode);
            String rightValue = rightNode.element().getElement().getValue();
            OperandType rightType = rightNode.element().getElement().getType();
            if (rightValue.startsWith("R") && rightType.equals((Object)OperandType.REGISTER)) {
                return rightNode;
            }
        }
        return null;
    }

    public static Position<ComparableReilOperand> checkIsRootInteger(LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch) {
        Position<ComparableReilOperand> rootNode = treeToBeCheckedForMatch.root();
        OperandType rootType = rootNode.element().getType();
        if (rootType.equals((Object)OperandType.INTEGER_LITERAL)) {
            return rootNode;
        }
        return null;
    }

    public static Position<ComparableReilOperand> checkIsRootRegister(LinkedBinaryTree<ComparableReilOperand> treeToBeCheckedForMatch) {
        Position<ComparableReilOperand> rootNode = treeToBeCheckedForMatch.root();
        if (ComparableReilOperandHelper.isNativeRegister(rootNode.element())) {
            return rootNode;
        }
        return null;
    }
}

