/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.datastructures.helpers;

import BinNavi.API.reil.OperandSize;
import BinNavi.API.reil.ReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.ComparableReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.helpers.ComparableReilOperandHelper;
import binnavi.plugins.gadgetfinder.datastructures.helpers.OperandTreeMapHelper;
import binnavi.plugins.gadgetfinder.datastructures.maps.AddressOperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.maps.OperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.node.Interfaces.Position;
import binnavi.plugins.gadgetfinder.datastructures.tree.LinkedBinaryTree;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AddressOperandTreeMapHelper {
    private static void generateConditionJumpNotTaken(LinkedBinaryTree<ComparableReilOperand> pcTree, OperandTreeMap currentAddressOperandTreeMap, Long currentAddressToPathElement) {
        ArrayList<Position<ComparableReilOperand>> pcNodePositionList = pcTree.find(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "PC")));
        for (Position<ComparableReilOperand> position : pcNodePositionList) {
            Position<ComparableReilOperand> sibling = pcTree.sibling(position);
            LinkedBinaryTree<ComparableReilOperand> conditionTree = pcTree.buildSubtree(sibling);
            ComparableReilOperand conditionTrueComparableReilOperand = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_EMPTY, "COND_" + Long.toHexString(currentAddressToPathElement) + "_TRUE"));
            currentAddressOperandTreeMap.storeTree(conditionTrueComparableReilOperand, conditionTree);
        }
    }

    private static void generateConditionJumpTaken(LinkedBinaryTree<ComparableReilOperand> pcTree, OperandTreeMap currentAddressOperandTreeMap, ComparableReilOperand nextAddressIntegerLiteralOperand, Long currentAddressToPathElement) {
        ArrayList<Position<ComparableReilOperand>> nextAddressPositionList = pcTree.find(nextAddressIntegerLiteralOperand);
        for (Position<ComparableReilOperand> position : nextAddressPositionList) {
            Position<ComparableReilOperand> sibling = pcTree.sibling(position);
            LinkedBinaryTree<ComparableReilOperand> conditionTree = pcTree.buildSubtree(sibling);
            ComparableReilOperand conditionTrueComparableReilOperand = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_EMPTY, "COND_" + Long.toHexString(currentAddressToPathElement) + "_TRUE"));
            currentAddressOperandTreeMap.storeTree(conditionTrueComparableReilOperand, conditionTree);
        }
    }

    public static boolean checkTreeSize(AddressOperandTreeMap addressToForests, int threshold) {
        for (Long key : addressToForests.keySet()) {
            if (OperandTreeMapHelper.checkTreeSize(addressToForests.get(key), threshold)) continue;
            return false;
        }
        return true;
    }

    public static OperandTreeMap jumpConditionDeterminator(AddressOperandTreeMap addressToForests, List<Long> addressToPathElementPath, Long currentAddressToPathElement) {
        ComparableReilOperand pcComparableReilOperand;
        OperandTreeMap currentAddressOperandTreeMap = addressToForests.get(currentAddressToPathElement);
        if (currentAddressOperandTreeMap.containsTree(pcComparableReilOperand = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "PC_CONDITIONAL_" + Long.toHexString(currentAddressToPathElement))))) {
            LinkedBinaryTree<ComparableReilOperand> pcTree = currentAddressOperandTreeMap.getTree(pcComparableReilOperand);
            if (pcTree.size == 1) {
                return currentAddressOperandTreeMap;
            }
            if (addressToPathElementPath.indexOf(currentAddressToPathElement) == addressToPathElementPath.size() - 1) {
                return currentAddressOperandTreeMap;
            }
            Long nextAddressInCurrentPath = addressToPathElementPath.get(addressToPathElementPath.indexOf(currentAddressToPathElement) + 1);
            ComparableReilOperand nextAddressIntegerLiteralOperand = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, nextAddressInCurrentPath.toString()));
            if (!pcTree.contains(nextAddressIntegerLiteralOperand)) {
                AddressOperandTreeMapHelper.generateConditionJumpNotTaken(pcTree, currentAddressOperandTreeMap, currentAddressToPathElement);
            } else {
                AddressOperandTreeMapHelper.generateConditionJumpTaken(pcTree, currentAddressOperandTreeMap, nextAddressIntegerLiteralOperand, currentAddressToPathElement);
            }
        }
        return currentAddressOperandTreeMap;
    }

    public static void printOperandTrees(AddressOperandTreeMap addressToForests) {
        System.out.println("[i] OperandTrees [i]");
        for (Long addressInForest : addressToForests.keySet()) {
            System.out.println("[i] ADDRESS :: " + Long.toHexString(addressInForest));
            System.out.println("[i] FOREST :: \n");
            OperandTreeMap currentOperandTreeMap = addressToForests.get(addressInForest);
            for (ComparableReilOperand value : currentOperandTreeMap.keySet()) {
                LinkedBinaryTree<ComparableReilOperand> currentExpressionTree = currentOperandTreeMap.getTree(value);
                System.out.println("[i] TREE :: " + value);
                Iterator<ComparableReilOperand> elementIterator = currentExpressionTree.iterator();
                while (elementIterator.hasNext()) {
                    ComparableReilOperand element = elementIterator.next();
                    System.out.println("Size " + element.getElement().getSize().toString() + " Value " + element.getElement().getValue());
                    if (!ComparableReilOperandHelper.isNativeRegister(element)) continue;
                    for (Position<ComparableReilOperand> position : currentExpressionTree.find(element)) {
                        if (currentExpressionTree.isExternal(position)) {
                            System.out.println("[i] REGISTER " + element.getElement().getValue() + " is external");
                            continue;
                        }
                        System.out.println("[i] REGISTER " + element.getElement().getValue() + " is internal");
                    }
                }
            }
        }
    }
}

