/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.datastructures.maps;

import BinNavi.API.disassembly.Address;
import binnavi.plugins.gadgetfinder.datastructures.ComparableReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.enums.GadgetType;
import binnavi.plugins.gadgetfinder.datastructures.maps.OperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.tree.LinkedBinaryTree;
import binnavi.plugins.gadgetfinder.helper.Pair;
import binnavi.plugins.gadgetfinder.helper.Triple;
import java.util.HashMap;
import java.util.Set;

public class GadgetTypeOperandTreeMap {
    private final HashMap<Triple<GadgetType, String, Address>, OperandTreeMap> m_hashmap = new HashMap();

    private Pair<Integer, Integer> complexity(Triple<GadgetType, String, Address> key) {
        Integer treeComplexity = 0;
        OperandTreeMap currentOperandTreeMap = this.m_hashmap.get(key);
        for (ComparableReilOperand operandTreeKey : currentOperandTreeMap.keySet()) {
            LinkedBinaryTree<ComparableReilOperand> currentLinkedBinaryTree = currentOperandTreeMap.getTree(operandTreeKey);
            treeComplexity = treeComplexity + currentLinkedBinaryTree.size();
        }
        Pair<Integer, Integer> complexityPair = new Pair<Integer, Integer>(this.m_hashmap.size(), treeComplexity);
        return complexityPair;
    }

    public OperandTreeMap get(Triple<GadgetType, String, Address> key) {
        return this.m_hashmap.get(key);
    }

    public HashMap<String, Triple<GadgetType, String, Address>> getLeastComplexGadgetForSpecificGadgetType(GadgetType type) {
        HashMap<String, Triple<GadgetType, String, Address>> leastComplexGadget = new HashMap<String, Triple<GadgetType, String, Address>>();
        HashMap<String, Integer> complexityMap = new HashMap<String, Integer>();
        for (Triple<GadgetType, String, Address> key : this.m_hashmap.keySet()) {
            if (!complexityMap.containsKey(key.second())) {
                complexityMap.put(key.second(), Integer.MAX_VALUE);
            }
            if (!key.first().equals((Object)type) || this.complexity(key).first() >= (Integer)complexityMap.get(key.second())) continue;
            leastComplexGadget.put(key.second(), key);
            complexityMap.put(key.second(), this.complexity(key).first());
        }
        return leastComplexGadget;
    }

    public int getNumberOfGadgetsForSpecificType(GadgetType type) {
        int numberOfGadgets = 0;
        for (Triple<GadgetType, String, Address> key : this.m_hashmap.keySet()) {
            if (key.first() != type) continue;
            ++numberOfGadgets;
        }
        return numberOfGadgets;
    }

    public boolean hasTree(Triple<GadgetType, String, Address> key) {
        return this.m_hashmap.containsKey(key);
    }

    public Set<Triple<GadgetType, String, Address>> keySet() {
        return this.m_hashmap.keySet();
    }

    public OperandTreeMap put(Triple<GadgetType, String, Address> key, OperandTreeMap value) {
        return this.m_hashmap.put(key, value);
    }

    public int size() {
        return this.m_hashmap.size();
    }
}

